/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.adf.share.services.ServicePlugin;
import oracle.adf.share.services.Services;
import oracle.adf.share.services.impl.ServicesEnumeration;

public class ADFServicesImpl
implements Services {
    private List<ServicePlugin> plugins = null;
    private URL url = null;

    private static final URL newURL(String urlStr) {
        try {
            return new URL(urlStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ADFServicesImpl(URL url, ServicesEnumeration svcsEnum) {
        String proto = url.getProtocol();
        if ("code-source".equalsIgnoreCase(proto) || "zip".equalsIgnoreCase(proto)) {
            String urlStr = url.toString();
            int colon = urlStr.indexOf(58);
            this.url = url.getPath().indexOf(33) == -1 ? ADFServicesImpl.newURL("file" + urlStr.substring(colon)) : ADFServicesImpl.newURL("jar:file" + urlStr.substring(colon));
        } else {
            this.url = url;
        }
        this.plugins = new ArrayList<ServicePlugin>();
        Map<String, List<String>> resourceHolder = svcsEnum.getResourceHolder();
        HashSet<String> nonBrowsables = svcsEnum.getNonBrowsables();
        while (svcsEnum.hasMoreElements()) {
            this.plugins.add(new ServicePlugin(svcsEnum.nextElement(), resourceHolder, nonBrowsables));
        }
    }

    @Override
    public List<ServicePlugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public URL getServiceURL() {
        return this.url;
    }
}

