/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.services.DescriptorContext;
import oracle.adf.share.services.ResourceServiceStrategy;
import oracle.adf.share.services.Tokenizable;
import oracle.adf.share.services.URLDescriptor;
import oracle.javatools.annotations.Concealed;

@Concealed
public class ServicePlugin {
    private static final Logger logger = Logger.getLogger(ServicePlugin.class.getName());
    protected boolean browsable = true;
    protected List<String> tokenizedResources = null;
    protected List<URLDescriptor> cachedResults = null;
    protected String serviceType = null;
    protected String strategyClassName = null;
    protected String remainder = null;
    protected ResourceServiceStrategy strategyInstance = null;

    public ServicePlugin(String serviceLine) {
        this(serviceLine, null, null);
        logger.log(Level.FINE, "", new Throwable("This constructor is deprecated"));
    }

    public ServicePlugin(String serviceLine, Map<String, List<String>> resourceHolder, HashSet<String> nonBrowsables) {
        serviceLine = serviceLine.trim();
        int i = serviceLine.indexOf(32);
        if (i == -1) {
            throw new IllegalArgumentException(serviceLine);
        }
        int j = serviceLine.indexOf(32, i + 1);
        if (j == -1) {
            j = serviceLine.length();
        } else {
            this.remainder = serviceLine.substring(j + 1);
        }
        this.strategyClassName = serviceLine.substring(0, i);
        this.serviceType = serviceLine.substring(i + 1, j);
        List<String> list = this.tokenizedResources = resourceHolder != null ? resourceHolder.get(this.serviceType) : null;
        this.browsable = nonBrowsables != null ? !nonBrowsables.contains(this.serviceType) : true;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getStrategyClassName() {
        return this.strategyClassName;
    }

    public String getRemainder() {
        return this.remainder;
    }

    public boolean isBrowsable() {
        return this.browsable;
    }

    public String getToolTipText() {
        return null;
    }

    public ResourceServiceStrategy getServiceStrategy(DescriptorContext ctx) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.strategyInstance == null) {
            Class strategyClass = ClassUtils.forName(this.strategyClassName, ServicePlugin.class);
            try {
                Constructor ctor = strategyClass.getConstructor(DescriptorContext.class);
                this.strategyInstance = (ResourceServiceStrategy)ctor.newInstance(ctx);
                return this.strategyInstance;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.strategyInstance = (ResourceServiceStrategy)strategyClass.newInstance();
            }
        }
        return this.strategyInstance;
    }

    public void setServiceStrategy(ResourceServiceStrategy instance) {
        if (this.strategyInstance != null) {
            throw new IllegalStateException();
        }
        this.strategyInstance = instance;
    }

    public int hashCode() {
        return this.serviceType.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ServicePlugin) {
            return this.serviceType.equals(((ServicePlugin)obj).serviceType);
        }
        return this.serviceType.equals(obj);
    }

    public String toString() {
        if (this.remainder == null) {
            return this.strategyClassName + " " + this.serviceType;
        }
        return this.strategyClassName + " " + this.serviceType + " " + this.remainder;
    }

    public List<URLDescriptor> getTokenizedResources(DescriptorContext dctx) {
        if (this.tokenizedResources == null || this.tokenizedResources == Collections.EMPTY_LIST) {
            return null;
        }
        if (this.cachedResults == null) {
            HashMap<String, Class> fqcnMap = new HashMap<String, Class>();
            ArrayList<URLDescriptor> results = new ArrayList<URLDescriptor>(this.tokenizedResources.size());
            for (String resStr : this.tokenizedResources) {
                int fqcnx = resStr.indexOf(58);
                if (fqcnx == -1) {
                    if (!logger.isLoggable(Level.INFO)) continue;
                    logger.log(Level.INFO, this.serviceType + ": couldn't find FQCN in " + resStr);
                    continue;
                }
                String fqcn = resStr.substring(0, fqcnx);
                try {
                    URLDescriptor descr;
                    Class c = (Class)fqcnMap.get(fqcn);
                    if (c == null) {
                        c = ClassUtils.forName(fqcn, URLDescriptor.class);
                        fqcnMap.put(fqcn, c);
                    }
                    if (!((Tokenizable)((Object)(descr = (URLDescriptor)c.newInstance()))).readToken(resStr.substring(fqcnx + 1), dctx)) continue;
                    results.add(descr);
                }
                catch (Exception x) {
                    logger.log(Level.WARNING, "", x);
                }
            }
            this.cachedResults = results;
        }
        return this.cachedResults;
    }
}

