/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import oracle.adf.share.services.DescriptorContext;
import oracle.adf.share.services.DescriptorFilter;
import oracle.adf.share.services.URLDescriptor;

public class DefaultDescriptorFilter
implements DescriptorFilter {
    private boolean visible;
    private final Map<String, Set<String>> visData;

    public DefaultDescriptorFilter(boolean visible, Map<String, Set<String>> visData) {
        this.visible = visible;
        this.visData = visData;
    }

    public DefaultDescriptorFilter() {
        this.visible = true;
        this.visData = new HashMap<String, Set<String>>(2);
        HashSet<String> s = new HashSet<String>(Arrays.asList("Oracle*"));
        this.visData.put(Attributes.Name.SPECIFICATION_VENDOR.toString(), s);
        this.visData.put(Attributes.Name.IMPLEMENTATION_VENDOR.toString(), s);
    }

    @Override
    public boolean isDescriptorVisible(URLDescriptor descr, DescriptorContext context) {
        return this.visible;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName());
        buf.append(", visible=" + this.visible);
        buf.append(", " + this.visData.toString());
        return buf.toString();
    }
}

