/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.mt.util;

import java.util.logging.Level;
import oracle.adf.share.mt.util.CloudHelper;
import oracle.adf.share.mt.util.MultiTenantStorage;

public class MultiPartitionStorage<T>
extends MultiTenantStorage<T> {
    @Override
    protected MultiTenantStorage.ValueStorage<T> initValueStorage() {
        return CloudHelper.isMultitenancySupportable() ? new PartitionValueStorage() : new MultiTenantStorage.SingleValueStorage();
    }

    @Override
    protected MultiTenantStorage.Holder<T> newHolder(T value, Object key) {
        return logger.isLoggable(Level.FINER) ? new PartitionDiagnosticHolder<T>(value, this, key) : new MultiTenantStorage.Holder<T>(value, this);
    }

    private static class PartitionDiagnosticHolder<T>
    extends MultiTenantStorage.DiagnosticHolder<T> {
        public PartitionDiagnosticHolder(T value, MultiTenantStorage<T> mts, Object key) {
            super(value, mts, key);
        }

        @Override
        protected Object getStripingKey() {
            return CloudHelper.getPartitionKeyOrThrow();
        }
    }

    private static class PartitionValueStorage<T>
    extends MultiTenantStorage.MultiValueStorage<T> {
        private PartitionValueStorage() {
        }

        @Override
        protected Object getStripingKey() {
            return CloudHelper.getPartitionKeyOrThrow();
        }
    }
}

