/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.mt.util;

import java.beans.Beans;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.mt.util.CloudHelperJRF;
import oracle.adf.share.platform.AdfServerPlatformUtil;

class CloudHelper {
    private static final Logger logger = Logger.getLogger(CloudHelper.class.getName());

    private CloudHelper() {
    }

    public static boolean isMultitenancySupportable() {
        return SingletonHolder.mtSupportable;
    }

    public static Object getTenantKeyOrThrow() {
        Object uuid = SingletonHolder.jrfHelper.getServiceUUID();
        if (uuid == null) {
            throw new NullPointerException("ServiceUUID");
        }
        return uuid;
    }

    public static Object getPartitionKeyOrThrow() {
        String pn = SingletonHolder.jrfHelper.getPartitionName();
        if (pn == null || pn.isEmpty()) {
            if (SingletonHolder.isWebLogic) {
                throw new NullPointerException("PartitionName");
            }
            return "DOMAIN";
        }
        return pn;
    }

    static boolean isWebLogic() {
        return SingletonHolder.isWebLogic;
    }

    private static class SingletonHolder {
        static final boolean isWebLogic;
        private static final CloudHelperJRF jrfHelper;
        private static final boolean mtSupportable;

        private SingletonHolder() {
        }

        static {
            CloudHelperJRF ret;
            block8: {
                isWebLogic = AdfServerPlatformUtil.isWebLogicJRF();
                ret = null;
                try {
                    if (!Beans.isDesignTime() && !AdfServerPlatformUtil.isWebLogicCore()) {
                        if (ClassUtils.getClassLoader(CloudHelper.class).getResource("com/oracle/jrf/mt/tenant/runtime/TenantContextFactory.class") == null) {
                            throw new IllegalStateException("com/oracle/jrf/mt/tenant/runtime/TenantContextFactory.class");
                        }
                        ret = new CloudHelperJRF();
                        if (ret.getServiceUUID() == null) {
                            throw new IllegalStateException("ServiceUUID");
                        }
                        String partName = ret.getPartitionName();
                        if ((partName == null || partName.isEmpty()) && isWebLogic) {
                            throw new IllegalStateException("PartitionName");
                        }
                    }
                }
                catch (Throwable t) {
                    ret = null;
                    if (isWebLogic) {
                        if (logger.isLoggable(AdfServerPlatformUtil.INCIDENT_ERROR)) {
                            logger.log(AdfServerPlatformUtil.INCIDENT_ERROR, "", t);
                        }
                    }
                    if (!logger.isLoggable(Level.CONFIG)) break block8;
                    logger.log(Level.CONFIG, "FALSE: " + t + (logger.isLoggable(Level.FINE) ? "" : ". Use FINE level for details."), logger.isLoggable(Level.FINE) ? t : null);
                }
            }
            jrfHelper = ret;
            mtSupportable = ret != null;
        }
    }
}

