/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.perf;

import java.beans.Beans;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.util.AdfPlatformFactoryResolver;
import oracle.adf.share.logging.internal.perf.ADFPerfSensor;
import oracle.adf.share.mt.util.MultiPartitionStorage;
import oracle.adf.share.platform.AdfServerPlatformSupport;
import oracle.adf.share.platform.UnknownPlatformException;
import oracle.jrf.Application;

public class SensorTable {
    private static final Logger logger = Logger.getLogger(SensorTable.class.getName());
    private static final String DEFAULT_APP_ID = "defaultApplicationName";
    private static final MultiPartitionStorage<ConcurrentHashMap<String, ConcurrentHashMap<String, ADFPerfSensor>>> sSensors = new MultiPartitionStorage<ConcurrentHashMap<String, ConcurrentHashMap<String, ADFPerfSensor>>>(){

        @Override
        protected ConcurrentHashMap<String, ConcurrentHashMap<String, ADFPerfSensor>> initialValue() {
            return new ConcurrentHashMap<String, ConcurrentHashMap<String, ADFPerfSensor>>();
        }
    };
    private static final Function<String, ConcurrentHashMap<String, ADFPerfSensor>> sensorFunc = new Function<String, ConcurrentHashMap<String, ADFPerfSensor>>(){

        @Override
        public ConcurrentHashMap<String, ADFPerfSensor> apply(String k) {
            return new ConcurrentHashMap<String, ADFPerfSensor>();
        }
    };
    private static final ThreadLocal<String> tlAppId = new ThreadLocal();
    private static final WeakHashMap<ClassLoader, Object> upeMap = new WeakHashMap();
    private static final Object MARKER = new Object();

    private static ConcurrentHashMap<String, ADFPerfSensor> getSensors(int flags, String appKeyParam, String sensorName) {
        ConcurrentHashMap sensors = null;
        String appId = appKeyParam != null ? appKeyParam : SensorTable.getCurrentAppId();
        ConcurrentHashMap allTab = (ConcurrentHashMap)sSensors.get();
        if ((flags & 2) > 0) {
            if (DEFAULT_APP_ID == appId && allTab.size() > 1 && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Removing default appKey while others remain, appTab.size=" + allTab.size(), new Throwable("DIAGNOSTIC AID, NOT AN ERROR"));
            }
            sensors = (ConcurrentHashMap)allTab.remove(appId);
        } else {
            ADFPerfSensor migr;
            sensors = allTab.computeIfAbsent(appId, sensorFunc);
            ConcurrentHashMap dftTab = (ConcurrentHashMap)allTab.get(DEFAULT_APP_ID);
            if (dftTab != null && sensorName != null && (migr = (ADFPerfSensor)dftTab.remove(sensorName)) != null) {
                sensors.put(sensorName, migr);
            }
        }
        return sensors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ADFPerfSensor putSensor(String name, ADFPerfSensor sensor) {
        ConcurrentHashMap<String, ADFPerfSensor> sensors;
        ConcurrentHashMap<String, ADFPerfSensor> concurrentHashMap = sensors = SensorTable.getSensors(1, null, name);
        synchronized (concurrentHashMap) {
            sensors.putIfAbsent(name, sensor);
        }
        return (ADFPerfSensor)sensors.get(name);
    }

    public static ADFPerfSensor getSensor(String name) {
        return SensorTable.getSensors(0, null, name).get(name);
    }

    @Deprecated
    public static void cleanupSensors(ClassLoader clsLoader) {
        ConcurrentHashMap<String, ADFPerfSensor> sensors = SensorTable.getSensors(2, null, null);
        if (sensors != null) {
            for (ADFPerfSensor s : sensors.values()) {
                s.reset();
            }
        }
    }

    public static void cleanupAppSensors(String appId) {
        ConcurrentHashMap<String, ADFPerfSensor> sensors = SensorTable.getSensors(1, appId, null);
        if (sensors != null) {
            for (ADFPerfSensor s : sensors.values()) {
                s.reset();
            }
        }
    }

    public static void destroyAppSensors(String appId) {
        ConcurrentHashMap<String, ADFPerfSensor> sensors = SensorTable.getSensors(2, appId, null);
        if (sensors != null) {
            for (ADFPerfSensor s : sensors.values()) {
                s.destroy();
            }
        }
    }

    public static void setAppIdTL(String appId) {
        tlAppId.set(appId);
    }

    private static String getCurrentAppId() {
        block7: {
            String appId = tlAppId.get();
            if (appId != null) {
                return appId;
            }
            if (upeMap.get(ClassUtils.getClassLoader(SensorTable.class)) == null) {
                try {
                    AdfServerPlatformSupport helper = AdfPlatformFactoryResolver.getAdfServerPlatformSupport();
                    Application id = helper.getApplication();
                    String idStr = id.getDeploymentName();
                    if (idStr != null) {
                        return idStr;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "null app id", new Throwable("DIAGNOSTIC AID"));
                    }
                }
                catch (Throwable t) {
                    if (t instanceof UnknownPlatformException) {
                        upeMap.put(ClassUtils.getClassLoader(SensorTable.class), MARKER);
                    }
                    if (Beans.isDesignTime() || !logger.isLoggable(Level.FINE)) break block7;
                    logger.log(Level.FINE, "", logger.isLoggable(Level.FINEST) ? t : null);
                }
            }
        }
        return DEFAULT_APP_ID;
    }
}

