/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.perf;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.logging.ErrorManager;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.adf.share.logging.handler.InternalADFHandler;
import oracle.adf.share.logging.internal.BaseFileHandler;
import oracle.adf.share.logging.internal.LoggingConstants;
import oracle.adf.share.logging.internal.LoggingUtils;
import oracle.adf.share.logging.internal.perf.PerfFormatter;
import oracle.adf.share.logging.internal.perf.PerfLogRecord;

public class PerfFileHandler
extends BaseFileHandler {
    private PerfFileHandler(String pattern, int limit, int count, boolean append, int bufSize) throws IOException, SecurityException {
        super(pattern, limit, count, append, bufSize);
        this.setFormatter(new PerfFormatter());
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        if (!(record instanceof PerfLogRecord)) {
            super.publish(record);
            return;
        }
        String ecid = ((PerfLogRecord)record).getEcid();
        if (ecid == null) {
            ecid = LoggingUtils.getECID();
            ((PerfLogRecord)record).setEcid(ecid);
        }
        ecid = this.addRecordToList(record, ecid);
        LinkedList recordList = null;
        if (ecid != null && this.isRecordListTooLong(ecid)) {
            recordList = this.removeList(ecid);
        } else if (this.isBufferFull()) {
            ecid = this.getLeastAccessedECID();
            recordList = this.removeList(ecid);
        }
        if (recordList != null) {
            this.printList(ecid, recordList);
        }
    }

    static FileHandler setupLoggers(Logger mainLogger, Logger idxLogger) {
        InternalADFHandler internalHandler = null;
        Handler[] handlers = mainLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            if (!(handlers[i] instanceof InternalADFHandler)) continue;
            internalHandler = (InternalADFHandler)handlers[i];
            break;
        }
        if (internalHandler == null) {
            if (System.getSecurityManager() == null) {
                mainLogger.setLevel(Level.OFF);
                idxLogger.setLevel(Level.OFF);
            } else {
                final Logger smainLogger = mainLogger;
                final Logger sidxLogger = idxLogger;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        smainLogger.setLevel(Level.OFF);
                        sidxLogger.setLevel(Level.OFF);
                        return null;
                    }
                });
            }
            return null;
        }
        try {
            internalHandler.close();
            mainLogger.removeHandler((Handler)internalHandler);
            mainLogger.addHandler(new PerfFileHandler(internalHandler.mPattern, internalHandler.mLimit, internalHandler.mCount, internalHandler.mAppend, internalHandler.mBufSize));
        }
        catch (IOException e) {
            ErrorManager errMgr = new ErrorManager();
            ResourceBundle rb = ResourceBundle.getBundle("oracle.adf.share.logging.internal.resources.LogHandlerMessageBundle");
            errMgr.error(rb.getString("FAILED_TO_ADD_PERFHANDLER"), e, 0);
            mainLogger.setLevel(Level.OFF);
            idxLogger.setLevel(Level.OFF);
            return null;
        }
        idxLogger.setLevel(mainLogger.getLevel());
        idxLogger.setUseParentHandlers(false);
        FileHandler handler = null;
        try {
            handler = new FileHandler(internalHandler.mPath + LoggingConstants.FILE_SEPARATOR + "adfperf" + ".log", false);
            handlers = idxLogger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                idxLogger.removeHandler(handlers[i]);
            }
            idxLogger.addHandler(handler);
            handler.setFormatter(new PerfFormatter());
            return handler;
        }
        catch (IOException e) {
            ErrorManager errMgr = new ErrorManager();
            ResourceBundle rb = ResourceBundle.getBundle("oracle.adf.share.logging.internal.resources.LogHandlerMessageBundle");
            errMgr.error(rb.getString("FAILED_TO_ADD_INDEX_LOGGER"), e, 0);
            mainLogger.setLevel(Level.OFF);
            idxLogger.setLevel(Level.OFF);
            return null;
        }
    }
}

