/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.logging.ADFLoggerUtil;
import oracle.adf.share.platform.AdfServerPlatformUtil;
import oracle.core.ojdl.logging.ODLLogRecord;
import oracle.core.ojdl.logging.ODLLogger;

public class ADFLoggerODLHelper {
    private static final ADFLogger utilLogger = ADFLogger.createADFLogger(ADFLoggerODLHelper.class);
    public static final String ADF_LOGGER_MESSAGE_BUNDLE = "oracle.adf.share.logging.resources.LoggerMessageBundle";

    private Logger getMyLogger(String loggerName) {
        return !AdfServerPlatformUtil.isODLAvailable() ? Logger.getLogger(loggerName) : ODLLogger.getODLLogger((String)loggerName);
    }

    public void beginPS(String loggerName, String actionName, HashMap<String, String> contextData) {
        Logger logger = this.getMyLogger(loggerName);
        if (logger.isLoggable(Level.CONFIG) && actionName != null) {
            HashMap<String, String> cntx = new HashMap();
            cntx = this.prepareBeginContext(logger, actionName, contextData, "begin");
            try {
                if (!AdfServerPlatformUtil.isODLAvailable()) {
                    logger.log(Level.CONFIG, actionName + " " + ADFLoggerUtil.convertContextDataMap(cntx));
                } else {
                    ((ODLLogger)logger).log(Level.CONFIG, actionName, null, cntx);
                }
            }
            catch (Exception e) {
                utilLogger.severe(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("EXCEPTION_LOGGING_A_MESSAGE") + e.getMessage());
            }
        }
    }

    public void beginNodePS(String loggerName, Level level, String actionName, Map<String, String> contextData, String methodName) {
        Logger logger = this.getMyLogger(loggerName);
        if (logger.isLoggable(level) && actionName != null) {
            HashMap<String, String> cntx = new HashMap();
            if (contextData == null) {
                contextData = new HashMap<String, String>();
            }
            cntx = this.prepareBeginContext(logger, actionName, new HashMap<String, String>(contextData), methodName);
            try {
                if (!AdfServerPlatformUtil.isODLAvailable()) {
                    logger.log(level, actionName + " " + ADFLoggerUtil.convertContextDataMap(cntx));
                } else {
                    ((ODLLogger)logger).log(level, actionName, null, cntx);
                }
            }
            catch (Exception e) {
                utilLogger.severe(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("EXCEPTION_LOGGING_A_MESSAGE") + e.getMessage());
            }
        }
    }

    public void addContextDataPS(String loggerName, String actionName, HashMap<String, String> contextData) {
        Logger logger = this.getMyLogger(loggerName);
        if (logger.isLoggable(Level.CONFIG)) {
            HashMap<String, String> cntx = new HashMap();
            cntx = this.prepareMessageContext(contextData, actionName, "addContextData", "add_context_data");
            try {
                if (!AdfServerPlatformUtil.isODLAvailable()) {
                    logger.log(Level.CONFIG, actionName + " " + ADFLoggerUtil.convertContextDataMap(cntx));
                } else {
                    ((ODLLogger)logger).log(Level.CONFIG, actionName, null, cntx);
                }
            }
            catch (Exception e) {
                utilLogger.severe(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("EXCEPTION_LOGGING_A_MESSAGE") + e.getMessage());
            }
        }
    }

    public void addMessageToRequestPS(String loggerName, Level level, String actionName, Map<String, String> contextData, String messageTag, String methodName, Throwable thrown) {
        Logger logger = this.getMyLogger(loggerName);
        if (logger.isLoggable(level)) {
            HashMap<String, String> cntx = new HashMap();
            cntx = this.prepareMessageContext(new HashMap<String, String>(contextData), actionName, methodName, messageTag);
            try {
                if (AdfServerPlatformUtil.isODLAvailable()) {
                    ODLLogRecord rec = new ODLLogRecord(level, actionName);
                    rec.setSupplAttributes(cntx);
                    if (thrown != null) {
                        rec.setThrown(thrown);
                    }
                    logger.log((LogRecord)rec);
                } else {
                    LogRecord rec = new LogRecord(level, actionName + " " + ADFLoggerUtil.convertContextDataMap(cntx));
                    if (thrown != null) {
                        rec.setThrown(thrown);
                    }
                    logger.log(rec);
                }
            }
            catch (Exception e) {
                utilLogger.severe(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("EXCEPTION_LOGGING_A_MESSAGE") + e.getMessage());
            }
        }
    }

    public void endNodePS(String loggerName, Level level, String actionName) {
        Logger logger = this.getMyLogger(loggerName);
        if (logger.isLoggable(level)) {
            HashMap<String, String> cntx = new HashMap<String, String>();
            cntx.put("ADF_MESSAGE_STATUS", "end");
            cntx.put("ADF_MESSAGE_ACTION_NAME", actionName);
            try {
                if (!AdfServerPlatformUtil.isODLAvailable()) {
                    logger.log(level, actionName + " " + ADFLoggerUtil.convertContextDataMap(cntx));
                } else {
                    ((ODLLogger)logger).log(level, actionName, null, cntx);
                }
            }
            catch (Exception e) {
                utilLogger.severe(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("EXCEPTION_LOGGING_A_MESSAGE") + e.getMessage());
            }
        }
    }

    public void LogRelativeADFRequest(String loggerName, String parentEcid) {
        Logger logger = this.getMyLogger(loggerName);
        if (logger.isLoggable(Level.CONFIG)) {
            HashMap<String, String> cntx = new HashMap<String, String>();
            cntx.put("ADF_MESSAGE_STATUS", "PARENT_REQUEST_ECID");
            cntx.put("PARENT_REQUEST_ECID", parentEcid);
            try {
                if (!AdfServerPlatformUtil.isODLAvailable()) {
                    logger.log(Level.CONFIG, "Secondary ADF Request " + ADFLoggerUtil.convertContextDataMap(cntx));
                } else {
                    ((ODLLogger)logger).log(Level.CONFIG, "Secondary ADF Request", null, cntx);
                }
            }
            catch (Exception e) {
                utilLogger.severe(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("EXCEPTION_LOGGING_A_MESSAGE") + e.getMessage());
            }
        }
    }

    private Map<String, String> prepareBeginContext(Logger logger, String actionName, HashMap<String, String> contextData, String methodName) {
        HashMap<String, String> map;
        String ctxData;
        ResourceBundle rb = logger.getResourceBundle();
        String actionDesc = "";
        String disCol = "";
        String disColValue = "";
        if (rb != null) {
            String actionNamePrefix = actionName.trim().replace(' ', '_');
            try {
                actionDesc = rb.getString(actionNamePrefix + "_DESC");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                disCol = rb.getString(actionNamePrefix + "_DISPLAY_COL");
                String val = contextData.get(disCol);
                if (val != null) {
                    disColValue = val;
                }
            }
            catch (MissingResourceException val) {
                // empty catch block
            }
        }
        HashMap<String, String> cntx = new HashMap<String, String>();
        if (contextData == null || !ADFLoggerUtil.isADFComponentAdded(contextData)) {
            cntx.put("Component", ADFLoggerUtil.getModuleName(methodName));
        }
        if ((ctxData = ADFLoggerUtil.convertContextDataMap(map = new HashMap<String, String>(contextData))).length() > 0) {
            cntx.put("ADF_MESSAGE_CONTEXT_DATA", ctxData);
        }
        cntx.put("ADF_MESSAGE_ACTION_NAME", actionName);
        cntx.put("ADF_MESSAGE_ACTION_DESC", actionDesc);
        cntx.put("ADF_MESSAGE_STATUS", "begin");
        if (disCol != null && disCol.trim().length() > 0) {
            cntx.put("ADF_MESSAGE_DEFAULT_CONTEXT_DATA", disCol + "=" + disColValue);
        }
        return cntx;
    }

    private Map<String, String> prepareMessageContext(HashMap<String, String> contextData, String actionName, String methodName, String messageTag) {
        HashMap<String, String> map;
        String ctxData;
        HashMap<String, String> cntx = new HashMap<String, String>();
        if (contextData == null || !ADFLoggerUtil.isADFComponentAdded(contextData)) {
            cntx.put("Component", ADFLoggerUtil.getModuleName(methodName));
        }
        if ((ctxData = ADFLoggerUtil.convertContextDataMap(map = new HashMap<String, String>(contextData))).length() > 0) {
            cntx.put("ADF_MESSAGE_CONTEXT_DATA", ctxData);
        }
        cntx.put("ADF_MESSAGE_ACTION_NAME", actionName);
        cntx.put("ADF_MESSAGE_STATUS", messageTag);
        return cntx;
    }
}

