/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.rc.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.common.rc.util.LoaderUtil;
import oracle.adf.share.common.util.ADFJarUtil;
import oracle.adf.share.services.ServicesFactory;

public class LibraryUtils {
    private static final Logger logger = Logger.getLogger(LibraryUtils.class.getName());
    private static final String RESOURCE_SERVICE_NAME = "oracle.adf.common.services.ResourceService";
    @CodeSharingSafe(value="MutableStaticField")
    private static final String RESOURCE_SIGNATURE = ServicesFactory.getServiceFileName("oracle.adf.common.services.ResourceService");
    private static final int SIGNATURE_SUB_LEN = RESOURCE_SIGNATURE.length();
    private static final String MODULES_DIR = "/modules/";
    private static final int MODULES_DIR_LEN = "/modules/".length();
    private static final String ORACLE_PREFIX = "oracle.";
    private static final int ORACLE_PREFIX_LEN = "oracle.".length();
    private static final String COM_ORACLE_PREFIX = "com.oracle.";
    private static final int COM_ORACLE_PREFIX_LEN = "com.oracle.".length();

    private LibraryUtils() {
    }

    public static boolean hasADFJars(ClassLoader loader) {
        return loader.getResource(RESOURCE_SIGNATURE) != null;
    }

    public static URL[] getADFLibraryURLs(ClassLoader loader) throws IOException {
        LinkedList<URL> retList = new LinkedList<URL>();
        Enumeration<URL> resourceEnum = loader.getResources(RESOURCE_SIGNATURE);
        while (resourceEnum.hasMoreElements()) {
            String urlStr = resourceEnum.nextElement().toString();
            urlStr = urlStr.substring(0, urlStr.length() - SIGNATURE_SUB_LEN);
            retList.add(new URL(urlStr));
        }
        if (retList.size() == 0) {
            return new URL[0];
        }
        return retList.toArray(new URL[0]);
    }

    public static URL[] getADFJarsInDir(File dir) throws IOException {
        String[] childEntries = dir.list();
        if (childEntries == null || childEntries.length == 0) {
            return new URL[0];
        }
        ArrayList<URL> allJars = new ArrayList<URL>();
        for (String childName : childEntries) {
            String entryExtn;
            if (childName.length() < ".jar".length() || !".jar".equalsIgnoreCase(entryExtn = childName.substring(childName.length() - ".jar".length()))) continue;
            File jarChild = new File(dir, childName);
            allJars.add(new URL("jar:file:" + jarChild.getAbsolutePath() + "!/"));
        }
        if (allJars.size() == 0) {
            return new URL[0];
        }
        return LibraryUtils.getADFLibraryURLs(LoaderUtil.getLoader(allJars.toArray(new URL[0]), null));
    }

    public static List<URL> filterNonADFItems(Collection<URL> items) {
        return LibraryUtils.filterNonADFItems(items, false, true);
    }

    public static List<URL> filterNonADFItems(Collection<URL> items, boolean jarOnly) {
        return LibraryUtils.filterNonADFItems(items, jarOnly, true);
    }

    public static List<URL> filterNonADFItems(Collection<URL> items, boolean jarOnly, boolean useResourceLookup) {
        if (items == null || items.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<URL> wrk = new ArrayList<URL>(items.size());
        for (URL url : items) {
            int x;
            String proto;
            String path = url.getPath();
            if (jarOnly && ((proto = url.getProtocol()).equals("file") && !path.endsWith("jar") && !path.endsWith("zip") || !ADFJarUtil.isJarProtocol(url) && path.lastIndexOf(33) == -1 && !path.endsWith("jar") && !path.endsWith("zip")) || ((x = path.indexOf(MODULES_DIR)) == -1 ? path.indexOf("/weblogic.jar") != -1 || path.indexOf("/ant/lib/") != -1 || path.indexOf("/webservices/lib/") != -1 || path.indexOf("/xdo/lib/") != -1 || path.indexOf("/jsf-ri/") != -1 : ((path = path.substring(x + MODULES_DIR_LEN)).startsWith(ORACLE_PREFIX) ? LibraryUtils.isNonADFOracle(path = path.substring(ORACLE_PREFIX_LEN)) : (path.startsWith(COM_ORACLE_PREFIX) ? LibraryUtils.isNonADFOracle(path = path.substring(COM_ORACLE_PREFIX_LEN)) : path.startsWith("javax.") || path.startsWith("jsf.") || path.startsWith("groovy-") || path.startsWith("org.apache.ant.") || path.startsWith("org.apache.ant_") || path.startsWith("org.apache.bcel_") || path.startsWith("org.apache.commons.") || path.startsWith("org.apache.openjpa_") || path.startsWith("org.eclipse.") || path.startsWith("glassfish.") || path.startsWith("jakarta.") || path.startsWith("com.bea."))))) continue;
            if (logger.isLoggable(Level.FINER) && path.indexOf("/adflib") == -1) {
                logger.finer(String.valueOf(url));
            }
            wrk.add(url);
        }
        if (!useResourceLookup) {
            return wrk;
        }
        try {
            if (wrk.size() > 0) {
                URL[] adfItems = LibraryUtils.getADFLibraryURLs(LoaderUtil.getLoader(wrk.toArray(new URL[0]), null));
                return Arrays.asList(adfItems);
            }
        }
        catch (OutOfMemoryError oom) {
            logger.log(Level.INFO, "wrk=" + String.valueOf(wrk), oom);
            throw oom;
        }
        catch (Exception e) {
            logger.log(Level.INFO, wrk.toString(), e);
        }
        return Collections.emptyList();
    }

    private static final boolean isNonADFOracle(String path) {
        return path.startsWith("jrf_") || path.startsWith("javatools_") || path.startsWith("bali.") || path.startsWith("bulkops_") || path.startsWith("cie.") || path.startsWith("classloader_") || path.startsWith("dms_") || path.startsWith("ejb_") || path.startsWith("help_") || path.startsWith("http_") || path.startsWith("iau_") || path.startsWith("identitystore_") || path.startsWith("identityutils_") || path.startsWith("idm_") || path.startsWith("igf_") || path.startsWith("jacc-") || path.startsWith("jdbc_") || path.startsWith("jmx_") || path.startsWith("jps-") || path.startsWith("jps_") || path.startsWith("jsf_") || path.startsWith("jsp_") || path.startsWith("ldap_") || path.startsWith("mds_") || path.startsWith("nlsrtl_") || path.startsWith("ocm_") || path.startsWith("oraclepki_") || path.startsWith("odl_") || path.startsWith("osdt_") || path.startsWith("pki_") || path.startsWith("pwdgen_") || path.startsWith("security-") || path.startsWith("sslconfig_") || path.startsWith("ssofilter_") || path.startsWith("toplink_") || path.startsWith("ucp_") || path.startsWith("uix_") || path.startsWith("weblogic.") || path.startsWith("webservices_") || path.startsWith("ws.") || path.startsWith("wsm.") || path.startsWith("xdb_") || path.startsWith("xdk_") || path.startsWith("xds_") || path.startsWith("xmlef_") || path.startsWith("xqs-");
    }
}

