/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public class UIStringUtils {
    public static String convertDescription(String string) {
        String string2 = string.replace("_", " ");
        return string2;
    }

    public static boolean isObjectNameAndDescriptionEqual(String string, String string2) {
        if (string == null || string2 == null || string.length() != string2.length()) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            Character c = Character.valueOf(Character.toUpperCase(string.charAt(i)));
            Character c2 = Character.valueOf(Character.toUpperCase(string2.charAt(i)));
            if (c.charValue() == ' ' && c2.charValue() == '_' || c.charValue() == '_' && c2.charValue() == ' ' || c == c2) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static String capitalizeFirstLetter(String string) {
        if (string.length() == 0) {
            return "";
        }
        return String.format("%s%s", string.substring(0, 1).toUpperCase(), string.substring(1));
    }

    public static String setupTextForDescriptions(String string) {
        string = string.toLowerCase();
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("_");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(String.format("%s ", UIStringUtils.capitalizeFirstLetter(stringArray[i])));
        }
        return stringBuffer.toString().trim();
    }

    public static void setKeyAdapterToNameField(JTextField jTextField) {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == ' ' || keyEvent.getKeyChar() == '.' || keyEvent.getKeyChar() == '\"') {
                    Toolkit.getDefaultToolkit().beep();
                    keyEvent.consume();
                    return;
                }
                if (keyEvent.getKeyChar() == '\u001b') {
                    return;
                }
            }
        };
        jTextField.addKeyListener(keyAdapter);
    }
}

