/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.timegen.ui.wizard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import oracle.ide.component.NewFilePanel;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.ModelUtil;
import oracle.olap.OLAPArb;
import oracle.olap.timegen.ui.wizard.TimeGenWizMain;
import oracle.olap.timegen.ui.wizard.TimeGenWizardPanel;

public class TimeGenSummaryPanel
extends TimeGenWizardPanel
implements ActionListener {
    private JTextArea textArea = new JTextArea();
    private static final String EXT = ".sql";
    private static URLFilter SQL_FILTER = new DefaultURLFilter(UIBundle.get((String)"SQL_URLFILTER_TEXT"), ".sql");
    private JButton m_btnSave;
    private final BasicEditorPane m_txtSQL = new BasicEditorPane();
    private DBEditorConfig m_config;

    public TimeGenSummaryPanel() {
        this.layoutComponents();
    }

    private void layoutComponents() {
        if (this.getComponentCount() == 0) {
            DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("DDLPanel");
            boolean bl = this.m_config != null && this.m_config.isInFlatEditor();
            DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper((JPanel)((Object)this), bl);
            JLabel jLabel = new JLabel();
            dBUIResourceHelper.resLabel(jLabel, (Component)this.m_txtSQL, OLAPArb.get("OLAPDDL_PANEL_LABEL"), "SQL");
            this.m_btnSave = new JButton();
            this.m_btnSave.addActionListener(this);
            dBUIResourceHelper.resButton((AbstractButton)this.m_btnSave, UIBundle.get((String)"DDL_BUTTON_SAVE"), "Save");
            this.m_txtSQL.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane((Component)this.m_txtSQL);
            dBUILayoutHelper.add((Component)jLabel);
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.add((Component)jScrollPane, 3, 1);
            dBUILayoutHelper.add(Box.createVerticalStrut(200), 1, 1, false, false);
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.nextColumn();
            dBUILayoutHelper.nextColumn();
            dBUILayoutHelper.add((Component)this.m_btnSave);
            dBUILayoutHelper.getConstraints((Component)this.m_btnSave).anchor = 13;
            dBUILayoutHelper.layout();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_btnSave) {
            Object object2;
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setURLFilter(SQL_FILTER);
            URL uRL = null;
            while (uRLChooser.showSaveDialog((Component)((Object)this)) == 0) {
                uRL = uRLChooser.getSelectedURL();
                if (!ModelUtil.hasLength((String)URLFileSystem.getSuffix((URL)uRL))) {
                    object2 = URLFileSystem.getPath((URL)uRL);
                    uRL = URLFactory.replacePathPart((URL)uRL, (String)((String)object2 + EXT));
                }
                try {
                    uRL = NewFilePanel.validateURL((Component)((Object)this), (URL)uRL, (String)UIBundle.get((String)"SQLFILE_TYPE"), (boolean)true);
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog((Component)((Object)this));
                    break;
                }
                if (uRL == null) continue;
            }
            if (uRL != null) {
                try {
                    object2 = URLFileSystem.openOutputStream((URL)uRL);
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object2, IdeUtil.getIdeEncoding()));
                    bufferedWriter.write(this.m_txtSQL.getText());
                    ((Writer)bufferedWriter).flush();
                    ((Writer)bufferedWriter).close();
                }
                catch (IOException iOException) {
                    DBMessageDialog.showErrorDialog((Exception)iOException, (Object)this, (Level)Level.SEVERE, null, (String)UIBundle.get((String)"DDL_ERROR_SAVE_TITLE"), null);
                }
            }
        }
    }

    @Override
    public void initializeData(TraversableContext traversableContext) {
        boolean bl = false;
        String string = TimeGenWizMain.getInstance().getSQL((Namespace)traversableContext);
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        if (string != null) {
            textBuffer.insert(0, string.toCharArray());
        }
        BasicDocument basicDocument = new BasicDocument(textBuffer);
        basicDocument.setLanguageSupport(bl ? "foo.txt" : "foo.sql");
        this.m_txtSQL.setDocument((Document)basicDocument);
    }

    @Override
    public void setContext(TraversableContext traversableContext) {
    }

    public void onEntry(TraversableContext traversableContext) {
        this.initializeData(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.validateFields(traversableContext);
        this.setContext(traversableContext);
    }

    @Override
    public void validateFields(TraversableContext traversableContext) {
    }
}

