/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.searchablelist;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.olap.syntaxbuilder.shuttle.DragHandler;
import oracle.olap.syntaxbuilder.shuttle.GuiNodeSelector;
import oracle.olap.syntaxbuilder.shuttle.InputHandler;
import oracle.olap.syntaxbuilder.shuttle.TemplateHandler;
import oracle.olap.syntaxbuilder.specification.SpecTreeNode;

public class SearchableList
extends JPanel
implements TreeSelectionListener {
    private static final Logger LOG = Logger.getLogger(SearchableList.class.getName());
    private final JList elements;
    private final JScrollPane listScroll;
    private final DefaultListModel listModel = new DefaultListModel();
    private int foundIndex = 0;
    private transient SearchMatcher matcher = null;
    private transient TemplateHandler handler;
    private static final String SEARCH_DOWN = "SEARCH_DOWN";
    private static final String SEARCH_UP = "SEARCH_UP";
    private static final String NOTHING = "NOTHING";
    private static final String INSERT_NODE = "INSERT_NODE";
    private GuiNodeSelector selector;

    public SearchableList(TemplateHandler templateHandler) {
        super(new BorderLayout());
        this.handler = templateHandler;
        this.elements = new JList(this.listModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Object e;
                int n = this.locationToIndex(mouseEvent.getPoint());
                if (n < this.getModel().getSize() && n > -1 && (e = this.getModel().getElementAt(n)) instanceof SpecTreeNode) {
                    return ((SpecTreeNode)e).getTemplate();
                }
                return null;
            }
        };
        this.elements.setName("elements");
        this.elements.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Icon icon;
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof SpecTreeNode && component instanceof JLabel && (icon = ((SpecTreeNode)object).getIcon()) != null) {
                    ((JLabel)component).setIcon(icon);
                }
                return component;
            }
        });
        this.listScroll = new JScrollPane(this.elements);
        final SearchField searchField = new SearchField(SearchField.Style.FIND);
        InputMap inputMap = searchField.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), SEARCH_DOWN);
        inputMap.put(KeyStroke.getKeyStroke(40, 0), SEARCH_DOWN);
        inputMap.put(KeyStroke.getKeyStroke(38, 0), SEARCH_UP);
        ActionMap actionMap = searchField.getActionMap();
        actionMap.put(SEARCH_DOWN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchableList.this.search(searchField.getText(), 1);
            }
        });
        actionMap.put(SEARCH_UP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchableList.this.search(searchField.getText(), -1);
            }
        });
        searchField.setTypingDelay(SearchField.TypingDelay.FAST);
        searchField.setAutoFind(true);
        searchField.getPopDownAction().setEnabled(true);
        searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                if (searchEvent.getDirection() == SearchEvent.Direction.BACKWARD) {
                    SearchableList.this.search(searchEvent.getSearchText(), -1);
                } else {
                    SearchableList.this.search(searchEvent.getSearchText(), 1);
                }
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        this.selector = new GuiNodeSelector(){

            @Override
            public SpecTreeNode selectClickedNode(MouseEvent mouseEvent) {
                SpecTreeNode specTreeNode;
                int n = SearchableList.this.elements.locationToIndex(mouseEvent.getPoint());
                if (n < SearchableList.this.elements.getModel().getSize() && n > -1 && SearchableList.this.isEnabled() && (specTreeNode = (SpecTreeNode)SearchableList.this.elements.getModel().getElementAt(n)) != null) {
                    SearchableList.this.setSelectedItem(specTreeNode);
                    return specTreeNode;
                }
                return null;
            }

            @Override
            public SpecTreeNode getSelectedNode() {
                if (SearchableList.this.isEnabled()) {
                    return (SpecTreeNode)SearchableList.this.getSelectedValue();
                }
                return null;
            }

            @Override
            public TemplateHandler getTemplateHandler() {
                return SearchableList.this.handler;
            }
        };
        ActionMap actionMap2 = this.getListActionMap();
        InputMap inputMap2 = this.getListInputMap();
        this.elements.addMouseListener(new InputHandler(this.selector, actionMap2, inputMap2));
        actionMap2.put(NOTHING, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        inputMap2.put(KeyStroke.getKeyStroke(67, 128), NOTHING);
        this.setTransferHandler(new DragHandler(this.selector));
        this.add((Component)searchField, "North");
        this.add((Component)this.listScroll, "Center");
    }

    private void search(String string, int n) {
        if (this.matcher == null || !this.matcher.searchString().equals(string)) {
            this.matcher = SearchMatcher.getPrefixMatcher((CharSequence)string, (boolean)true, (boolean)true);
        }
        this.findElement(n);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getPath() != null) {
            this.setElements(new ArrayList<SpecTreeNode>(((SpecTreeNode)treeSelectionEvent.getPath().getLastPathComponent()).getInsertables()));
        }
    }

    public void setSelectedItem(Object object) {
        this.elements.setSelectedValue(object, true);
    }

    public ActionMap getListActionMap() {
        return this.elements.getActionMap();
    }

    public InputMap getListInputMap() {
        return this.elements.getInputMap();
    }

    public void setElements(List list) {
        this.listModel.removeAllElements();
        for (Object e : list) {
            this.listModel.addElement(e);
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.elements.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.elements.removeListSelectionListener(listSelectionListener);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return this.elements.getListSelectionListeners();
    }

    @Override
    public void setTransferHandler(TransferHandler transferHandler) {
        this.elements.setTransferHandler(transferHandler);
        this.elements.setDragEnabled(transferHandler != null);
    }

    private void findElement(int n) {
        boolean bl = false;
        this.foundIndex += n;
        if (this.foundIndex < 0) {
            this.foundIndex = this.listModel.getSize() - 1;
        }
        n = n == 0 ? 1 : n;
        for (int i = this.foundIndex; i >= 0 && i < this.listModel.getSize(); i += n) {
            bl = this.matcher.matches((CharSequence)this.listModel.getElementAt(i).toString());
            if (!bl) continue;
            this.elements.setSelectedIndex(i);
            this.elements.ensureIndexIsVisible(i);
            this.foundIndex = i;
            break;
        }
        if (!bl) {
            this.foundIndex = -1;
        }
    }

    @Override
    public synchronized void removeMouseListener(MouseListener mouseListener) {
        this.elements.removeMouseListener(mouseListener);
    }

    @Override
    public synchronized MouseListener[] getMouseListeners() {
        return this.elements.getMouseListeners();
    }

    public Object getSelectedValue() {
        return this.elements.getSelectedValue();
    }

    protected void insertNode(SpecTreeNode specTreeNode) throws SQLException, IOException {
        this.handler.insertNode(specTreeNode);
    }

    public TemplateHandler getShuttleHandler() {
        return this.handler;
    }

    public void setShuttleHandler(TemplateHandler templateHandler) {
        this.handler = templateHandler;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.elements.setEnabled(bl);
    }
}

