/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.stringexpr;

import java.io.IOException;
import java.sql.SQLException;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.stringexpr.MyParamValue;
import oracle.olap.stringexpr.ParseException;
import oracle.olap.stringexpr.StringExprParser;

public class AAStringExprTest {
    private static MyParamValue paramValue = new MyParamValue();
    private static String[] testCases = new String[]{"'hello'", "hello", "''", "", "''''", "''", "nvl({foo}, 'bar')", "bar", "nvl2({foo}, 'foo', 'bar')", "bar", "nvl2({measure}, 'foo', 'bar')", "foo", "decode('Z', 'Y', 'Year', 'Q', 'Quarter', 'default')", "default", "decode('Y', 'Y', 'Year', 'Q', 'Quarter')", "Year", "decode('Z', 'Y', 'Year', 'Q', 'Quarter', 'default')", "default", "decode('Z', 'Y', 'Year', 'Q', 'Quarter')", null, "to_char(2+3+1)", "6", "to_char(to_number({preceding})+1)", "3", "substr({measure}, 1) || 'foo'", "UNITSfoo", "substr('1234567890',-4,3)", "789", "substr('foobar', instr('foobar', 'bar'))", "bar", "substr('abc', 2)", "bc", "substr('foobar', 4, 7)", "bar", "'a' || 'b'", "ab", "ltrim(' abc')", "abc", "rtrim('abc  ')", "abc", "trim(' abc  ')", "abc", "to_char(length('abc'))", "3", "lower('ABC')", "abc", "upper('abc')", "ABC", "initcap('abc')", "Abc", "replace('foobar', 'bar', 'bar2')", "foobar2", "regex_replace('12foo12bar', '^12', '34')", "34foo12bar", "to_char(1+2)", "3", "to_char(5-3)", "2", "to_char(6-9)", "-3", "to_char(3*2)", "6", "to_char(10/3)", "3.3333333333333335", "to_char(floor(10/3))", "3", "to_char(ciel(10/3))", "4", "to_char(floor(-10/3))", "-4", "to_char(ciel(-10/3))", "-3", "to_char(trunc(10/3))", "3", "to_char(mod(10,3))", "1", "to_char(10*2/5)", "4", "to_number('2') = 2", "true", "to_number('3') = 2", "false", "substr('CALENDAR_YEAR', 10, 1)", "Y", "substr('CALENDAR_YEAR', instr('CALENDAR_YEAR', '_')+1, 1)", "Y", "'UNITS' || '_' || substr('CALENDAR_YEAR', instr('CALENDAR_YEAR', '_')+1+1-1, 1) || 'TD_PP'", "UNITS_YTD_PP", "{measure_name} || '_' || to_char(to_number({preceding})+to_number({following})+1) || '_PER_MVG_MAX'", "UNITS_6_PER_MVG_MAX", "{measure_name} || '_CUM_TOT' || is_selected({hierarchy_level}, '_' || substr({hierarchy_level_name}, instr({hierarchy_level_name}, '_')+1, 1), '_' || {within_name})", "UNITS_CUM_TOT_LVL", "1=1 and 2>=1 and 1<=2 and 1<>2 and 1<2 and 2>1", "true", "1=2 and 2>=3 and 3<=2 and 2<>2 and 2<2 and 2>3", "false", "1*2+8 = 10", "true", "5+5-1=9", "true", "6*2/3=4", "true", "1+5*5=26", "true", "(1+5)*5=30", "true", "1=2 and 1=1 or 2=2", "true", "1=2 and (1=1 or 2=2)", "false", "{isFlat} = true", "TRUE", "concat({levels}, ',')", "state,city", "decode({measure}, 'UNITS', 'UNITS2')", "UNITS2", "concat(loop({levels}, '''' || {name} || '$'), ',')", "''state$,''city$", "count({levels}) = 2", "true", "count({levels}) = 1", "false", "concat(loop({levels}, decode({this$}, 'state', 'state2', 'city', 'city2')), ',')", "state2,city2", "concat(loop({measures}, decode(to_char({isNumeric}), 'true', 'r(' || {name} || ')', 'false', {name})), ',')", "r(SALES),r(COST),FLAG", "concat(loop({measures}, decode(to_char({isSelected}), 'true', {this$})), ',')", "SALES,FLAG", "concat(loop(loop({measures}, decode(to_char({isSelected}), 'true', {this$})), decode(to_char({isNumeric}), 'true', 'round(' || {columnName} || ',2) as \"' || {name} || '\"', 'false', {name})), ',')", "round(SALES2,2) as \"SALES\",FLAG", "concat(loop(loop({measures}, decode(to_char({isSelected}), 'true', {this$})), decode(to_char({isNumeric}), 'true', 'round(' || {columnName} || ',2)', 'false', {name}) || ' as \"' || {name} || '\"'), ',')", "round(SALES2,2) as \"SALES\",FLAG as \"FLAG\"", "concat(split('state,city', ','), ',')", "state,city", "to_char(count({measures}))", "3", "'(' || concat({measures}, '+') || ')/' || to_char(count({measures}))", "(SALES+COST+FLAG)/3", "instr('TIME','I') > 0", "true", "instr('TIME','J') = 0 ", "true", "{measure_short_description} || ' Share of ' || is_selected({hierarchy_level}, {hierarchy_level_description}, {dimension_description} || ' ' || {ratio_of_description})", "Units Share of Time Top"};
    private static String[] objectTestCases = new String[]{"cube", "dimensionColumn('CHANNEL')", "CHANNEL22"};

    public static String getExampleDocumentation() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        MyParamValue myParamValue = new MyParamValue();
        String[] stringArray = myParamValue.getParams();
        stringBuffer.append(" For parameters\n");
        for (n = 0; n < stringArray.length; n += 2) {
            stringBuffer.append("   " + stringArray[n] + " = '" + stringArray[n + 1] + "'\n");
        }
        stringBuffer.append(" Expressions\n");
        stringBuffer.append("\n");
        for (n = 0; n < testCases.length; n += 2) {
            stringBuffer.append("   " + testCases[n] + " = '" + testCases[n + 1] + "'\n");
        }
        return stringBuffer.toString();
    }

    private static String getResult(String string) throws ParseException, SQLException, IOException {
        String string2 = StringExprParser.getParseTree(string, paramValue);
        return string2;
    }

    public static void main(String[] stringArray) {
        String string;
        for (int i = 0; i < testCases.length; i += 2) {
            try {
                System.out.print("  " + testCases[i]);
                System.out.flush();
                System.err.flush();
                string = AAStringExprTest.getResult(testCases[i]);
                System.out.print(" ====> " + string);
                if (string == null && testCases[i + 1] != null && !string.equals(testCases[i + 1])) {
                    System.out.println("\n           ***********Test failed***********");
                }
                System.out.println();
                System.out.flush();
                continue;
            }
            catch (Exception exception) {
                System.out.println();
                System.out.flush();
                exception.printStackTrace();
            }
        }
        Schema schema = null;
        string = null;
        Cube cube = new Cube(schema, string, "UNITS_FACT", "Units Fact", "UNITS_FACT_VIEW", false);
        cube.addDimension(new Dimension(schema, string, "CHANNEL", "Channel"));
        cube.setDimensionColumn("CHANNEL", "CHANNEL22");
        System.out.println("############# Object Test Cases ##############");
        for (int i = 0; i < objectTestCases.length; i += 3) {
            try {
                System.out.print("  " + objectTestCases[i]);
                System.out.flush();
                System.err.flush();
                Object object = null;
                if (objectTestCases[i].equalsIgnoreCase("cube")) {
                    object = cube.getValue(objectTestCases[i + 1]);
                }
                System.out.print(" ====> " + object.toString());
                if (object == null && objectTestCases[i + 2] != null && !object.equals(objectTestCases[i + 2])) {
                    System.out.println("\n           ***********Object Test failed***********");
                }
                System.out.println();
                System.out.flush();
                continue;
            }
            catch (Exception exception) {
                System.out.println();
                exception.printStackTrace();
            }
        }
    }
}

