/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.security;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.data.DimensionMetadataContext;
import oracle.olap.db.view.CubeAWUtil;
import oracle.olap.hierarchyviewer.DimensionMetadataContextImpl;
import oracle.olap.security.DimensionMemberSelectionPanel;
import oracle.olap.security.RealmConstraint;

public class MemberSelectionPanel
extends BaseEditorPanel<RealmConstraint> {
    private DimensionMemberSelectionPanel conditionPanel;
    private JTextArea memberConditionArea;
    private boolean isInitialized;
    private boolean enabled = true;

    public MemberSelectionPanel() {
    }

    public MemberSelectionPanel(DimensionMetadataContext dimensionMetadataContext) {
        this.setSize(300, 200);
        OLAPResources oLAPResources = new OLAPResources("/oracle/olap/security/dimsecuritycondition.xml");
        FetchIcon fetchIcon = null;
        try {
            this.conditionPanel = new DimensionMemberSelectionPanel(dimensionMetadataContext, oLAPResources, fetchIcon);
            this.conditionPanel.setEnabled(false);
            this.conditionPanel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    MemberSelectionPanel.this.setExpression();
                }
            });
        }
        catch (SQLException sQLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setExpression();
    }

    private void setExpression() {
        try {
            this.memberConditionArea.setText(this.conditionPanel.getExpression());
        }
        catch (SQLException sQLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void initialiseComponents() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 18;
        this.conditionPanel = new DimensionMemberSelectionPanel();
        this.conditionPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MemberSelectionPanel.this.setExpression();
            }
        });
        jPanel.add(this.conditionPanel);
        this.add(jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel2.add((Component)new JLabel(OLAPArb.getString("MEMBER_SELECTION_PANEL_CONDITION_LABEL")), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.memberConditionArea = new JTextArea(4, 50);
        JScrollPane jScrollPane = new JScrollPane(this.memberConditionArea);
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        this.add(jPanel2, gridBagConstraints);
    }

    protected void initialisePanel() {
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        Connection connection = oracleDatabaseImpl.getConnection();
        String string = Connections.getInstance().getConnectionName(connection);
        String string2 = CubeAWUtil.getParentDimensionName();
        Schema schema = null;
        RealmConstraint realmConstraint = (RealmConstraint)this.getUpdatedObject();
        this.setEnabled(realmConstraint.getRealmConditionType().equals("MEMBER_SELECTION_TYPE"));
        try {
            if (!this.isInitialized) {
                schema = OLAPMetadataCache.getUpdatedSchema(string, ((RealmConstraint)this.getUpdatedObject()).getSchema().getName());
                DimensionMetadataContextImpl dimensionMetadataContextImpl = new DimensionMetadataContextImpl(oracleDatabaseImpl, schema.findDimension(string2));
                OLAPResources oLAPResources = new OLAPResources("/oracle/olap/security/dimsecuritycondition.xml");
                FetchIcon fetchIcon = null;
                this.conditionPanel.setDimensionMetadataContext(dimensionMetadataContextImpl);
                this.conditionPanel.setResources(oLAPResources);
                this.conditionPanel.setFetchIcon(fetchIcon);
                this.conditionPanel.setupTemplates();
                this.conditionPanel.setEnabled(false);
                this.isInitialized = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enableComponents();
        this.setExpression();
    }

    protected void commitPanel() throws TraversalException {
        if (this.enabled) {
            RealmConstraint realmConstraint = (RealmConstraint)this.getUpdatedObject();
            this.setData(realmConstraint);
        }
    }

    private void enableComponents() {
        RealmConstraint realmConstraint = (RealmConstraint)this.getUpdatedObject();
        boolean bl = realmConstraint.getRealmConditionType().equals("MEMBER_SELECTION_TYPE");
        if (bl != this.enabled) {
            for (Component component : this.getComponents((Component)((Object)this))) {
                component.setEnabled(bl);
            }
            this.enabled = bl;
        }
    }

    private Component[] getComponents(Component component) {
        ArrayList<Object> arrayList = null;
        try {
            arrayList = new ArrayList<Component>(Arrays.asList(((Container)component).getComponents()));
            for (int i = 0; i < arrayList.size(); ++i) {
                for (Component component2 : this.getComponents((Component)arrayList.get(i))) {
                    arrayList.add(component2);
                }
            }
        }
        catch (ClassCastException classCastException) {
            arrayList = new ArrayList();
        }
        return arrayList.toArray(new Component[arrayList.size()]);
    }

    public void setData(RealmConstraint realmConstraint) {
        String string = this.memberConditionArea.getText();
        realmConstraint.setRealmCondition(string);
    }
}

