/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.security;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.olap.OLAPArb;
import oracle.olap.app.ui.HelpProvider;
import oracle.olap.data.DimensionMetadataContext;
import oracle.olap.security.DataSecurityPolicy;
import oracle.olap.security.DimensionDataSecurityPanel;
import oracle.olap.security.PolicyPersistance;
import oracle.olap.security.RealmConstraint;

public class DimensionDataSecurityDialog
extends JDialog {
    private JPanel panel;
    private DimensionDataSecurityPanel dataSecurityPanel;
    private Action saveAction;
    private Action closeAction;
    private Action helpAction;
    private final HelpProvider helpProvider;
    private PolicyPersistance policyPersistance;

    public DimensionDataSecurityDialog(JFrame jFrame, HelpProvider helpProvider, Connection connection, DimensionMetadataContext dimensionMetadataContext) {
        super(jFrame);
        this.helpProvider = helpProvider;
        this.policyPersistance = new PolicyPersistance(connection, dimensionMetadataContext);
        oracle.olap.app.olapmetadata.Dimension dimension = dimensionMetadataContext.getDimension();
        dimension.getName();
        this.panel = new JPanel();
        this.dataSecurityPanel = new DimensionDataSecurityPanel(this, helpProvider, connection, dimensionMetadataContext, null);
        this.dataSecurityPanel.setName("dataSecurityPanel");
        Dimension dimension2 = Ide.getMainWindow().getSize();
        dimension2.setSize(dimension2.getWidth() * 0.6, dimension2.getHeight() * 0.8);
        if (dimension2.getWidth() < 600.0 || dimension2.getHeight() < 500.0) {
            this.setSize(400, 500);
        } else {
            this.setSize(dimension2);
        }
        this.setLocationRelativeTo(jFrame);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.saveAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RealmConstraint realmConstraint = new RealmConstraint();
                DataSecurityPolicy dataSecurityPolicy = DimensionDataSecurityDialog.this.dataSecurityPanel.saveData(realmConstraint);
                DimensionDataSecurityDialog.this.policyPersistance.savePolicy(realmConstraint.getPolicy(), realmConstraint);
                DimensionDataSecurityDialog.this.dispose();
            }
        };
        this.closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DimensionDataSecurityDialog.this.dispose();
            }
        };
        this.helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DimensionDataSecurityDialog.this.helpProvider.showHelp(DimensionDataSecurityDialog.this.panel, "");
            }
        };
        this.layoutComponents();
        this.registerKeyboardActions();
        this.setVisible(true);
    }

    private void layoutComponents() {
        JButton jButton = new JButton(this.saveAction);
        jButton.setName("closeButton");
        jButton.setText(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_APPLY_BUTTON_TEXT")));
        jButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_APPLY_BUTTON_TEXT")));
        JButton jButton2 = new JButton(this.closeAction);
        jButton2.setName("closeButton");
        jButton2.setText(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_CLOSE_BUTTON_TEXT")));
        jButton2.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_CLOSE_BUTTON_TEXT")));
        JButton jButton3 = new JButton(this.helpAction);
        jButton3.setName("helpButton");
        jButton3.setText(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        jButton3.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.setName("bb");
        dialogButtonBar.add((Component)jButton, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)jButton3, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)jButton2, DialogButtonBar.CONSTRAINT_CANCEL);
        this.panel.setName("panel");
        this.setContentPane(this.panel);
        this.panel.setLayout(new GridBagLayout());
        int n = 0;
        this.panel.add((Component)this.dataSecurityPanel, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 5));
        this.panel.add((Component)dialogButtonBar, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 5, 5));
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this.closeAction, KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke(112, 0), 1);
    }
}

