/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.preferences;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.olap.OLAPArb;
import oracle.olap.preferences.OLAPPreferenceSettings;

public class OLAPBuildLogPreferenceSettings
extends OLAPPreferenceSettings {
    private static int _DEFAULT_MAX_NUM_OF_ERRORS_LOGGED = 100;
    private static String _DEFAULT_QUERIES_REFRESH_TIME = "5";
    private Map logLevelMap = new HashMap();
    private Map queriesRefreshTimeMap = new HashMap();
    public static final String LOG_LEVEL = "BuildLogLogLevel";
    public static final String MAX_NUM_OF_ERRORS_LOGGED = "BuildLogMaxNumOfErrorsLogged";
    public static final String QUERIES_REFRESH_TIME = "QueriesRefreshTime";
    protected static final String DATA_KEY = "oracle.olap.preferences.build.OLAPBuildLogPreferenceSettings";

    public static OLAPBuildLogPreferenceSettings getInstance() {
        return OLAPBuildLogPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private OLAPBuildLogPreferenceSettings(HashStructure hashStructure) {
        super(hashStructure);
        this.init();
    }

    public static OLAPBuildLogPreferenceSettings getInstance(PropertyStorage propertyStorage) {
        return new OLAPBuildLogPreferenceSettings(OLAPBuildLogPreferenceSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    private void init() {
        this.logLevelMap.put("DBMS_CUBE_LOG.LEVEL_LOWEST", OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL_ACTION"));
        this.logLevelMap.put("DBMS_CUBE_LOG.LEVEL_LOW", OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL_NOTICE"));
        this.logLevelMap.put("DBMS_CUBE_LOG.LEVEL_MEDIUM", OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL_INFO"));
        this.logLevelMap.put("DBMS_CUBE_LOG.LEVEL_HIGH", OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL_STATS"));
        this.logLevelMap.put("DBMS_CUBE_LOG.LEVEL_HIGHEST", OLAPArb.get("OLAP_PREFERENCES_BUILD_LOG_LEVEL_DEBUG"));
        this.queriesRefreshTimeMap.put("0", 0);
        this.queriesRefreshTimeMap.put("5", 5);
        this.queriesRefreshTimeMap.put("10", 10);
        this.queriesRefreshTimeMap.put("15", 15);
        this.queriesRefreshTimeMap.put("20", 20);
        this.queriesRefreshTimeMap.put("25", 25);
        this.queriesRefreshTimeMap.put("30", 30);
        this.queriesRefreshTimeMap.put("60", 60);
        this.queriesRefreshTimeMap.put("120", 120);
    }

    public void setLogLevel(String string) {
        String string2 = null;
        Set set = this.logLevelMap.keySet();
        for (String string3 : set) {
            String string4 = (String)this.logLevelMap.get(string3);
            if (!string.equalsIgnoreCase(string4)) continue;
            string2 = string3;
            break;
        }
        this._hash.putString(LOG_LEVEL, string2);
    }

    public String getLogLevel() {
        String string = this._hash.getString(LOG_LEVEL, "DBMS_CUBE_LOG.LEVEL_LOW");
        return string;
    }

    public String getLogLevel(String string) {
        String string2 = null;
        Set set = this.logLevelMap.keySet();
        for (String string3 : set) {
            String string4 = (String)this.logLevelMap.get(string3);
            if (!string.equalsIgnoreCase(string4)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    public String getLogLevelName() {
        String string = this._hash.getString(LOG_LEVEL, "DBMS_CUBE_LOG.LEVEL_LOW");
        String string2 = this.getLogLevelName(string);
        return string2;
    }

    public String getLogLevelName(String string) {
        String string2 = (String)this.logLevelMap.get(string);
        return string2;
    }

    public void setMaxErrorsLogged(int n) {
        this._hash.putInt(MAX_NUM_OF_ERRORS_LOGGED, n);
    }

    public int getMaxErrorsLogged() {
        return this._hash.getInt(MAX_NUM_OF_ERRORS_LOGGED, _DEFAULT_MAX_NUM_OF_ERRORS_LOGGED);
    }

    public void setQueriesRefreshTime(String string) {
        if (this.queriesRefreshTimeMap.containsKey(string)) {
            this._hash.putInt(QUERIES_REFRESH_TIME, ((Integer)this.queriesRefreshTimeMap.get(string)).intValue());
        }
    }

    public int getQueriesRefreshTime() {
        int n = (Integer)this.queriesRefreshTimeMap.get(_DEFAULT_QUERIES_REFRESH_TIME);
        return this._hash.getInt(QUERIES_REFRESH_TIME, n);
    }
}

