/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.navigator.olapdml;

import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ViewerOpener;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.db.DBNavigatorWindow;
import oracle.dbtools.raptor.navigator.db.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.runner.ArgusHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.compiler.Compiler;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.log.LogPage;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.Debugger;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.ideri.util.Product;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.Translator;
import oracle.ojc.interfaces.Storage;
import oracle.olap.OLAPArb;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.app.olapmetadata.MetadataChange;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.dml.DMLObject;
import oracle.olap.dml.DMLProgram;
import oracle.olap.dml.editor.OLAPDMLCompilerPage;
import oracle.olap.dml.editor.OLAPDMLErrorInfo;
import oracle.olap.dml.editor.OLAPDMLTranslator;
import oracle.olap.dml.editor.OLAPFormatHelper;
import oracle.olap.dml.editor.OLAPURLFileSystemHelper;
import oracle.olap.dml.editor.OLAPURLStreamHandlerFactory;
import oracle.olap.dml.parser.OLAPDMLBackgroundParser;
import oracle.olap.dml.parser.OLAPDMLLexerToken;
import oracle.olap.syntaxbuilder.olapihelpers.Type;

public class OLAPDMLNode
extends RunnableSourceNode
implements Comparable<OLAPDMLNode>,
EquippedWithParser {
    private List<Member> members = new LinkedList<Member>();
    private OLAPDMLBackgroundParser parser = new OLAPDMLBackgroundParser();
    private boolean isAWInURL = false;
    private DMLProgram newDMLProgram = null;
    private List<OLAPDMLErrorInfo> errWarnings = new ArrayList<OLAPDMLErrorInfo>();
    private boolean isCompiled = false;
    private String previousAWAttachModeInSession = null;
    private Boolean isBreadcrumbsOn;
    private Boolean isGutterNavOn;
    private String m_parsedOwner = null;
    private String m_parsedType = null;
    private String m_parsedName = null;
    public boolean invokedFromToolbar = false;
    private LinkedList<Observer> listeners = new LinkedList();
    private boolean readOnly = false;
    private static ViewerOpener viewerOpener;

    public OLAPDMLNode() {
        Attributes attributes = this.getAttributes();
        attributes.unset(ElementAttributes.RENAMEABLE);
        attributes.set(ElementAttributes.SAVEABLE_AS);
    }

    public void setNodeInstance(DBObjectInstance dBObjectInstance) {
        super.setNodeInstance(dBObjectInstance);
        URL uRL = this.getURL();
        if (uRL != null && !this.isAWInURL && dBObjectInstance != null) {
            this.isAWInURL = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void openImpl() throws IOException {
        block17: {
            Ide.getMainWindow().setCursor(new Cursor(3));
            if (this.isBreadcrumbsOn()) {
                PlSqlFeatures.setSupportedBreadcrumbs((boolean)false);
            }
            if (this.isGutterNavOn()) {
                PlSqlFeatures.setSupportedGutterNavigation((boolean)false);
            }
            this.parseURL();
            super.openImpl();
            this.readOnly = DBConfig.getInstance().getBoolean("READONLYSQLEDITORS");
            if (this.newDMLProgram == null) {
                String string = this.getConnectionName();
                Connection connection = null;
                String string2 = this.getOwner();
                String string3 = (String)this.getProperty("AW_NAME");
                String string4 = String.format("%s.%s", string2, string3);
                String string5 = null;
                connection = Connections.getInstance().getConnection(string, true);
                string5 = this.getPreviousAWAttachModeInSession(connection, string4);
                if (string5 == null) {
                    DMLObject.runDML(connection, "ATTACH_AW_RO_FIRST", string4);
                }
                this.compile();
                try {
                    if (string5 == null) {
                        DMLObject.runDML(connection, "DETACH_AW", string4);
                    }
                    break block17;
                }
                catch (Exception exception) {}
                break block17;
                catch (Exception exception) {
                    try {
                        if (string5 == null) {
                            DMLObject.runDML(connection, "DETACH_AW", string4);
                        }
                    }
                    catch (Exception exception2) {}
                    catch (Throwable throwable) {
                        try {
                            if (string5 == null) {
                                DMLObject.runDML(connection, "DETACH_AW", string4);
                            }
                        }
                        catch (Exception exception3) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }
        Ide.getMainWindow().setCursor(new Cursor(0));
    }

    public boolean isBreadcrumbsOn() {
        if (this.isBreadcrumbsOn == null) {
            this.isBreadcrumbsOn = PlSqlFeatures.isSupportedBreadcrumbs();
        }
        return this.isBreadcrumbsOn;
    }

    public boolean isGutterNavOn() {
        if (this.isGutterNavOn == null) {
            this.isGutterNavOn = PlSqlFeatures.isSupportedGutterNavigation();
        }
        return this.isGutterNavOn;
    }

    protected void closeImpl() throws IOException {
        try {
            super.closeImpl();
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
        LogPage logPage = OLAPDMLCompilerPage.getErrorLog();
        logPage.clearAll();
    }

    protected Reader createReader(URL uRL) throws IOException {
        char[] cArray;
        Reader reader = null;
        if ((OLAPURLStreamHandlerFactory.isOracleSource(uRL) || OLAPURLStreamHandlerFactory.isOracleTimesTenSource(uRL)) && (cArray = OLAPURLStreamHandlerFactory.fetchSource(uRL)) != null) {
            reader = new OLAPURLFileSystemHelper.CharBufferReader(cArray);
        }
        return reader != null ? reader : super.createReader(uRL);
    }

    public boolean mayHaveChildren() {
        return DBURLFormatHelper.isDBURL((URL)this.getURL());
    }

    public Icon getIcon() {
        Icon icon = null;
        if (this.m_node != null && this.m_node.getObjectFactory() != null) {
            ConnectionTypeDetails connectionTypeDetails = this.m_node.getObjectFactory().getConnectionTypeDescriptor().getImpl();
            icon = connectionTypeDetails.getIcon((DBItemInstance)this.m_node);
        }
        if (icon == null && DBURLFormatHelper.isDBURL((URL)this.getURL()) && this.getNodeInstance() != null && !"BLOCK".equals(this.m_type) && this.getNodeInstance().getDescriptor() != null) {
            icon = this.getNodeInstance().getDescriptor().getIcon();
        } else if (icon == null) {
            icon = super.getIcon();
        }
        return icon;
    }

    public String getPackage(Project project) {
        Object object;
        String string;
        URL uRL = this.getURL();
        String string2 = DBURLFormatHelper.getBaseType((URL)uRL);
        if (string2 == null) {
            string2 = this.getType();
        }
        string2 = ArgusHelper.getArgusNameForType((String)string2);
        String string3 = DBURLFormatHelper.getSchema((URL)uRL);
        if (string3 == null) {
            string3 = this.getOwner();
        }
        if (string3 == null) {
            try {
                string = this.getConnectionName();
                if (string == null) {
                    object = oracle.dbtools.raptor.navigator.plsql.Project.getInstance().getDbURL(uRL.toString());
                    if (object.size() == 1) {
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            String string4 = (String)iterator.next();
                            string3 = DBURLFormatHelper.getSchema((URL)new URL(string4));
                        }
                    }
                } else {
                    string3 = this.getSchemaName();
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        string = OLAPFormatHelper.getAWName(uRL);
        object = new StringBuilder();
        ((StringBuilder)object).append("$Oracle.");
        ((StringBuilder)object).append("AW.");
        ((StringBuilder)object).append(string3);
        return ((StringBuilder)object).toString();
    }

    public String getSourceFile() {
        String string;
        String string2 = (String)this.getProperty("NAME");
        String string3 = string = ModelUtil.hasLength((String)string2) ? string2 : URLFileSystem.getFileName((URL)this.getURL());
        if (string.indexOf(46) >= 0) {
            string = string.substring(0, string.indexOf(46));
        }
        return string + ".dml";
    }

    public String getType() {
        if (this.m_parsedType == null) {
            this.m_parsedType = this.m_type;
        }
        return this.m_parsedType;
    }

    public String getName() {
        String string = null;
        if (this.m_parsedName == null) {
            DBObjectInstance dBObjectInstance = this.getNodeInstance();
            if (dBObjectInstance != null) {
                string = (String)dBObjectInstance.getProperty("NAME");
            } else if (this.newDMLProgram != null) {
                string = this.newDMLProgram.getName();
            }
        } else {
            string = this.m_parsedName;
        }
        return string;
    }

    public String getFullyQualifiedName() {
        String string = null;
        String string2 = null;
        String string3 = this.getName();
        String string4 = this.getOwner();
        DBObjectInstance dBObjectInstance = this.getNodeInstance();
        if (dBObjectInstance != null) {
            string2 = (String)dBObjectInstance.getProperty("AW_NAME");
        } else if (this.newDMLProgram != null) {
            string2 = this.newDMLProgram.getAWName();
        }
        if (string4 != null && string2 != null && string3 != null) {
            string = String.format("%s.%s!%s", string4, string2, string3);
        }
        return string;
    }

    public String getOwner() {
        Object object = this.getProperty("SCHEMA");
        if (object != null) {
            return (String)object;
        }
        return this.m_parsedOwner;
    }

    public URL matchingDbUrl() {
        String string = this.getName();
        String string2 = this.getType();
        String string3 = this.getOwner();
        if (string3 == null) {
            string3 = this.getSchemaName();
        }
        URL uRL = this.getURL();
        String string4 = OLAPFormatHelper.getAWName(uRL);
        URL uRL2 = DBURLFormatHelper.getURL((URL)DBURLFormatHelper.getURL((String)"sqldev.nav", (String)this.getConnectionName(), null, (String)string3, (String)string2), (String)string);
        if (string4 != null && string4.length() > 0) {
            uRL2 = DBURLFormatHelper.getURL((URL)uRL2, (String)string4);
        }
        return uRL2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveImpl() {
        try {
            this.writeLock();
            this._saveImpl();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            String string = OLAPArb.get("SAVE_PROGRAM_ERROR_TITLE");
            String string2 = null;
            String string3 = exception.getLocalizedMessage();
            if (string3 == null || string3.length() == 0) {
                string3 = exception.getClass().toString();
            }
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)string, string2);
            this.markDirty(true);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _saveImpl() throws Exception {
        URL uRL = this.getURL();
        if (!DBURLFormatHelper.isDBURL((URL)uRL)) {
            if (!this.validated(uRL)) {
                if (!MessageDialog.confirm(null, (Object)"File pathname has changed, reload?", (String)"", null)) return;
                this.close();
                return;
            }
            super.saveImpl();
            if (!this.invokedFromToolbar) {
                return;
            }
        }
        this.invokedFromToolbar = false;
        String string2 = this.getConnectionName();
        if (string2 == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DatabaseNavigatorResources.getString((String)"PLSQLNODE_CONN_SELECT_PROMPT"), null, null);
            return;
        }
        if (this.m_parsedOwner == null) {
            this.m_parsedOwner = this.getOwner() != null ? this.getOwner() : this.getSchemaName();
        }
        this.setProperty("SCHEMA", this.m_parsedOwner);
        Debugger debugger = Debugger.getDebugger();
        if (debugger.isDebugging()) {
            throw new IOException(ConnectionArb.getString((String)"ERROR_SAVING_WHILE_DEBUGGING"));
        }
        TextBuffer textBuffer = this.getTextBufferDirectly();
        if (textBuffer != null) {
            textBuffer.clearModified();
        }
        String string = this.getSource();
        DBObjectInstance dBObjectInstance = this.getNodeInstance();
        this.previousAWAttachModeInSession = null;
        if (dBObjectInstance != null) {
            String string3 = (String)dBObjectInstance.getProperty("AW_NAME");
            String string4 = (String)dBObjectInstance.getProperty("NAME");
            this.saveProgram(string2, this.m_parsedOwner, string3, string4, string);
        } else if (this.newDMLProgram != null) {
            Connection connection = Connections.getInstance().getConnection(string2, true);
            String string5 = this.newDMLProgram.getAWName();
            String string6 = String.format("%s.%s", this.m_parsedOwner, string5);
            this.newDMLProgram.setBody(string);
            String string7 = this.getPreviousAWAttachModeInSession(connection, string6);
            if (string7 == null) {
                DMLObject.runDML(connection, "ATTACH_AW", string6);
            }
            try {
                if (!this.newDMLProgram.isExists()) {
                    this.createProgram(connection, this.m_parsedOwner, string5, this.newDMLProgram);
                } else {
                    this.saveProgram(string2, this.m_parsedOwner, string5, this.newDMLProgram.getName(), string);
                }
                OLAPMetadataCache.recordMetadataChange(string2, this.m_parsedOwner, new MetadataChange(string5, this.newDMLProgram.getName(), Type.DMLPROGRAM));
            }
            catch (Exception exception) {
                try {
                    throw exception;
                }
                catch (Throwable throwable) {
                    try {
                        if (string7 == null) {
                            DMLObject.runDML(connection, "DETACH_AW", string6);
                        }
                        OLAPMetadataCache.getUpdatedSchema(string2, this.m_parsedOwner);
                        throw throwable;
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                if (string7 == null) {
                    DMLObject.runDML(connection, "DETACH_AW", string6);
                }
                OLAPMetadataCache.getUpdatedSchema(string2, this.m_parsedOwner);
            }
            catch (Exception exception) {}
        }
        DatabaseOverlayClient.updateOverlay((Element)this);
        if (!Product.isRaptor()) return;
        this.updateNavigator();
        this.updateListeners();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createProgram(Connection connection, String string, String string2, DMLProgram dMLProgram) throws Exception {
        String string3 = dMLProgram.getObjectSpecificCreateCommands();
        String string4 = dMLProgram.getDescription();
        String string5 = String.format("%s.%s", string, string2);
        String string6 = this.getPreviousAWAttachModeInSession(connection, string5);
        Exception exception = new Exception(OLAPArb.format("SAVE_PROGRAM_ERROR_AW_ATTACHED_RO", string5));
        try {
            if (string6 != null && string6.equalsIgnoreCase("RO")) {
                throw exception;
            }
            if (string6 == null) {
                DMLObject.runDML(connection, "ATTACH_AW", string5);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string3);
            stringBuffer.append(String.format("ld %s;", string4));
            DatabaseUtils.ExecuteSPL(connection, stringBuffer.toString());
            DMLObject.runDML(connection, "UPDATE_AW", string5);
            this.compile();
            DMLObject.runDML(connection, "UPDATE_AW", string5);
            connection.commit();
        }
        catch (Exception exception3) {
            try {
                throw exception3;
            }
            catch (Throwable throwable) {
                try {
                    if (string6 != null) throw throwable;
                    DMLObject.runDML(connection, "DETACH_AW", string5);
                    throw throwable;
                }
                catch (Exception exception4) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (string6 != null) return;
            DMLObject.runDML(connection, "DETACH_AW", string5);
            return;
        }
        catch (Exception exception2) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveProgram(String string, String string2, String string3, String string4, String string5) throws Exception {
        Connection connection = Connections.getInstance().getConnection(string, true);
        String string6 = String.format("%s.%s", string2, string3);
        String string7 = this.getPreviousAWAttachModeInSession(connection, string6);
        Exception exception = new Exception(OLAPArb.format("SAVE_PROGRAM_ERROR_AW_ATTACHED_RO", string6));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("consider %s!%s;", string3, string4));
        stringBuffer.append("program;");
        stringBuffer.append(string5);
        stringBuffer.append(";end;");
        try {
            if (string7 != null && string7.equalsIgnoreCase("RO")) {
                throw exception;
            }
            if (string7 == null) {
                DMLObject.runDML(connection, "ATTACH_AW", string6);
            }
            DatabaseUtils.ExecuteSPL(connection, stringBuffer.toString());
            DMLObject.runDML(connection, "UPDATE_AW", string6);
            this.compile();
            DMLObject.runDML(connection, "UPDATE_AW", string6);
            connection.commit();
        }
        catch (Exception exception3) {
            try {
                throw exception3;
            }
            catch (Throwable throwable) {
                try {
                    if (string7 != null) throw throwable;
                    DMLObject.runDML(connection, "DETACH_AW", string6);
                    throw throwable;
                }
                catch (Exception exception4) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (string7 != null) return;
            DMLObject.runDML(connection, "DETACH_AW", string6);
            return;
        }
        catch (Exception exception2) {
            return;
        }
    }

    private String getPreviousAWAttachModeInSession(Connection connection, String string) throws SQLException, IOException {
        if (this.previousAWAttachModeInSession == null) {
            this.previousAWAttachModeInSession = DMLObject.getAWAttachModeInSession(connection, string);
        }
        return this.previousAWAttachModeInSession;
    }

    public void updateListeners() {
        for (Observer observer : this.listeners) {
            observer.update((Object)this, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void compile() {
        void var12_16;
        URL uRL = this.getURL();
        String string = this.getConnectionName();
        if (string == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DatabaseNavigatorResources.getString((String)"PLSQLNODE_CONN_SELECT_PROMPT"), null, null);
            return;
        }
        Compiler compiler = Compiler.getCompiler();
        OLAPDMLTranslator oLAPDMLTranslator = new OLAPDMLTranslator();
        IdeStorage ideStorage = new IdeStorage((Node)this);
        ideStorage.setProperty("OLAPDMLCompilerPage.URL", (Object)uRL);
        IdeLog ideLog = new IdeLog();
        LogPage logPage = OLAPDMLCompilerPage.getErrorLog();
        logPage.clearAll();
        ideLog.registerAsynchronousLogPage(logPage);
        ideLog.setProject(DBNavigatorWindow.getProject((String)string));
        ideLog.setWorkspace(DBNavigatorWindow.getWorkspace());
        ideLog.clear((Storage)ideStorage);
        oLAPDMLTranslator.setLog((Translator.Log)ideLog);
        this.errWarnings = oLAPDMLTranslator.translate(this);
        this.setProperty("INVALID", "false");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (OLAPDMLErrorInfo object2 : this.errWarnings) {
            if (!object2.isWarning() && !object2.isFatal()) {
                bl2 = true;
                continue;
            }
            if (object2.isFatal()) {
                this.setProperty("INVALID", "true");
                bl3 = true;
                break;
            }
            bl = true;
        }
        this.setProperty("PLSQL_DEBUG", DBConfig.getInstance().getInt("PLSQLOPTIMLEVEL") < 2 ? "true" : "false");
        oLAPDMLTranslator.setLog(null);
        ideLog.completed();
        ideLog.unregisterAsynchronousLogPage(logPage);
        Object object3 = null;
        Object var12_13 = null;
        if (!bl3) {
            object3 = bl2 && bl ? "OLAPDML_ERRORS_AND_WARNINGS" : (bl2 ? "OLAPDML_ERRORS" : (bl ? "OLAPDML_WARNINGS" : "OLAPDML_COMPILED"));
            String string2 = OLAPArb.format((String)object3, this.getFullyQualifiedName());
        } else {
            object3 = "OLAPDML_UNABLE_TO_COMPILE_MESSAGE";
            String string3 = OLAPArb.format((String)object3, this.getFullyQualifiedName());
        }
        compiler.getOutputLog().log((Object)var12_16);
        this.isCompiled = true;
        DatabaseOverlayClient.updateOverlay((Element)this);
    }

    public List<OLAPDMLErrorInfo> getCompileErrors() {
        return this.errWarnings;
    }

    public void displayCompileErrors() throws Exception {
        URL uRL = this.getURL();
        String string = this.getConnectionName();
        if (string == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DatabaseNavigatorResources.getString((String)"PLSQLNODE_CONN_SELECT_PROMPT"), null, null);
            return;
        }
        DBObjectInstance dBObjectInstance = this.getNodeInstance();
        OLAPDMLTranslator oLAPDMLTranslator = new OLAPDMLTranslator();
        IdeStorage ideStorage = new IdeStorage((Node)this);
        ideStorage.setProperty("OLAPDMLCompilerPage.URL", (Object)uRL);
        IdeLog ideLog = new IdeLog();
        LogPage logPage = OLAPDMLCompilerPage.getErrorLog();
        logPage.clearAll();
        ideLog.registerAsynchronousLogPage(logPage);
        ideLog.setProject(DBNavigatorWindow.getProject((String)string));
        ideLog.setWorkspace(DBNavigatorWindow.getWorkspace());
        ideLog.clear((Storage)ideStorage);
        if (this.isCompiled) {
            oLAPDMLTranslator.setLog((Translator.Log)ideLog);
            oLAPDMLTranslator.writeCompileLog(this, this.errWarnings);
            oLAPDMLTranslator.setLog(null);
            ideLog.completed();
        }
        ideLog.unregisterAsynchronousLogPage(logPage);
    }

    private void updateNavigator() {
        UpdateMessage.fireStructureChanged((Subject)this);
        IconOverlayTracker iconOverlayTracker = DatabaseOverlayClient.getTracker();
        if (iconOverlayTracker != null) {
            iconOverlayTracker.validateOverlay((Element)this);
            iconOverlayTracker.repaintOverlays();
        }
    }

    public void addListener(Observer observer) {
        if (!this.listeners.contains(observer)) {
            this.listeners.add(observer);
        }
    }

    public void removeListener(Observer observer) {
        this.listeners.remove(observer);
    }

    public void initMembers() {
        if (this.members.size() == 0) {
            this.parseMembers();
        }
    }

    public List<Member> parseMembers() {
        TextBuffer textBuffer = this.acquireTextBuffer();
        String string = textBuffer.getString(0, textBuffer.getLength());
        this.releaseTextBuffer();
        List<LexerToken> list = OLAPDMLLexerToken.parse(string, false);
        this.members.clear();
        this.members.addAll(this.parseMembers(list));
        return this.members;
    }

    private List<Member> parseMembers(List<LexerToken> list) {
        LinkedList<Member> linkedList = new LinkedList<Member>();
        return linkedList;
    }

    public void buildTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.members.size() == 0) {
            this.parseMembers();
        }
        for (Member member : this.members) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(member));
        }
    }

    public void addMembersTo(Collection<Member> collection) {
        if (this.members.size() == 0) {
            this.parseMembers();
        }
        for (Member member : this.members) {
            collection.add(member);
        }
    }

    public Member getMember(String string) {
        for (Member member : this.members) {
            if (!member.name.equals(string)) continue;
            return member;
        }
        return null;
    }

    public final String getSource() {
        String string = super.getSource().trim();
        if (!DBURLFormatHelper.isDBURL((URL)this.getURL())) {
            string = this.trimRemErrorsSlash(string);
        }
        return string;
    }

    private String trimRemErrorsSlash(String string) {
        int n = "show errors".length() + 2;
        if (string.length() < n) {
            return string;
        }
        String string2 = string.substring(0, n).toLowerCase();
        String string3 = string.substring(string.length() - n, string.length()).toLowerCase();
        if (string2.startsWith("rem")) {
            return this.trimRemErrorsSlash(string.substring(string.indexOf("\n") + 1));
        }
        if (string3.indexOf("show errors") > 0) {
            return this.trimRemErrorsSlash(string.substring(0, string.indexOf("show errors")));
        }
        if (string3.indexOf("/") > 0) {
            return this.trimRemErrorsSlash(string.substring(0, string.lastIndexOf("/")));
        }
        return string;
    }

    public static int offset(String string, String string2) {
        if (string == null) {
            return 0;
        }
        List<LexerToken> list = OLAPDMLLexerToken.parse(string, true);
        int n = -1;
        for (LexerToken lexerToken : list) {
            if (!"program".equalsIgnoreCase(lexerToken.content)) continue;
            n = lexerToken.begin;
            break;
        }
        if (n == -1) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if ('\n' != string.charAt(i)) continue;
            ++n2;
        }
        return n2;
    }

    public int offset(String string) {
        return OLAPDMLNode.offset(this.parser.text, string);
    }

    public Object getProperty(String string) {
        if ("TYPE".equals(string)) {
            return "OLAPDMLPROGRAM";
        }
        return super.getProperty(string);
    }

    public String getShortLabel() {
        String string = super.getShortLabel();
        if (string == null || string != null && string.length() == 0) {
            string = this.getName();
        }
        return string;
    }

    @Override
    public int compareTo(OLAPDMLNode oLAPDMLNode) {
        return this.getURL().toString().compareTo(oLAPDMLNode.getURL().toString());
    }

    public OLAPDMLBackgroundParser getParser() {
        return this.parser;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void toggleReadOnly() {
        this.readOnly = !this.readOnly;
    }

    public boolean dictionarySupported() {
        return true;
    }

    public boolean hasBody() {
        boolean bl = false;
        return bl;
    }

    public boolean canHaveBody() {
        return false;
    }

    public static void registerViewerOpener(ViewerOpener viewerOpener) {
        OLAPDMLNode.viewerOpener = viewerOpener;
    }

    private boolean validated(URL uRL) {
        String string = URLFileSystem.getPath((URL)uRL);
        return new File(string).exists();
    }

    public void notifyObservers(Object object, UpdateMessage updateMessage) {
        if (updateMessage.getMessageID() != UpdateMessage.OBJECT_CLOSED) {
            super.notifyObservers(object, updateMessage);
        }
    }

    public void setNewProgram(DMLProgram dMLProgram) {
        this.newDMLProgram = dMLProgram;
    }

    public DMLProgram getNewDMLProgram() {
        return this.newDMLProgram;
    }

    static {
        CodeEditor.registerNodeType(OLAPDMLNode.class, (String)"olapdml");
    }
}

