/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.measurefolder;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.bind.JAXBException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.cubexml.MeasureFolderXML;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.db.IdentifierElement;
import oracle.olap.db.model.AbstractOLAPDBObjectBuilder;
import oracle.olap.db.model.LanguageDescription;
import oracle.olap.measurefolder.model.MeasureFolder;
import oracle.olap.measurefolder.model.MeasureID;

public class MeasureFolderBuilder
extends AbstractOLAPDBObjectBuilder<MeasureFolder> {
    public MeasureFolderBuilder(OracleDatabaseImpl oracleDatabaseImpl) {
        super((AbstractDBObjectProvider)oracleDatabaseImpl, "MEASURE FOLDER");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    public MeasureFolder createObject(String string, Schema schema, DBObjectID dBObjectID) {
        MeasureFolder measureFolder = new MeasureFolder();
        measureFolder.setName(string);
        measureFolder.setSchema(schema);
        measureFolder.setID(dBObjectID);
        return measureFolder;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"description"})
    public void buildDescription(final MeasureFolder measureFolder) throws DBException {
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), "select description from all_measure_folders where measure_folder_name = ? and owner = ?", new Object[]{measureFolder.getName(), measureFolder.getSchema()});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        String string = resultSet.getString(1);
                        measureFolder.setDescription(string);
                        measureFolder.setShortDescription(string);
                        measureFolder.setLongDescription(string);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)measureFolder, sQLException);
                }
            }
        });
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"shortDescription", "longDescription"})
    public void buildDetails(final MeasureFolder measureFolder) throws DBException, SQLException, IOException, JAXBException {
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        String string = measureFolder.getSchema().getName();
        String string2 = String.format("%s.%s", string, measureFolder.getName());
        Object object = this.getObject(oracleDatabaseImpl.getConnection(), string2);
        MetadataContext metadataContext = new MetadataContext(this.getProvider());
        MeasureFolderXML measureFolderXML = new MeasureFolderXML(metadataContext, object, measureFolder);
        measureFolderXML.loadModel();
        measureFolder.setFullyLoaded(true);
        String string3 = String.format("SELECT object_name , object_type, language, description_type, description_value from all_cube_descriptions where owner = ? and object_name='%s' and object_type ='MEASURE FOLDER' and language <> ? order by object_name,language", measureFolder.getName());
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), string3, new Object[]{measureFolder.getSchema(), this.getDefaultLanguage()});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    MeasureFolderBuilder.this.processLanguageDescriptionsResultSet(resultSet, measureFolder);
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)measureFolder, sQLException);
                }
            }
        });
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"measures", "analyticWorkspace"})
    public void buildMeasures(final MeasureFolder measureFolder) throws DBException {
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), "select  cube_name || '.' || measure_name measureid from all_measure_folder_contents where measure_folder_name = ? and owner = ? order by order_num", new Object[]{measureFolder.getName(), measureFolder.getSchema()});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        measureFolder.addMeasure(new MeasureID(string));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)measureFolder, sQLException);
                }
            }
        });
        MeasureID[] measureIDArray = measureFolder.getMeasures();
        String string = null;
        if (measureIDArray != null && measureIDArray.length > 0 && (string = measureIDArray[0].getName()) != null) {
            IdentifierElement identifierElement = new IdentifierElement(string);
            String string2 = identifierElement.getFirst();
            final QueryWrapper queryWrapper2 = new QueryWrapper((Database)this.getProvider(), "select aw_name from all_cubes where all_cubes.owner = ? and all_cubes.cube_name = ?", new Object[]{measureFolder.getSchema(), string2});
            queryWrapper2.executeQuery(new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        while (resultSet.next()) {
                            String string = resultSet.getString(1);
                            measureFolder.setAnalyticWorkspace(string);
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper2.throwDBException((DBObject)measureFolder, sQLException);
                    }
                }
            });
        }
    }

    private void processLanguageDescriptionsResultSet(ResultSet resultSet, MeasureFolder measureFolder) throws DBException, SQLException {
        String string = "";
        boolean bl = true;
        LanguageDescription languageDescription = null;
        int n = 0;
        while (resultSet.next()) {
            if (bl) {
                string = resultSet.getString("language");
                languageDescription = new LanguageDescription(string);
                languageDescription.setLanguage(string);
                bl = false;
            }
            if (string.equals(resultSet.getString("language"))) {
                if (resultSet.getString("description_type").equalsIgnoreCase("Description")) {
                    languageDescription.setDescription(resultSet.getString("description_value"));
                    ++n;
                } else if (resultSet.getString("description_type").equalsIgnoreCase("ShortDescription")) {
                    languageDescription.setShortDescription(resultSet.getString("description_value"));
                    ++n;
                } else if (resultSet.getString("description_type").equalsIgnoreCase("LongDescription")) {
                    languageDescription.setLongDescription(resultSet.getString("description_value"));
                    ++n;
                }
                if (n == 3) {
                    this.checkForNullLanguageDescriptionValues(languageDescription);
                    if (resultSet.getString("object_type").equalsIgnoreCase("MEASURE FOLDER")) {
                        measureFolder.addLanguageDescription(languageDescription);
                    }
                    n = 0;
                    languageDescription = new LanguageDescription(resultSet.getString("language"));
                    languageDescription.setLanguage(resultSet.getString("language"));
                }
            } else {
                languageDescription = new LanguageDescription(resultSet.getString("language"));
                languageDescription.setLanguage(resultSet.getString("language"));
                if (resultSet.getString("description_type").equalsIgnoreCase("Description")) {
                    languageDescription.setDescription(resultSet.getString("description_value"));
                    ++n;
                } else if (resultSet.getString("description_type").equalsIgnoreCase("ShortDescription")) {
                    languageDescription.setShortDescription(resultSet.getString("description_value"));
                    ++n;
                } else if (resultSet.getString("description_type").equalsIgnoreCase("LongDescription")) {
                    languageDescription.setLongDescription(resultSet.getString("description_value"));
                    ++n;
                }
            }
            string = resultSet.getString("language");
        }
    }
}

