/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.map.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.olap.OLAPImagesArb;
import oracle.olap.db.IdentifierElement;
import oracle.olap.map.panels.ColumnIdentifier;
import oracle.olap.map.panels.MapPanel;
import oracle.olap.util.CompletionProviderWithFilter;
import oracle.olap.util.ListSeparatorsRenderer;

public class CompletionColumnMatchProvider
implements CompletionProviderWithFilter<ColumnIdentifier> {
    private List<ColumnIdentifier> columnIdentifiers = new ArrayList<ColumnIdentifier>();
    private boolean filter = true;
    private final ListCellRenderer renderer;

    public CompletionColumnMatchProvider(JList jList, Collection<ColumnIdentifier> collection) {
        this(jList);
        this.columnIdentifiers.addAll(collection);
    }

    public CompletionColumnMatchProvider(JComponent jComponent, Collection<ColumnIdentifier> collection) {
        this((JList)jComponent);
        this.columnIdentifiers.addAll(collection);
    }

    public CompletionColumnMatchProvider(JList jList) {
        this.renderer = new ListSeparatorsRenderer(jList.getCellRenderer()){

            @Override
            protected boolean addSeparatorAfter(JList jList, Object object, int n) {
                Object object2 = null;
                if (n + 1 < jList.getModel().getSize()) {
                    object2 = jList.getModel().getElementAt(n + 1);
                }
                if (object2 != null) {
                    IdentifierElement identifierElement = new IdentifierElement(object2.toString());
                    IdentifierElement identifierElement2 = new IdentifierElement(object.toString());
                    if (identifierElement.getCount() == 2 && identifierElement2.getCount() == 2) {
                        boolean bl = identifierElement.getFirst().equals(identifierElement2.getFirst());
                        return !bl;
                    }
                }
                return false;
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (component instanceof JLabel && object instanceof ColumnIdentifier) {
                    JLabel jLabel = (JLabel)component;
                    ColumnIdentifier columnIdentifier = (ColumnIdentifier)object;
                    if (columnIdentifier.getColumn().isDate()) {
                        jLabel.setIcon(OLAPImagesArb.getIcon("DATATYPE_DATE"));
                    }
                    if (columnIdentifier.getColumn().isNumeric()) {
                        jLabel.setIcon(OLAPImagesArb.getIcon("DATATYPE_NUMBER"));
                    }
                    if (columnIdentifier.getColumn().isString()) {
                        jLabel.setIcon(OLAPImagesArb.getIcon("DATATYPE_STRING"));
                    }
                }
                return component;
            }
        };
    }

    public void setStrings(Collection<ColumnIdentifier> collection) {
        this.filter = true;
        this.columnIdentifiers.clear();
        this.columnIdentifiers.addAll(collection);
    }

    @Override
    public void setFilter(boolean bl) {
        this.filter = bl;
    }

    public ListCellRenderer getCellRenderer() {
        return this.renderer;
    }

    public boolean handlesInsight(Document document, int n) {
        return true;
    }

    public ColumnIdentifier[] getInsightData(Document document, int n) {
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        try {
            String string = document.getText(0, n).toLowerCase();
            if (string.trim().length() == 0) {
                this.filter = false;
            }
            for (ColumnIdentifier columnIdentifier : this.columnIdentifiers) {
                String string2 = columnIdentifier.getIdentifier();
                if (this.filter) {
                    int n2 = string2.toLowerCase().indexOf(string.toLowerCase());
                    if (n2 < 0 || !MapPanel.isColumnValidDataType(columnIdentifier.getColumn().getDataType())) continue;
                    arrayList.add(columnIdentifier);
                    continue;
                }
                if (!MapPanel.isColumnValidDataType(columnIdentifier.getColumn().getDataType())) continue;
                arrayList.add(columnIdentifier);
            }
            if (arrayList.size() == 1) {
                ColumnIdentifier columnIdentifier = (ColumnIdentifier)arrayList.get(0);
                if (MapPanel.isColumnValidDataType(columnIdentifier.getColumn().getDataType())) {
                    if (((ColumnIdentifier)arrayList.get(0)).getIdentifier().equalsIgnoreCase(string)) {
                        arrayList.clear();
                        arrayList.addAll(this.columnIdentifiers);
                    }
                } else {
                    arrayList.clear();
                }
            }
            if (arrayList.size() == 0) {
                arrayList.addAll(this.columnIdentifiers);
            }
            this.filter = true;
        }
        catch (BadLocationException badLocationException) {
            return new ColumnIdentifier[0];
        }
        return arrayList.toArray(new ColumnIdentifier[arrayList.size()]);
    }

    public void completeInsight(Document document, int n, ColumnIdentifier columnIdentifier) {
        try {
            document.remove(0, document.getLength());
            document.insertString(0, columnIdentifier.getIdentifier(), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean isAutoPopupChar(char c) {
        return true;
    }
}

