/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.editor;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.runner.ParamTableModel;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.Database;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.util.ModelUtil;

class Program {
    private static Map<String, BasicDocument> s_docMap = new HashMap<String, BasicDocument>();
    private String _owner;
    private String _awName;
    private String _name;
    private String _id;
    private int _overload;
    private Database _db;
    private PlsqlRoot _parseTree;
    private String _displayValue;
    private ParamTableModel _model;
    private BasicDocument _document;
    static final String INDENT = "  ";

    public Program(String string, String string2, String string3, Database database, PlsqlRoot plsqlRoot) {
        this(string, null, string2, string3, 0, database, plsqlRoot);
    }

    public Program(String string, String string2, String string3, String string4, int n, Database database, PlsqlRoot plsqlRoot) {
        this._owner = string;
        this._awName = string2;
        this._name = string3;
        this._id = string4;
        this._overload = n;
        this._db = database;
        this._parseTree = plsqlRoot;
    }

    public String toString() {
        if (this._displayValue == null) {
            this._displayValue = this._overload > 0 ? this._name + "(" + this._overload + ")" : this._name;
        }
        return this._displayValue;
    }

    public ParamTableModel getTableModel() throws SQLException {
        if (this._model == null) {
            // empty if block
        }
        return this._model;
    }

    public Connection getConnection() {
        return this._db.getConnection();
    }

    public String getAW() {
        return this._awName;
    }

    public String getName() {
        return this._name;
    }

    public int getOverload() {
        return this._overload;
    }

    public String getOwner() {
        return this._owner;
    }

    public String getObjectID() {
        return this._id;
    }

    public PlsqlRoot getParseTree() {
        return this._parseTree;
    }

    public BasicDocument getDocument() throws SQLException {
        if (this._document == null) {
            this._document = s_docMap.get(this._getHashName());
            if (this._document == null) {
                TextBuffer textBuffer = this._generateBuffer();
                this._document = new BasicDocument("foo.dml", textBuffer);
            }
        }
        return this._document;
    }

    public void saveDocument() {
        if (this._document != null) {
            s_docMap.put(this._getHashName(), this._document);
        }
    }

    public void resetDocument() {
        this._document = null;
        s_docMap.remove(this._getHashName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextBuffer _generateBuffer() throws SQLException {
        char[] cArray = this.generateRunBlock();
        TextBuffer textBuffer = TextBufferFactory.createGapTextBuffer();
        textBuffer.writeLock();
        try {
            textBuffer.insert(0, cArray);
        }
        catch (Exception exception) {
        }
        finally {
            textBuffer.writeUnlock();
        }
        return textBuffer;
    }

    public char[] generateRunBlock() throws SQLException {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        boolean bl = true;
        String string = this._db.getConnection().getMetaData().getUserName();
        bl = ModelUtil.areDifferent((Object)string, (Object)this._owner);
        fastStringBuffer.append("BEGIN\n  ");
        fastStringBuffer.append(this._getCallName(bl));
        fastStringBuffer.append(";\nEND;");
        char[] cArray = new char[fastStringBuffer.length()];
        fastStringBuffer.getChars(0, cArray.length, cArray, 0);
        return cArray;
    }

    private String _getCallName(boolean bl) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        String string = this._db.getExternalName(this._awName);
        if (bl && ModelUtil.hasLength((String)this._owner)) {
            string = this._db.getExternalName(this._owner) + "." + string;
        }
        fastStringBuffer.append("dbms_aw.execute('");
        fastStringBuffer.append("aw attach " + string + " ro;");
        fastStringBuffer.append(string).append('!');
        fastStringBuffer.append(this._name);
        fastStringBuffer.append(";");
        fastStringBuffer.append("aw detach " + string);
        fastStringBuffer.append("')");
        return fastStringBuffer.toString();
    }

    private String _getHashName() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        fastStringBuffer.append(this._getCallName(true));
        if (this._overload > 0) {
            fastStringBuffer.append("(" + this._overload + ")");
        }
        String string = null;
        try {
            Connection connection = this._db.getConnection();
            string = connection.getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (ModelUtil.hasLength(string)) {
            fastStringBuffer.append('@').append(string);
        }
        return fastStringBuffer.toString();
    }
}

