/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.ddl;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.olap.cubedimension.model.CubeDimensionAttributeMap;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubexml.ReservedWordsSyntaxHandler;

public class NameTokenGenerator
extends TokenGenerator {
    public static final String TOKEN = "name";
    public static final String LEVEL_NAME_TOKEN = "level/name";
    public static final String ATTRIBUTE_NAME_TOKEN = "attribute/name";
    private String token;

    public NameTokenGenerator(String string) {
        this.token = string;
    }

    public void generateToken(TokenContext tokenContext) {
        Object object = tokenContext.getObject();
        if (object instanceof DBObject) {
            if (this.token.toLowerCase().endsWith(TOKEN)) {
                AbstractChildDBObject abstractChildDBObject;
                String string = (String)tokenContext.getPropertyValue(TOKEN);
                if (object instanceof CubeDimensionHierarchyLevel) {
                    abstractChildDBObject = (CubeDimensionHierarchyLevel)object;
                    string = abstractChildDBObject.getLevel().getOriginalLevelName();
                }
                if (object instanceof CubeDimensionAttributeMap) {
                    abstractChildDBObject = (CubeDimensionAttributeMap)((Object)object);
                    string = abstractChildDBObject.getAttribute().getName();
                }
                if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(string)) {
                    string = String.format("\"%s\"", string);
                }
                tokenContext.append((Object)string);
            } else {
                String string = (String)tokenContext.getPropertyValue(this.token);
                if (!string.startsWith("\"")) {
                    String[] stringArray = string.split("\\.");
                    boolean bl = false;
                    if (stringArray.length > 1) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(stringArray[i])) continue;
                            bl = true;
                            break;
                        }
                        if (bl) {
                            string = String.format("\"%s\"", string);
                        }
                        tokenContext.append((Object)string);
                    }
                }
            }
        } else {
            tokenContext.append(object);
        }
    }

    public Object evaluateToken(TokenContext tokenContext) {
        return true;
    }
}

