/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import oracle.ide.component.NewFilePanel;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.event.SwingDBObjectListener;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.diff.UpdateProcessorPropertiesFilter;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.ModelUtil;
import oracle.olap.OLAPArb;
import oracle.olap.cube.model.SideEffects;
import oracle.olap.cubexml.ReservedWordsSyntaxHandler;
import oracle.olap.db.BasePanelLibrary;
import oracle.olap.db.CubeSQL;

public class OLAPDDLPanel
extends DefaultTraversablePanel
implements ActionListener {
    protected static final Logger LOG = Logger.getLogger(OLAPDDLPanel.class.getName());
    protected static final String EXT = ".sql";
    protected static URLFilter SQL_FILTER = new DefaultURLFilter(UIBundle.get((String)"SQL_URLFILTER_TEXT"), ".sql");
    protected JButton m_btnSave;
    protected final BasicEditorPane m_txtSQL = new BasicEditorPane();
    protected boolean m_showRadio;
    protected ButtonGroup m_btnGrp;
    protected JRadioButton m_rdbCreate;
    protected JRadioButton m_rdbUpdate;
    protected BasePanelLibrary m_panelLibrary;
    protected DBEditorConfig m_config;
    protected SystemObject m_originalObjectForDDL;
    protected final DBObjectListener m_list = new SwingDBObjectListener(){

        public void updateUI(DBObjectChange dBObjectChange) {
            OLAPDDLPanel.this.updateSQL();
        }
    };

    public OLAPDDLPanel() {
        this(true);
    }

    public OLAPDDLPanel(boolean bl) {
        this.m_showRadio = bl;
        this.setHelpID("f1_odbddl_html");
    }

    protected final DBEditorConfig getEditorConfig() {
        return this.m_config;
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_panelLibrary = (BasePanelLibrary)((Object)traversableContext.find(PanelLibrary.class));
        this.m_config = (DBEditorConfig)traversableContext.find(DBEditorConfig.class);
        this.layoutComponents();
        if (this.m_rdbUpdate != null) {
            this.m_originalObjectForDDL = this.getOriginalObjectForDDL();
            if (this.m_originalObjectForDDL == null) {
                this.m_rdbUpdate.setEnabled(false);
                this.m_rdbCreate.setSelected(true);
            } else {
                this.m_rdbUpdate.setEnabled(true);
                if (this.defaultToAlterWhenEditing()) {
                    this.m_rdbUpdate.setSelected(true);
                } else {
                    this.m_rdbCreate.setSelected(true);
                }
            }
        }
        if (this.m_config != null) {
            SystemObject systemObject = this.m_config.getUpdatedObject();
            systemObject.addObjectListener(this.m_list);
        }
        this.updateSQL();
    }

    private void updateSQL() {
        String string;
        boolean bl = false;
        try {
            string = this.getSQL();
        }
        catch (UnsupportedDDLException unsupportedDDLException) {
            bl = true;
            string = unsupportedDDLException.getMessage();
        }
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        if (string != null) {
            textBuffer.insert(0, string.toCharArray());
        }
        BasicDocument basicDocument = new BasicDocument(textBuffer);
        basicDocument.setLanguageSupport(bl ? "foo.txt" : "foo.sql");
        this.m_txtSQL.setDocument((Document)basicDocument);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        SystemObject systemObject = (SystemObject)traversableContext.get("NewObject");
        systemObject.removeObjectListener(this.m_list);
    }

    protected SystemObject getOriginalObjectForDDL() {
        SystemObject systemObject = this.getEditorConfig().getOriginalObject();
        if (systemObject != null && systemObject.getID() == null) {
            systemObject = null;
        }
        return systemObject;
    }

    protected boolean defaultToAlterWhenEditing() {
        return true;
    }

    protected boolean useProviderTransactionForDiff() {
        return this.m_config != null && this.m_config.isCommitToProvider();
    }

    protected String getSQL() throws UnsupportedDDLException {
        Object object;
        String string;
        Object object2;
        DBObjectTransaction dBObjectTransaction;
        DBObjectProvider dBObjectProvider = this.m_config.getProvider();
        DDLDatabase dDLDatabase = null;
        if (dBObjectProvider instanceof DDLDatabase) {
            dDLDatabase = (DDLDatabase)dBObjectProvider;
        }
        SystemObject systemObject = this.m_config.getUpdatedObject();
        SystemObject systemObject2 = this.m_config.getOriginalObject();
        boolean bl = this.m_config.isReplaceAllowed();
        DDLOptions dDLOptions = new DDLOptions(bl, false);
        DDLGenerator dDLGenerator = OLAPDDLPanel.getDDLGenerator(this.m_config);
        if (dDLGenerator == null) {
            DBLog.getLogger().log(Level.WARNING, "No DDL generator found. DDL panel will not function.");
            return null;
        }
        SystemObject systemObject3 = this.m_rdbCreate != null && this.m_rdbCreate.isSelected() ? null : this.m_originalObjectForDDL;
        Difference difference = null;
        if (this.useProviderTransactionForDiff()) {
            dBObjectTransaction = new DBObjectTransaction(dBObjectProvider);
            dBObjectTransaction.includeUpdate(systemObject3, (SystemObject)DBUtil.makeClonedCopy((DBObject)systemObject));
            if (systemObject instanceof SideEffects) {
                object2 = ((SideEffects)systemObject).getAffectedObjectNew().iterator();
                Iterator<SystemObject> iterator = ((SideEffects)systemObject).getAffectedObjectOld().iterator();
                while (object2.hasNext() && iterator.hasNext()) {
                    string = iterator.next();
                    object = (SystemObject)object2.next();
                    dBObjectTransaction.includeUpdate((SystemObject)string, (SystemObject)DBUtil.makeClonedCopy((DBObject)object));
                }
            }
            dBObjectTransaction.setReplace(true);
            dBObjectTransaction.setCascade(true);
            try {
                object2 = dBObjectTransaction.getTransactionDifference();
                difference = object2.getFilteredDifference(new DifferenceFilter[]{new UpdateProcessorPropertiesFilter(dBObjectProvider)});
                this.print(difference);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (difference == null) {
            difference = dBObjectProvider.getDiffEngine().difference((Object)systemObject3, (Object)systemObject);
        }
        dBObjectTransaction = dDLGenerator.getUpdateDDL(dDLOptions, difference);
        object2 = dBObjectTransaction.getStatements();
        boolean bl2 = false;
        string = "";
        if (object2.size() > 0) {
            string = dBObjectTransaction.toString();
            if ((string = ReservedWordsSyntaxHandler.Process(string)) != null && !string.isEmpty()) {
                try {
                    object = null;
                    object = this.execute(dDLDatabase, bl2, systemObject2, systemObject, (Collection<String>)object2);
                    String string2 = this.getObfuscatedCubeSQL((Collection<String>)object2);
                    string = object;
                    LOG.log(Level.FINEST, string2);
                    LOG.log(Level.FINEST, (String)object);
                }
                catch (DBException dBException) {
                    StringWriter stringWriter = new StringWriter();
                    dBException.printStackTrace(new PrintWriter(stringWriter));
                    String string3 = stringWriter.toString();
                    string = this.getObfuscatedCubeSQL(string);
                    string = string + string3;
                }
            }
        }
        return string;
    }

    private String execute(DDLDatabase dDLDatabase, boolean bl, SystemObject systemObject, SystemObject systemObject2, Collection<String> collection) throws DBException {
        CubeSQL cubeSQL = new CubeSQL(dDLDatabase, bl, systemObject, systemObject2, collection, false);
        Map<String, Object> map = this.m_panelLibrary.getProperties();
        cubeSQL.setProperties(map);
        String string = cubeSQL.execute();
        return string;
    }

    protected String getObfuscatedCubeSQL(Collection<String> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : collection) {
            stringBuffer.append(this.getObfuscatedCubeSQL(string));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected String getObfuscatedCubeSQL(String string) {
        String string2 = string;
        if (string.startsWith("CREATE CUBE DIMENSION ")) {
            string2 = string.replaceFirst("CREATE CUBE DIMENSION ", "CCD ");
        }
        if (string.startsWith("ALTER CUBE DIMENSION ")) {
            string2 = string.replaceFirst("ALTER CUBE DIMENSION ", "ACD ");
        }
        if (string.startsWith("DROP CUBE DIMENSION ")) {
            string2 = string.replaceFirst("DROP CUBE DIMENSION ", "DCD ");
        }
        if (string.startsWith("CREATE CUBE ")) {
            string2 = string.replaceFirst("CREATE CUBE ", "CC ");
        }
        if (string.startsWith("ALTER CUBE ")) {
            string2 = string.replaceFirst("ALTER CUBE ", "AC ");
        }
        if (string.startsWith("DROP CUBE ")) {
            string2 = string.replaceFirst("DROP CUBE ", "DC ");
        }
        if (string.startsWith("CREATE MEASURE FOLDER ")) {
            string2 = string.replaceFirst("CREATE MEASURE FOLDER ", "CMF ");
        }
        if (string.startsWith("ALTER MEASURE FOLDER ")) {
            string2 = string.replaceFirst("ALTER MEASURE FOLDER ", "AMF ");
        }
        if (string.startsWith("DROP MEASURE FOLDER ")) {
            string2 = string.replaceFirst("DROP MEASURE FOLDER ", "DMF ");
        }
        if (string.startsWith("CREATE BUILD PROCESS ")) {
            string2 = string.replaceFirst("CREATE BUILD PROCESS ", "CBP ");
        }
        if (string.startsWith("ALTER BUILD PROCESS ")) {
            string2 = string.replaceFirst("ALTER BUILD PROCESS ", "ABP ");
        }
        if (string.startsWith("DROP BUILD PROCESS ")) {
            string2 = string.replaceFirst("DROP BUILD PROCESS ", "DBP ");
        }
        if (string.startsWith("CREATE ANALYTIC WORKSPACE ")) {
            string2 = string.replaceFirst("CREATE ANALYTIC WORKSPACE ", "CAW ");
        }
        if (string.startsWith("DROP ANALYTIC WORKSPACE ")) {
            string2 = string.replaceFirst("DROP ANALYTIC WORKSPACE ", "DAW ");
        }
        if (string.startsWith("CREATE REALM ")) {
            string2 = string.replaceFirst("CREATE REALM ", "CR ");
        }
        if (string.startsWith("ALTER REALM ")) {
            string2 = string.replaceFirst("ALTER REALM ", "AR ");
        }
        if (string.startsWith("CREATE OLAPACL ")) {
            string2 = string.replaceFirst("CREATE OLAPACL ", "COA ");
        }
        if (string.startsWith("ALTER OLAPACL ")) {
            string2 = string.replaceFirst("ALTER ACL ", "AOA ");
        }
        return string2;
    }

    private void layoutComponents() {
        if (this.getComponentCount() == 0) {
            DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("DDLPanel");
            boolean bl = this.m_config != null && this.m_config.isInFlatEditor();
            DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper((JPanel)((Object)this), bl);
            JLabel jLabel = new JLabel();
            dBUIResourceHelper.resLabel(jLabel, (Component)this.m_txtSQL, OLAPArb.get("OLAPDDL_PANEL_LABEL"), "SQL");
            this.m_btnSave = new JButton();
            this.m_btnSave.addActionListener(this);
            dBUIResourceHelper.resButton((AbstractButton)this.m_btnSave, UIBundle.get((String)"DDL_BUTTON_SAVE"), "Save");
            this.m_txtSQL.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane((Component)this.m_txtSQL);
            dBUILayoutHelper.add((Component)jLabel);
            dBUILayoutHelper.nextRow();
            if (this.m_showRadio) {
                this.m_rdbCreate = new JRadioButton();
                this.m_rdbCreate.addActionListener(this);
                dBUIResourceHelper.resButton((AbstractButton)this.m_rdbCreate, UIBundle.get((String)"DDL_CREATE"), "Create");
                this.m_rdbUpdate = new JRadioButton();
                this.m_rdbUpdate.addActionListener(this);
                dBUIResourceHelper.resButton((AbstractButton)this.m_rdbUpdate, UIBundle.get((String)"DDL_UPDATE"), "Update");
                this.m_btnGrp = new ButtonGroup();
                this.m_btnGrp.add(this.m_rdbCreate);
                this.m_btnGrp.add(this.m_rdbUpdate);
                dBUILayoutHelper.add((Component)this.m_rdbCreate);
                dBUILayoutHelper.add((Component)this.m_rdbUpdate);
                dBUILayoutHelper.nextRow();
            }
            dBUILayoutHelper.add((Component)jScrollPane, 3, 1);
            dBUILayoutHelper.add(Box.createVerticalStrut(200), 1, 1, false, false);
            dBUILayoutHelper.nextRow();
            dBUILayoutHelper.nextColumn();
            dBUILayoutHelper.nextColumn();
            dBUILayoutHelper.add((Component)this.m_btnSave);
            dBUILayoutHelper.getConstraints((Component)this.m_btnSave).anchor = 13;
            dBUILayoutHelper.layout();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_btnSave) {
            Object object2;
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setURLFilter(SQL_FILTER);
            URL uRL = null;
            while (uRLChooser.showSaveDialog((Component)((Object)this)) == 0) {
                uRL = uRLChooser.getSelectedURL();
                if (!ModelUtil.hasLength((String)URLFileSystem.getSuffix((URL)uRL))) {
                    object2 = URLFileSystem.getPath((URL)uRL);
                    uRL = URLFactory.replacePathPart((URL)uRL, (String)((String)object2 + EXT));
                }
                try {
                    uRL = NewFilePanel.validateURL((Component)((Object)this), (URL)uRL, (String)UIBundle.get((String)"SQLFILE_TYPE"), (boolean)true);
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog((Component)((Object)this));
                    break;
                }
                if (uRL == null) continue;
            }
            if (uRL != null) {
                try {
                    object2 = URLFileSystem.openOutputStream((URL)uRL);
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object2, IdeUtil.getIdeEncoding()));
                    bufferedWriter.write(this.m_txtSQL.getText());
                    ((Writer)bufferedWriter).flush();
                    ((Writer)bufferedWriter).close();
                }
                catch (IOException iOException) {
                    DBMessageDialog.showErrorDialog((Exception)iOException, (Object)this, (Level)Level.SEVERE, null, (String)UIBundle.get((String)"DDL_ERROR_SAVE_TITLE"), null);
                }
            }
        } else {
            this.updateSQL();
        }
    }

    public static DDLGenerator getDDLGenerator(DBEditorConfig dBEditorConfig) {
        DDLGenerator dDLGenerator = null;
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        if (dBObjectProvider != null) {
            dDLGenerator = dBObjectProvider.getDescriptor().getDDLGenerator(dBObjectProvider);
        }
        return dDLGenerator;
    }

    protected void print(Difference difference) {
        StringBuilder stringBuilder = new StringBuilder("\n");
        this.toString(difference, stringBuilder, "");
        System.out.println(stringBuilder.toString());
    }

    private void toString(Difference difference, StringBuilder stringBuilder, String string) {
        String string2 = this.toString(difference);
        stringBuilder.append(string).append(string2).append("\n");
        string = string + "  ";
        for (Difference difference2 : difference.getChildren()) {
            this.toString(difference2, stringBuilder, string);
        }
    }

    public String toString(Difference difference) {
        StringBuilder stringBuilder = new StringBuilder();
        if (difference.getPropertyName() != null) {
            boolean bl = difference.isSame();
            String string = difference.getPropertyName();
            stringBuilder.append(bl ? "SAME " : "XXXX ").append("  ");
            stringBuilder.append(string);
            if (difference.isLeaf()) {
                stringBuilder.append("  ").append("(").append(String.valueOf(difference.getOriginalObject())).append(" : ").append(String.valueOf(difference.getUpdatedObject())).append(")");
            }
            int n = difference.getIndexOfOriginalObject();
            int n2 = difference.getIndexOfUpdatedObject();
            if (n >= 0 || n2 >= 0) {
                stringBuilder.append("  ").append(n + " " + n2);
            }
        }
        return stringBuilder.toString();
    }
}

