/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.olap.app.tree.model.Node;
import oracle.olap.app.tree.model.NodeXMLData;
import oracle.olap.app.tree.model.Tree;
import oracle.olap.app.tree.model.TreeTable;
import oracle.olap.app.tree.xmleditor.NodeFold;
import oracle.olap.db.view.DescriptionPanelTreeLoaderXML;

public class LanguageDescriptionsTreeLoaderXML
extends DescriptionPanelTreeLoaderXML {
    private static final String DIMS_NODE = "CubeDimensions";
    private static final String DIM_NODE = "/AnalyticWorkspace/CubeDimensions/CubeDimension/CubeDimensionObject/name";
    private static final String CUBE_NODE = "/AnalyticWorkspace/Cubes/Cube/CubeObject/name";
    private static final String CUBES_NODE = "Cubes";
    private static final String MEASURE_FOLDERS_NODE = "MeasureFolders";
    private static final String MEASURE_FOLDER_NODE = "/AnalyticWorkspace/MeasureFolders/MeasureFolder/MeasureFolderObject/name";
    private boolean dimOpen;
    private boolean cubeOpen;
    private boolean measureFolderOpen;
    List<String> nonAttributeNodes;
    List<String> nodeNamesList;

    public LanguageDescriptionsTreeLoaderXML(String string, Class clazz, String string2, List<String> list) throws Exception {
        super(string, clazz, string2, list);
    }

    @Override
    public String generateXML() {
        this.nonAttributeNodes = new ArrayList<String>();
        this.nodeNamesList = new ArrayList<String>();
        Tree tree = this.getTree();
        Node node = tree.getRoots().get(0);
        StringBuffer stringBuffer = new StringBuffer();
        this.setXMLBuffer(stringBuffer);
        this.setNodeNamesList(this.nodeNamesList);
        this.generateXML(node, (TreeTable)tree);
        return this.getXMLBuffer().toString();
    }

    private void generateXML(Node node, TreeTable treeTable) {
        NodeXMLData nodeXMLData = (NodeXMLData)node.getUserObject();
        if (!nodeXMLData.isAttribute()) {
            this.nonAttributeNodes.add(nodeXMLData.getName());
            this.getXMLBuffer().append(String.format("<%s>\n", nodeXMLData.getName()));
        } else {
            this.openCubeOrDimTag(nodeXMLData);
            boolean bl = this.unfold(node, true);
            if (!bl) {
                this.addAttributesToNode(nodeXMLData, treeTable);
            }
        }
        List<Node> list = node.getChildren();
        for (Node node2 : list) {
            this.generateXML(node2, treeTable);
        }
        if (!nodeXMLData.isAttribute()) {
            this.closeCubeOrDimTag(nodeXMLData);
            this.nonAttributeNodes.remove(nodeXMLData.getName());
            this.getXMLBuffer().append(String.format("</%s>\n", nodeXMLData.getName()));
        } else if (!this.unfold(node, false)) {
            this.closeAttributesNode(nodeXMLData, treeTable);
        }
    }

    private void openCubeOrDimTag(NodeXMLData nodeXMLData) {
        if (nodeXMLData.getName().equals(DIM_NODE)) {
            if (!this.dimOpen) {
                this.getXMLBuffer().append("<CubeDimension>\n");
                this.dimOpen = true;
            } else {
                this.getXMLBuffer().append("</CubeDimension>\n");
                this.getXMLBuffer().append("<CubeDimension>\n");
            }
        } else if (nodeXMLData.getName().equals(CUBE_NODE)) {
            if (!this.cubeOpen) {
                this.getXMLBuffer().append("<Cube>\n");
                this.cubeOpen = true;
            } else {
                this.getXMLBuffer().append("</Cube>\n");
                this.getXMLBuffer().append("<Cube>\n");
            }
        } else if (nodeXMLData.getName().equals(MEASURE_FOLDER_NODE)) {
            if (!this.measureFolderOpen) {
                this.getXMLBuffer().append("<MeasureFolder>\n");
                this.measureFolderOpen = true;
            } else {
                this.getXMLBuffer().append("</MeasureFolder>\n");
                this.getXMLBuffer().append("<MeasureFolder>\n");
            }
        }
    }

    private void closeCubeOrDimTag(NodeXMLData nodeXMLData) {
        if (nodeXMLData.getName().equals(DIMS_NODE)) {
            if (this.dimOpen) {
                this.getXMLBuffer().append("</CubeDimension>\n");
            }
        } else if (nodeXMLData.getName().equals(CUBES_NODE)) {
            if (this.cubeOpen) {
                this.getXMLBuffer().append("</Cube>\n");
            }
        } else if (nodeXMLData.getName().equals(MEASURE_FOLDERS_NODE) && this.measureFolderOpen) {
            this.getXMLBuffer().append("</MeasureFolder>\n");
        }
    }

    @Override
    protected boolean unfold(Node node, boolean bl) {
        NodeXMLData nodeXMLData = (NodeXMLData)node.getUserObject();
        if (this.getXMLEditor() != null) {
            String string = nodeXMLData.getData(0).toString();
            for (NodeFold nodeFold : this.getXMLEditor().getNodeFolds()) {
                if (!nodeFold.getNode().equals(string)) continue;
                String string2 = this.getLeafNodeName(string);
                if (bl) {
                    LanguageDescriptionsTreeLoaderXML.append(this.getXMLBuffer(), " ", this.getDepth());
                    this.getXMLBuffer().append("<" + string2);
                    String string3 = nodeXMLData.getData(1).toString();
                    String string4 = LanguageDescriptionsTreeLoaderXML.getLeafAttributeName(string);
                    this.getXMLBuffer().append(" " + string4 + "=\"" + string3 + "\">\n");
                    this.getNodeNameList().add(string2);
                } else {
                    Set<String> set = this.getTranslationsMap().keySet();
                    for (String string5 : set) {
                        this.getXMLBuffer().append(this.getTranslationsMap().get(string5));
                        this.getTranslationsMap().put(string5, new StringBuffer());
                    }
                    this.getXMLBuffer().append("</" + string2 + ">\n");
                    this.getNodeNameList().remove(string2);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getLeafNodeName(String string) {
        String[] stringArray;
        if (string.startsWith("/")) {
            string = string.substring(1, string.length());
        }
        if ((stringArray = string.split("/")).length > 2) {
            return stringArray[stringArray.length - 2];
        }
        return string;
    }
}

