/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdentifierElement {
    private String[] tokens;
    private String value;
    private final Pattern partPattern = Pattern.compile("(([^.\"]+)|\"(.+?)\")([.=])?");
    private static final int UNQUOTED = 2;
    private static final int QUOTED = 3;
    private static final int BOUNDARY = 4;
    private boolean keepQuotes;
    private static String[][] testCases = new String[][]{{"CHANNEL"}, {"CHANNEL"}, {"SCOTT.EMP"}, {"SCOTT", "EMP"}, {"GLOBAL.\"CHANNEL DIM\""}, {"GLOBAL", "\"CHANNEL DIM\""}, {"GLOBAL.\"TIME\""}, {"GLOBAL", "TIME"}};

    public IdentifierElement(String string) {
        this.init(string);
    }

    public IdentifierElement(String string, boolean bl) {
        this.keepQuotes = bl;
        this.init(string);
    }

    private void init(String string) {
        Matcher matcher = this.partPattern.matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>(3);
        while (matcher.find()) {
            String string2;
            if (matcher.group(2) == null) {
                arrayList.add(matcher.group(3));
            } else {
                arrayList.add(matcher.group(2));
            }
            if ((string2 = matcher.group(4)) == null || !string2.equals("=")) continue;
            if (!matcher.find()) break;
            this.value = matcher.group();
            break;
        }
        this.tokens = new String[arrayList.size()];
        this.tokens = arrayList.toArray(this.tokens);
        if (this.keepQuotes) {
            for (int i = 0; i < this.tokens.length; ++i) {
                if (!this.isQuoteRequired(this.tokens[i])) continue;
                this.tokens[i] = String.format("\"%s\"", this.tokens[i]);
            }
        }
    }

    public String get(int n) {
        return this.tokens[n];
    }

    public String getFirst() {
        return this.get(0);
    }

    public String getSecond() {
        return this.get(1);
    }

    public String getThird() {
        return this.get(2);
    }

    public String getFourth() {
        return this.get(3);
    }

    public int getCount() {
        return this.tokens.length;
    }

    public int getIntValue() {
        if (this.value != null) {
            return Integer.valueOf(this.value);
        }
        return 0;
    }

    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        return "";
    }

    private boolean isQuoteRequired(String string) {
        if (string != null) {
            return string.indexOf(" ") >= 0 || !string.toUpperCase().equals(string);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.tokens.length; ++i) {
            stringBuffer.append(this.tokens[i] + ".");
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '.') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < testCases.length; i += 2) {
            String[] stringArray2 = testCases[i];
            System.out.print(stringArray2[0] + "=");
            IdentifierElement identifierElement = new IdentifierElement(stringArray2[0], true);
            String[] stringArray3 = testCases[i + 1];
            for (int j = 0; j < stringArray3.length; ++j) {
                if (!identifierElement.get(j).equals(stringArray3[j])) {
                    System.out.println("Failed expected " + stringArray3[j] + "Got " + identifierElement.get(j));
                    continue;
                }
                System.out.print(identifierElement.get(j) + ",");
            }
            System.out.println();
        }
    }
}

