/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import oracle.dbtools.db.DBUtil;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.cube.CubeBuilder;
import oracle.olap.cube.model.Cube;

public class CubeList {
    private OracleDatabaseImpl db;
    private Schema schema;
    private List<Cube> cubes;
    private CubeBuilder cubeBuilder = null;

    public CubeList(OracleDatabaseImpl oracleDatabaseImpl, Schema schema) {
        this.db = oracleDatabaseImpl;
        this.schema = schema;
        this.cubes = new ArrayList<Cube>();
        this.cubeBuilder = new CubeBuilder(oracleDatabaseImpl);
    }

    private void addCube(String string, String string2, boolean bl) throws DBException, SQLException, IOException, JAXBException {
        if (this.cubeBuilder != null) {
            NameBasedID nameBasedID = new NameBasedID("CUBE DIMENSION", this.schema.getName(), string2, (AbstractDBObjectProvider)this.db);
            Cube cube = this.cubeBuilder.createObject(string2, this.schema, (DBObjectID)nameBasedID);
            cube.setAnalyticWorkspace(string);
            if (bl) {
                this.cubeBuilder.buildDetails(cube);
            } else {
                this.cubeBuilder.build(cube);
            }
            this.cubes.add(cube);
        }
    }

    public void build(Cube cube, boolean bl) throws DBException, SQLException, IOException, JAXBException {
        if (bl) {
            this.cubeBuilder.buildDetails(cube);
        } else {
            this.cubeBuilder.build(cube);
        }
    }

    public List<Cube> getCubes() throws DBException, SQLException, IOException, JAXBException {
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.db.getConnection());
        this.cubes = new ArrayList<Cube>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", this.schema.getName());
        String string = "select cube_name, aw_name from all_cubes where owner = :owner order by aw_name, cube_name";
        List list = dBUtil.executeReturnList(string, hashMap);
        boolean bl = false;
        for (Map map : list) {
            String string2 = (String)map.get("CUBE_NAME");
            String string3 = (String)map.get("AW_NAME");
            this.addCube(string3, string2, bl);
        }
        return this.cubes;
    }
}

