/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubexml;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.olap.cubexml.MetadataContext;
import oracle.olap.db.IdentifierElement;
import oracle.olap.db.LanguageDBSettings;
import oracle.olap.db.model.Descriptions;
import oracle.olap.syntax.SyntaxTree;
import oracle.olap.syntax.SyntaxVisitor;
import oracle.olap.xmlbind.Description;
import oracle.olapi.syntax.ColumnExpression;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.SyntaxObject;

public abstract class BaseCubeXML {
    private static final Logger LOG = Logger.getLogger(BaseCubeXML.class.getName());
    private MetadataContext metadataContext;
    protected String defaultLanguage = "";
    static final String ADD = "ADD";
    static final String CLEAR = "CLEAR";
    static final String REMOVE = "REMOVE";
    private static final String XML_SHORT_DESCRIPTION = "ShortDescription";
    private static final String XML_LONG_DESCRIPTION = "LongDescription";
    private static final String XML_DESCRIPTION = "Description";
    private static String extractedSource;

    public BaseCubeXML(MetadataContext metadataContext) {
        this.metadataContext = metadataContext;
        try {
            this.defaultLanguage = LanguageDBSettings.getDefaultLanguage();
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger(BaseCubeXML.class.getName());
            logger.log(Level.SEVERE, "Error getting the default language", exception);
        }
    }

    public MetadataContext getMetadataContext() {
        return this.metadataContext;
    }

    protected void loadDescription(Descriptions descriptions, Description description) {
        if (description != null && descriptions != null && description.getLanguage().equalsIgnoreCase(this.defaultLanguage)) {
            String string;
            if (description.getType().equals(XML_SHORT_DESCRIPTION)) {
                string = description.getValueToFixError1();
                if (string == null) {
                    string = "";
                }
                descriptions.setShortDescription(string);
            }
            if (description.getType().equals(XML_LONG_DESCRIPTION)) {
                string = description.getValueToFixError1();
                if (string == null) {
                    string = "";
                }
                descriptions.setLongDescription(string);
            }
            if (description.getType().equals(XML_DESCRIPTION)) {
                string = description.getValueToFixError1();
                if (string == null) {
                    string = "";
                }
                descriptions.setDescription(string);
            }
        }
    }

    protected List<Description> saveDescriptions(Descriptions descriptions) {
        Object object;
        Object object2;
        ArrayList<Description> arrayList = new ArrayList<Description>();
        String string = descriptions.getShortDescription();
        if (string != null && (this.metadataContext.isModified("shortDescription") || this.metadataContext.getOriginalObject() == null)) {
            object2 = new Description();
            ((Description)object2).setType(XML_SHORT_DESCRIPTION);
            ((Description)object2).setLanguage(this.defaultLanguage);
            ((Description)object2).setValueToFixError1(string);
            arrayList.add((Description)object2);
        }
        if ((object2 = descriptions.getLongDescription()) != null && (this.metadataContext.isModified("longDescription") || this.metadataContext.getOriginalObject() == null)) {
            object = new Description();
            ((Description)object).setType(XML_LONG_DESCRIPTION);
            ((Description)object).setLanguage(this.defaultLanguage);
            ((Description)object).setValueToFixError1((String)object2);
            arrayList.add((Description)object);
        }
        if ((object = descriptions.getDescription()) != null && (this.metadataContext.isModified("description") || this.metadataContext.getOriginalObject() == null)) {
            Description description = new Description();
            description.setType(XML_DESCRIPTION);
            description.setLanguage(this.defaultLanguage);
            description.setValueToFixError1((String)object);
            arrayList.add(description);
        }
        return arrayList;
    }

    private static boolean isQuoteRequired(String string) {
        if (string != null) {
            return string.indexOf(" ") >= 0 || !string.toUpperCase().equals(string);
        }
        return false;
    }

    protected String processQuery(String string) {
        String string2 = string;
        if (string != null) {
            boolean bl = true;
            IdentifierElement identifierElement = new IdentifierElement(string, bl);
            if (identifierElement.getCount() == 2) {
                string2 = identifierElement.toString();
            } else {
                string2 = BaseCubeXML.stripQuotes(string);
                if (BaseCubeXML.isQuoteRequired(string)) {
                    string2 = string;
                }
            }
        }
        return string2;
    }

    public static String processExpression(String string) {
        if (string != null) {
            String string2;
            String string3 = BaseCubeXML.getSourceFromExpression(string);
            if (string3.startsWith("\"")) {
                string2 = BaseCubeXML.stripQuotes(string3);
                if (!BaseCubeXML.isQuoteRequired(string3)) {
                    string = string.replaceAll(string3, string2);
                }
            }
            if (string.startsWith(string3 + ".")) {
                string2 = string.substring(string3.length() + 1, string.length());
                if (string2.startsWith("\"") && string2.endsWith("\"") && !BaseCubeXML.isQuoteRequired(string2)) {
                    string2 = BaseCubeXML.stripQuotes(string2);
                }
                string = String.format("%s.%s", string3, string2);
            }
        }
        return string;
    }

    public static String getSourceFromExpression(String string) {
        extractedSource = "";
        if (string != null && !string.isEmpty()) {
            try {
                SyntaxObject syntaxObject = SyntaxObject.fromSyntax((String)string, null, null);
                SyntaxTree.Traverse(syntaxObject, new SyntaxVisitor(){

                    @Override
                    public void visit(SyntaxObject syntaxObject) throws SQLException {
                        if (syntaxObject instanceof ColumnExpression) {
                            ColumnExpression columnExpression = (ColumnExpression)syntaxObject;
                            Query query = columnExpression.getQuery();
                            extractedSource = query.toSyntax();
                        }
                    }
                });
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return extractedSource;
    }

    static String stripQuotes(String string) {
        if (string != null) {
            if (string.startsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            if (string.endsWith("\"")) {
                string = string.substring(0, string.length() - 2);
            }
        }
        return string;
    }
}

