/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubeviewer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.olap.OLAPArb;
import oracle.olap.app.ui.HelpProvider;
import oracle.olap.cubeviewer.CubeET;
import oracle.olap.cubeviewer.CubeQueryEditorPanel;
import oracle.olap.data.CubeMetadataContext;

public class CubeQueryEditorDialog
extends JDialog {
    private CubeQueryEditorPanel queryPanel;
    private CubeET cubeET;
    private final HelpProvider helpProvider;
    private JPanel panel = new JPanel();
    private Action okAction;
    private Action cancelAction;
    private Action helpAction;
    private boolean isCancel;

    public CubeQueryEditorDialog(Window window, HelpProvider helpProvider, CubeMetadataContext cubeMetadataContext, CubeET cubeET) throws SQLException, IOException {
        super(window);
        this.helpProvider = helpProvider;
        this.cubeET = cubeET;
        this.queryPanel = new CubeQueryEditorPanel(window, cubeMetadataContext, cubeET);
        this.setTitle(OLAPArb.format("CUBE_QUERY_EDITOR_TITLE", cubeMetadataContext.getCube().getSchema().getName(), cubeMetadataContext.getCube().getName()));
        this.setSize(600, 400);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CubeQueryEditorDialog.this.dispose();
            }
        };
        this.cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CubeQueryEditorDialog.this.isCancel = true;
                CubeQueryEditorDialog.this.dispose();
            }
        };
        this.helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CubeQueryEditorDialog.this.helpProvider.showHelp(CubeQueryEditorDialog.this.panel, "olap_cube_query_editor_dialog");
            }
        };
        this.layoutComponents();
        this.registerKeyboardActions();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    private void layoutComponents() {
        JButton jButton = new JButton(this.okAction);
        jButton.setText(OLAPArb.get("DIALOG_OK_BUTTON_TEXT"));
        JButton jButton2 = new JButton(this.cancelAction);
        jButton2.setText(OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT"));
        JButton jButton3 = new JButton(this.helpAction);
        jButton3.setText(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        jButton3.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)jButton, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)jButton2, DialogButtonBar.CONSTRAINT_CANCEL);
        dialogButtonBar.add((Component)jButton3, DialogButtonBar.CONSTRAINT_HELP);
        this.panel = new JPanel();
        this.setContentPane(this.panel);
        this.panel.setLayout(new GridBagLayout());
        int n = 0;
        this.add((Component)this.queryPanel, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)dialogButtonBar, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this.okAction, KeyStroke.getKeyStroke(10, 0), 1);
        jRootPane.registerKeyboardAction(this.cancelAction, KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke(112, 0), 1);
    }
}

