/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplateimpl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.sql.Connection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import oracle.bali.share.nls.StringUtils;
import oracle.olap.OLAPArb;
import oracle.olap.app.db.DatabaseUtils;

public class ImportFromTemplateDialog
extends JDialog {
    private final String owner;
    private final transient Connection conn;
    private boolean m_clickedOK = false;
    private JButton m_btnOK;
    private JButton m_btnCancel;
    private JComboBox cboAWs;
    private JTextField dirName;

    public ImportFromTemplateDialog(Frame frame, Connection connection, String string) {
        super(frame, OLAPArb.get("IMPORTXML_DIALOG_TITLE"), true);
        this.owner = string;
        this.conn = connection;
        this.initDialog();
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        int n;
        int n2;
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() != 101) {
            return;
        }
        int n3 = n2 = this.getWidth();
        int n4 = n = this.getHeight();
        Dimension dimension = this.getMinimumSize();
        n3 = Math.max(dimension.width, n3);
        n4 = Math.max(dimension.height, n4);
        if (n2 != n3 || n != n4) {
            this.setSize(n3, n4);
        }
    }

    private void initDialog() {
        this.m_btnOK = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_OK_BUTTON_TEXT")));
        this.m_btnOK.setName("m_btnOK");
        this.m_btnOK.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_OK_BUTTON_TEXT")));
        this.m_btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportFromTemplateDialog.this.m_clickedOK = true;
                ImportFromTemplateDialog.this.setVisible(false);
            }
        });
        this.m_btnCancel = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        this.m_btnCancel.setName("m_btnCancel");
        this.m_btnCancel.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        this.m_btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportFromTemplateDialog.this.m_clickedOK = false;
                ImportFromTemplateDialog.this.setVisible(false);
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("panel");
        JLabel jLabel = new JLabel(OLAPArb.get("IMPORTXML_AW_NAME_LABEL"));
        jLabel.setName("lblAWName");
        this.cboAWs = new JComboBox();
        this.cboAWs.setName("cboAWs");
        this.cboAWs.setEditable(false);
        jPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.cboAWs, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(10, 4, 0, 0);
        jPanel.add((Component)this.getOKCancelPanel(), gridBagConstraints);
        this.add(jPanel);
        this.populateAWNames();
    }

    private JPanel getOKCancelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("panel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.m_btnOK, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.m_btnCancel, gridBagConstraints);
        return jPanel;
    }

    private void populateAWNames() {
        String string = "SELECT AW_NAME FROM ALL_AWS WHERE OWNER = :1";
        List list = null;
        try {
            list = DatabaseUtils.ExecuteSQL(this.conn, string, this.owner);
            for (List list2 : list) {
                this.cboAWs.addItem(list2.get(0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getAWName() {
        String string = null;
        string = (String)this.cboAWs.getSelectedItem();
        return string;
    }

    public String getTemplateFileName() {
        String string = null;
        this.dirName = new JTextField(1024);
        this.dirName.setName("dirName");
        string = this.dirName.getText();
        return string;
    }

    public boolean isOKSelected() {
        return this.m_clickedOK;
    }
}

