/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplateimpl;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.app.table.Queries;
import oracle.olap.cubetemplate.ExportPreprocessor;
import oracle.olap.cubetemplate.ObjectType;
import oracle.olap.cubetemplate.TreeNode;
import oracle.olap.dml.DMLObject;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasureNode;

public class ExportPreprocessorImpl
implements ExportPreprocessor {
    private final Connection conn;
    private String qualifiedWorkspace;
    private boolean supportsRecursive;
    private final List<DMLObject> dmlObjects;
    private List<Object> bos;
    private Map<Object, String> bindMap;
    private boolean importingWorkspace;
    private List<String> awObjects;
    private static final String XMLFILE = "exportpreprocessor.xml";
    private static final String CUBEAW = "CUBEAW";
    private static final String DIMAW = "DIMAW";
    private static final String MEASUREFOLDERAW = "MEASUREFOLDERAW";
    private static final String DEPENDENCIES_DEF = "DEPENDENCIES";
    private static final String DEPENDENCIES_NAME = "__AWM_TEMP_PROGRAM";
    private static final String OBJECTDML = "OBJECTDML";
    private String previouslyAttachedModeInSession = null;
    private boolean wasPreviousAttachmentModeChecked = false;
    private Queries queries;

    public ExportPreprocessorImpl(Connection connection) {
        this.conn = connection;
        this.dmlObjects = new ArrayList<DMLObject>();
        try {
            String string = "oracle.olap.app.table";
            String string2 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
            JavaXMLBind.BindToJavaStr(string2, string, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addQueries(Queries queries) {
        this.queries = queries;
    }

    private String getPreviouslyAttachedModeInSession(String string) throws SQLException, IOException {
        if (!this.wasPreviousAttachmentModeChecked) {
            this.wasPreviousAttachmentModeChecked = true;
            this.previouslyAttachedModeInSession = DMLObject.getAWAttachModeInSession(this.conn, string);
        }
        return this.previouslyAttachedModeInSession;
    }

    private void setQualifiedWorkspace(String string) throws SQLException, IOException {
        this.qualifiedWorkspace = string;
        if (this.awObjects == null) {
            DMLObject dMLObject = new DMLObject(this.conn, this.qualifiedWorkspace, null);
            String string2 = this.getPreviouslyAttachedModeInSession(this.qualifiedWorkspace);
            if (string2 == null || !string2.equalsIgnoreCase("RW")) {
                DMLObject.runDML(this.conn, "ATTACH_AW_RO_FIRST", this.qualifiedWorkspace);
            }
            String[] stringArray = dMLObject.getWorkspaceObjects().split("\n");
            this.awObjects = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("NA")) continue;
                this.awObjects.add(stringArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processObjects(List<Object> list) throws SQLException, IOException {
        block16: {
            try {
                Object object;
                Object object2;
                this.bos = new ArrayList<Object>();
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                this.bindMap = new HashMap<Object, String>();
                for (Object iterator : list) {
                    if (!(iterator instanceof DBObject)) continue;
                    object2 = (DBObject)iterator;
                    string2 = this.getAWName((DBObject)object2);
                    string = this.getOwnerCube((DBObject)object2);
                    string3 = this.getMeasure((DBObject)object2);
                    string4 = object2.getSchemaName();
                    if (string2 != null) {
                        this.setQualifiedWorkspace(String.format("%s.%s", string4, string2));
                    }
                    object = ObjectType.fromNodeType(object2.getObjectType());
                    switch (1.$SwitchMap$oracle$olap$cubetemplate$ObjectType[((Enum)object).ordinal()]) {
                        case 1: {
                            this.importingWorkspace = true;
                            this.getDMLFromAW();
                            this.bos.add(new TreeNode(this.getQualifiedWorkspace() + ".AW", (ObjectType)((Object)object), false));
                            break;
                        }
                        case 2: {
                            this.getObjectDML(string4, string, string3);
                        }
                        case 3: 
                        case 4: {
                            this.bos.add(new TreeNode(String.format("%s.%s", object2.getSchemaName(), object2.getObjectName()), (ObjectType)((Object)object), false));
                            if (string2 == null || this.bindMap.containsKey(string2)) break;
                            this.bindMap.put(new TreeNode(string2, null, ObjectType.WORKSPACE), "__AW_NAME__");
                            break;
                        }
                        case 5: 
                        case 6: {
                            this.getObjectDML(string4, string, string3);
                            this.bos.add(new TreeNode(string3, String.format("%s.%s", object2.getSchemaName(), string), (ObjectType)((Object)object)));
                            if (!this.bindMap.containsKey(string2)) {
                                this.bindMap.put(new TreeNode(string2, null, ObjectType.WORKSPACE), "__AW_NAME__");
                            }
                            if (this.bindMap.containsKey(string)) break;
                            this.bindMap.put(new TreeNode(string, string2, ObjectType.CUBE), "__CUBE_NAME__");
                        }
                    }
                }
                this.supportsRecursive = false;
                if (!this.importingWorkspace) {
                    ArrayList<DMLObject> arrayList = new ArrayList<DMLObject>(this.dmlObjects);
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        object2 = (DMLObject)iterator.next();
                        object = ((DMLObject)object2).getDependencies(this.supportsRecursive);
                        Iterator<DMLObject> iterator2 = object.iterator();
                        while (iterator2.hasNext()) {
                            DMLObject dMLObject = iterator2.next();
                            this.addDML(dMLObject);
                        }
                    }
                }
                if (this.bindMap.size() != 0) break block16;
                this.bindMap = null;
            }
            catch (Throwable throwable) {
                if (this.getPreviouslyAttachedModeInSession(this.qualifiedWorkspace) == null) {
                    DMLObject.runDML(this.conn, "DETACH_AW", this.qualifiedWorkspace);
                }
                throw throwable;
            }
        }
        if (this.getPreviouslyAttachedModeInSession(this.qualifiedWorkspace) == null) {
            DMLObject.runDML(this.conn, "DETACH_AW", this.qualifiedWorkspace);
        }
    }

    public String getAWName(DBObject dBObject) throws SQLException, IOException {
        ObjectType objectType = ObjectType.fromNodeType(dBObject.getObjectType());
        switch (objectType) {
            case WORKSPACE: {
                return dBObject.getObjectName();
            }
            case CUBE: {
                return this.getAWNameQuery(CUBEAW, dBObject.getSchemaName(), dBObject.getObjectName());
            }
            case DIMENSION: {
                return this.getAWNameQuery(DIMAW, dBObject.getSchemaName(), dBObject.getObjectName());
            }
            case MEASURE_FOLDER: {
                return this.getAWNameQuery(MEASUREFOLDERAW, dBObject.getSchemaName(), dBObject.getObjectName());
            }
            case MEASURE: {
                if (dBObject.getNode() instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)dBObject.getNode();
                    return this.getAWNameQuery(CUBEAW, objectNode.getSchemaName(), (String)objectNode.getProperty("CUBE_NAME"));
                }
                return null;
            }
            case DERIVED_MEASURE: {
                if (dBObject.getNode() instanceof CalculatedMeasureNode) {
                    CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)dBObject.getNode();
                    return this.getAWNameQuery(CUBEAW, calculatedMeasureNode.getSchemaName(), calculatedMeasureNode.getCubeName());
                }
                return null;
            }
        }
        return null;
    }

    private String getAWNameQuery(String string, String string2, String string3) throws SQLException, IOException {
        String string4 = this.queries.getSQL(string);
        List list = null;
        list = string.equals(MEASUREFOLDERAW) ? DatabaseUtils.ExecuteSQL(this.conn, string4, new Object[]{string2, string3, string2}) : DatabaseUtils.ExecuteSQL(this.conn, string4, new Object[]{string2, string3});
        return (String)((List)list.get(0)).get(0);
    }

    public String getOwnerCube(DBObject dBObject) {
        ObjectType objectType = ObjectType.fromNodeType(dBObject.getObjectType());
        if (objectType == ObjectType.CUBE) {
            return dBObject.getObjectName();
        }
        if (objectType == ObjectType.DERIVED_MEASURE) {
            if (dBObject.getNode() instanceof CalculatedMeasureNode) {
                CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)dBObject.getNode();
                return calculatedMeasureNode.getCubeName();
            }
        } else if (objectType == ObjectType.MEASURE && dBObject.getNode() instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)dBObject.getNode();
            return (String)objectNode.getProperty("CUBE_NAME");
        }
        return null;
    }

    private void addDML(DMLObject dMLObject) {
        String string;
        if (this.awObjects.contains(dMLObject) && !this.dmlObjects.contains(dMLObject) && (string = dMLObject.getName()) != null && !string.contains("CALC_MMBR_PARENT") && !string.contains("CALC_MMBR_INHIER")) {
            this.dmlObjects.add(dMLObject);
        }
    }

    @Override
    public List<DMLObject> getDMLObjects() {
        return this.dmlObjects;
    }

    private void getDMLFromAW() {
        for (String string : this.awObjects) {
            DMLObject dMLObject = new DMLObject(this.conn, this.qualifiedWorkspace, string);
            this.addDML(dMLObject);
        }
    }

    @Override
    public String getQualifiedWorkspace() {
        return this.qualifiedWorkspace;
    }

    @Override
    public boolean isSupportsRecursive() {
        return this.supportsRecursive;
    }

    @Override
    public Map<Object, String> getBindMap() {
        return this.bindMap;
    }

    @Override
    public boolean isImportingWorkspace() {
        return this.importingWorkspace;
    }

    @Override
    public List<Object> getOLAPObjects() {
        return this.bos;
    }

    private String getMeasure(DBObject dBObject) {
        ObjectType objectType = ObjectType.fromNodeType(dBObject.getObjectType());
        if (objectType == ObjectType.DERIVED_MEASURE) {
            return ((CalculatedMeasureNode)dBObject.getNode()).getMeasureName();
        }
        if (objectType == ObjectType.MEASURE) {
            return dBObject.getObjectName();
        }
        return null;
    }

    private void getObjectDML(String string, String string2, String string3) throws SQLException, IOException {
        CallableStatement callableStatement = this.conn.prepareCall(this.queries.getSQL(OBJECTDML));
        callableStatement.setString(1, this.getQualifiedWorkspace());
        callableStatement.setString(2, string);
        callableStatement.setString(3, string2);
        callableStatement.setString(4, string3);
        callableStatement.registerOutParameter(5, 12);
        callableStatement.execute();
        String string4 = callableStatement.getString(5);
        if (string4 != null) {
            String[] stringArray = string4.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                this.addDML(new DMLObject(this.conn, this.qualifiedWorkspace, stringArray[i]));
                DMLObject dMLObject = new DMLObject(this.conn, this.getQualifiedWorkspace(), DEPENDENCIES_NAME, String.format(this.queries.getSQL(DEPENDENCIES_DEF), stringArray[i]));
                if (dMLObject.isExists()) {
                    dMLObject.drop();
                }
                dMLObject.create();
                List<DMLObject> list = dMLObject.getDependencies(this.isSupportsRecursive());
                for (DMLObject dMLObject2 : list) {
                    this.addDML(dMLObject2);
                }
                if (!dMLObject.isExists()) continue;
                dMLObject.drop();
            }
        }
    }
}

