/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.olap.app.ErrorDisplay;
import oracle.olap.app.Resources;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.cubetemplate.CubeCatalogDialog;
import oracle.olap.cubetemplate.ObjectType;
import oracle.olap.cubetemplate.SelectorModel;

public class TemplateSelector
extends JPanel
implements MouseListener {
    private final JTable table;
    private final SelectorModel dm;
    private final JDialog parent;
    private final Resources resources;
    private final ErrorDisplay errorDisplay;
    private static Icon sortDesc;
    private static Icon sortAsc;

    public TemplateSelector(Connection connection, ObjectType objectType, CubeCatalogDialog.Mode mode, JDialog jDialog, Resources resources, ErrorDisplay errorDisplay) {
        this.parent = jDialog;
        this.resources = resources;
        this.errorDisplay = errorDisplay;
        this.setLayout(new BorderLayout());
        this.dm = new SelectorModel(connection);
        this.dm.setObjectType(objectType);
        this.table = new JTable();
        this.table.setName("table");
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JComponent) {
                    ((JComponent)component).setToolTipText((String)object);
                }
                return component;
            }
        };
        this.table.setDefaultRenderer(Object.class, defaultTableCellRenderer);
        this.table.setAutoResizeMode(0);
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setModel(this.dm);
        if (mode == CubeCatalogDialog.Mode.IMPORT) {
            this.table.setSelectionMode(2);
        } else {
            this.table.setSelectionMode(0);
        }
        this.table.setCellSelectionEnabled(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.addColumn(new TableColumn(2, 100));
        this.table.addColumn(new TableColumn(5, 145));
        this.table.addColumn(new TableColumn(6, 85));
        this.table.addColumn(new TableColumn(0, 79));
        this.table.addColumn(new TableColumn(3, 54));
        this.table.addColumn(new TableColumn(4, 85));
        this.table.getColumn("MODIFIED").setCellRenderer(new DefaultTableCellRenderer(){
            private DateFormat df = DateFormat.getDateTimeInstance(3, 3);
            String loading = TemplateSelector.access$000(TemplateSelector.this).getString("EXPORT_TO_TABLE.DIALOG.GRID.LOADING");

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object instanceof Timestamp) {
                    object = this.df.format(new Date(((Timestamp)object).getTime()));
                } else if (object == null) {
                    object = this.loading;
                }
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JComponent) {
                    ((JComponent)component).setToolTipText((String)object);
                }
                return component;
            }
        });
        this.table.addMouseListener(this);
        this.table.getTableHeader().addMouseListener(this);
        this.table.getTableHeader().setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (TemplateSelector.this.dm.isSortedBy(jTable.convertColumnIndexToModel(n2))) {
                    defaultTableCellRenderer.setFont(this.getFont().deriveFont(1));
                    if (TemplateSelector.this.dm.isDesc()) {
                        defaultTableCellRenderer.setIcon(sortDesc);
                    } else {
                        defaultTableCellRenderer.setIcon(sortAsc);
                    }
                } else {
                    defaultTableCellRenderer.setIcon(null);
                }
                defaultTableCellRenderer.setForeground(jTable.getTableHeader().getForeground());
                defaultTableCellRenderer.setBackground(jTable.getTableHeader().getBackground());
                defaultTableCellRenderer.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                defaultTableCellRenderer.setHorizontalAlignment(0);
                return defaultTableCellRenderer;
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setName("scroll");
        jScrollPane.setPreferredSize(this.getPreferredSize());
        this.add((Component)jScrollPane, "Center");
    }

    public static void setUpIcons(FetchIcon fetchIcon) {
        sortDesc = fetchIcon.getIcon("OLAPTEMPLATESORTDESC");
        sortAsc = fetchIcon.getIcon("OLAPTEMPLATESORCASC");
    }

    public void setFilter(String string) {
        this.dm.setFilter(string);
    }

    public void refresh() {
        this.refresh(null);
    }

    public void refresh(String string) {
        try {
            this.table.clearSelection();
            if (string != null) {
                this.dm.setSchema(string);
            }
            this.dm.loadData(null);
        }
        catch (SQLException sQLException) {
            ExceptionDialog.showExceptionDialog((Component)this.parent, (Throwable)sQLException, (String)this.resources.getString("EXPORT_TO_TABLE_DIALOG_ERROR_SYNTAX_TITLE"), (String)this.resources.getString("EXPORT_TO_TABLE_DIALOG_ERROR_SYNTAX_MESSAGE"), null);
        }
    }

    public void setObjectType(ObjectType objectType) {
        this.dm.setObjectType(objectType);
    }

    public void addSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.table.addMouseListener(mouseListener);
    }

    public String getString(int n) {
        if (!this.isRowSelected()) {
            return null;
        }
        Object object = this.dm.getValueAt(this.table.getSelectedRow(), n);
        if (object == null) {
            return "";
        }
        return String.valueOf(object);
    }

    public Object getValue(int n) {
        if (!this.isRowSelected()) {
            return null;
        }
        return this.dm.getValueAt(this.table.getSelectedRow(), n);
    }

    public Object getValueForTemplateName(String string, int n) {
        for (int i = 0; i < this.dm.getRowCount(); ++i) {
            String string2 = (String)this.dm.getValueAt(i, 2);
            if (!string.equals(string2)) continue;
            return this.dm.getValueAt(i, n);
        }
        return null;
    }

    public boolean containsTemplateName(String string, String string2, String string3) {
        for (int i = 0; i < this.dm.getRowCount(); ++i) {
            String string4 = (String)this.dm.getValueAt(i, 2);
            String string5 = (String)this.dm.getValueAt(i, 5);
            if (string5 == null) {
                string5 = "";
            }
            String string6 = (String)this.dm.getValueAt(i, 6);
            if (!string.equals(string4) || !string2.equalsIgnoreCase(string5) || !string3.equalsIgnoreCase(string6)) continue;
            return true;
        }
        return false;
    }

    public Object[] getValues(int n) {
        if (!this.isRowSelected()) {
            return new Object[0];
        }
        int[] nArray = this.table.getSelectedRows();
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = this.dm.getValueAt(nArray[i], n);
        }
        return objectArray;
    }

    public boolean isRowSelected() {
        return this.table.getSelectedRow() >= 0 && this.table.getSelectedRow() < this.table.getRowCount();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getSource() == this.table.getTableHeader() && mouseEvent.getClickCount() == 1 && (n = this.table.columnAtPoint(mouseEvent.getPoint())) != -1) {
            this.dm.setSortColumn(this.table.convertColumnIndexToModel(n));
            this.refresh();
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getSource() == this.table) {
            n = this.table.rowAtPoint(mouseEvent.getPoint());
            this.table.setRowSelectionInterval(n, n);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void selectFirst() {
        if (this.table.getSelectedRowCount() == 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    static /* synthetic */ Resources access$000(TemplateSelector templateSelector) {
        return templateSelector.resources;
    }
}

