/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import oracle.olap.app.ErrorDisplay;
import oracle.olap.app.Resources;
import oracle.olap.dml.DMLObject;

public class DMLTemplate {
    static final String TEMPLATE_DML_OBJECT = "<!-- OLAP DML OBJECT:";
    static final String TEMPLATE_DML_CODE = "<!-- OLAP DML CODE";
    private final ErrorDisplay errorDisplay;
    private final Resources resources;

    public DMLTemplate(ErrorDisplay errorDisplay, Resources resources) {
        this.errorDisplay = errorDisplay;
        this.resources = resources;
    }

    public static List<String> getDMLFileNames(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray[i];
                if (string.toUpperCase().endsWith(".XML")) {
                    string = string.substring(0, string.length() - 4);
                }
                if (stringArray[i].endsWith(".XML")) {
                    string = string + ".DML";
                }
                if (stringArray[i].endsWith(".xml")) {
                    string = string + ".dml";
                }
                if (!new File(string).exists()) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public boolean createDMLAskUser(List<String> list, Component component) {
        if (list.size() > 0) {
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            for (String string2 : list) {
                stringBuffer.append(string2 + ",");
            }
            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
            String string3 = this.resources.getString("XML.IMPORT.CREATE.DML", stringBuffer.toString());
            string2 = this.resources.getString("XML.IMPORT.CREATE.DML.TITLE");
            if (0 == JOptionPane.showConfirmDialog(component, string3, string2, 0)) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public static void saveDMLObjects(Writer writer, List<DMLObject> list, boolean bl) throws IOException, SQLException {
        if (!list.isEmpty()) {
            for (DMLObject dMLObject : list) {
                if (bl) {
                    writer.write(10);
                    writer.write(TEMPLATE_DML_OBJECT);
                    writer.write(dMLObject.getName());
                    writer.write("-->\n");
                    writer.write(TEMPLATE_DML_CODE);
                    writer.write(10);
                    writer.write(dMLObject.fetchDefinition());
                    writer.write("\n\n-->");
                    continue;
                }
                writer.write(dMLObject.fetchDefinition());
                writer.write("\n\n");
            }
        }
    }

    public static Map<String, String> getDMLFromXML(String string) throws IOException {
        File file;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = "";
        String string3 = "";
        int n = 0;
        int n2 = 0;
        String string4 = "";
        if (string != null && string.length() > 0 && (string4 = (file = new File(string)).exists() ? DMLTemplate.readFile(string) : string) != null && string4.indexOf(TEMPLATE_DML_OBJECT) > -1) {
            boolean bl = true;
            String string5 = string4.substring(string4.indexOf(TEMPLATE_DML_OBJECT));
            while (bl) {
                if (string5.length() > 0 && string5.indexOf(TEMPLATE_DML_OBJECT) > -1) {
                    string2 = "";
                    string3 = "";
                    n = string5.indexOf(TEMPLATE_DML_OBJECT) + 21;
                    n2 = string5.indexOf("-->", n);
                    if (n2 - n > 0) {
                        string2 = string5.substring(n, n2).trim();
                    }
                    if ((n2 = (string5 = string5.substring(n2 + 4)).indexOf("-->", n = string5.indexOf(TEMPLATE_DML_CODE) + 18) - 1) - n > 0) {
                        string3 = string5.substring(n, n2);
                    }
                    if (string2.length() > 0 && string3.length() > 0 && !string2.contains("CALC_MMBR_PARENT") && !string2.contains("CALC_MMBR_INHIER")) {
                        hashMap.put(string2, string3);
                    }
                    if (n2 > 0) {
                        string5 = string5.substring(n2 + 4);
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            }
        }
        return hashMap;
    }

    public boolean executeCreateDML(Connection connection, String string, Map<String, String> map, boolean bl) throws SQLException, IOException {
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = DMLObject.getAWAttachModeInSession(connection, string);
        if (string2 != null) {
            if (!string2.equalsIgnoreCase("RW")) {
                DMLObject.runDML(connection, "DETACH_AW", string);
                DMLObject.runDML(connection, "ATTACH_AW", string);
                bl3 = true;
            }
        } else {
            DMLObject.runDML(connection, "ATTACH_AW", string);
            bl3 = true;
        }
        Set<String> set = map.keySet();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        ArrayList<Object> arrayList6 = new ArrayList<Object>();
        ArrayList<Object> arrayList7 = new ArrayList<Object>();
        for (String object : set) {
            Object object2 = new DMLObject(connection, string, object, map.get(object));
            Object object3 = ((DMLObject)object2).getDefinition();
            Object object4 = ((String)object3).substring(((String)object3).indexOf(object) + object.length()).trim();
            int n = ((String)object4).indexOf(" ");
            int bl10 = ((String)object4).indexOf("\n");
            int n2 = 0;
            if (n > 0) {
                n2 = bl10 > 0 ? (n < bl10 ? n : bl10) : n;
            } else if (bl10 > 0) {
                n2 = bl10;
            }
            Object object5 = ((String)object4).substring(0, n2).trim();
            String string3 = ((String)object4).substring(n2 + 1);
            if (((String)object5).equalsIgnoreCase("DIMENSION")) {
                if (n2 == n) {
                    int n3 = string3.indexOf("ALIASOF ");
                    if (n3 == 0) {
                        arrayList2.add(object2);
                        continue;
                    }
                    int n4 = string3.indexOf("<");
                    if (n4 == 0) {
                        arrayList4.add(object2);
                        continue;
                    }
                    int n5 = string3.indexOf("CONCAT ");
                    if (n5 == 0) {
                        arrayList3.add(object2);
                        continue;
                    }
                }
                arrayList.add(object2);
                continue;
            }
            if (((String)object5).equalsIgnoreCase("PARTITION")) {
                arrayList5.add(object2);
                continue;
            }
            if (((String)object5).equalsIgnoreCase("COMPOSITE")) {
                arrayList6.add(object2);
                continue;
            }
            arrayList7.add(object2);
        }
        boolean bl4 = false;
        for (Object object2 : arrayList) {
            bl4 = this.createDMLObject(connection, (DMLObject)object2, bl);
            if (!bl4) continue;
            bl2 = bl4;
        }
        boolean bl5 = false;
        for (Object object3 : arrayList2) {
            boolean bl6 = this.createDMLObject(connection, (DMLObject)object3, bl);
            if (!bl6) continue;
            bl2 = bl6;
        }
        boolean bl7 = false;
        for (Object object4 : arrayList3) {
            bl7 = this.createDMLObject(connection, (DMLObject)object4, bl);
            if (!bl7) continue;
            bl2 = bl7;
        }
        boolean bl8 = false;
        for (DMLObject bl9 : arrayList4) {
            bl8 = this.createDMLObject(connection, bl9, bl);
            if (!bl8) continue;
            bl2 = bl8;
        }
        boolean bl9 = false;
        for (DMLObject dMLObject : arrayList6) {
            bl9 = this.createDMLObject(connection, dMLObject, bl);
            if (!bl9) continue;
            bl2 = bl9;
        }
        boolean bl10 = false;
        for (DMLObject dMLObject : arrayList5) {
            boolean bl11 = this.createDMLObject(connection, dMLObject, bl);
            if (!bl11) continue;
            bl2 = bl11;
        }
        boolean bl12 = false;
        for (Object object5 : arrayList7) {
            boolean bl13 = this.createDMLObject(connection, (DMLObject)object5, bl);
            if (!bl13) continue;
            bl2 = bl13;
        }
        if (bl3) {
            DMLObject.runDML(connection, "DETACH_AW", string);
        }
        return bl2;
    }

    private boolean createDMLObject(Connection connection, DMLObject dMLObject, boolean bl) throws SQLException, IOException {
        boolean bl2 = true;
        boolean bl3 = false;
        String string = dMLObject.getWorkspace();
        bl2 = dMLObject.isExists();
        if (!bl2) {
            try {
                dMLObject.create();
                try {
                    if (dMLObject.isCompilable()) {
                        dMLObject.compile();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                DMLObject.runDML(connection, "UPDATE_AW", string);
                connection.commit();
                bl3 = true;
            }
            catch (SQLException sQLException) {
                this.errorDisplay.show(sQLException);
                DMLObject.runDML(connection, "DETACH_AW", string);
                DMLObject.runDML(connection, "ATTACH_AW", string);
            }
        } else if (bl2 && bl) {
            try {
                dMLObject.drop();
                dMLObject.create();
                if (dMLObject.isCompilable()) {
                    dMLObject.compile();
                }
                DMLObject.runDML(connection, "UPDATE_AW", string);
                connection.commit();
                bl3 = true;
            }
            catch (SQLException sQLException) {
                this.errorDisplay.show(sQLException);
                DMLObject.runDML(connection, "DETACH_AW", string);
                DMLObject.runDML(connection, "ATTACH_AW", string);
            }
        }
        return bl3;
    }

    public static String readFile(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            return "";
        }
        long l = file.length();
        char[] cArray = new char[(int)(l += 100L)];
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            fileInputStream = new FileInputStream(string);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            int n = 0;
            int n2 = 0;
            while (n >= 0 && (long)n2 < l) {
                n = inputStreamReader.read(cArray, n2, 1);
                ++n2;
            }
            String string2 = new String(cArray).trim();
            return string2;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

