/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.util.ArrayList;
import java.util.List;
import oracle.olap.cubetemplate.ObjectType;

public class ConflictRenameMap {
    public static final int CONFLICT_TYPE_DIMENSION = 1;
    public static final int CONFLICT_TYPE_CUBE = 2;
    public static final int CONFLICT_TYPE_AW = 3;
    public static final int CONFLICT_TYPE_MEASURE_FOLDER = 4;
    public static final int CONFLICT_TYPE_MEASURE = 5;
    public static final int CONFLICT_TYPE_DERIVED_MEASURE = 6;
    private final List<ConflictRenameMapEntry> m_conflictRename = new ArrayList<ConflictRenameMapEntry>();
    private ConflictRenameMapEntry m_currentMapEntry = null;
    private int m_position = 0;

    public boolean addEntry(int n, String string) {
        return this.addEntry(n, string, null);
    }

    public boolean addEntry(ObjectType objectType, String string, String string2) {
        return this.addEntry(this.getTypeInt(objectType), string, string2);
    }

    public boolean addEntry(int n, String string, String string2) {
        if (this.find(n, string2, string) == null) {
            this.m_conflictRename.add(new ConflictRenameMapEntry(n, string, string2));
            return true;
        }
        return false;
    }

    private int getTypeInt(ObjectType objectType) {
        int n = 3;
        switch (objectType) {
            case WORKSPACE: {
                n = 3;
                break;
            }
            case CUBE: {
                n = 2;
                break;
            }
            case DIMENSION: {
                n = 1;
                break;
            }
            case MEASURE_FOLDER: {
                n = 4;
                break;
            }
            case MEASURE: {
                n = 5;
                break;
            }
            case DERIVED_MEASURE: {
                n = 6;
            }
        }
        return n;
    }

    public boolean addEntry(ObjectType objectType, String string, String string2, String string3) {
        int n = this.getTypeInt(objectType);
        if (this.find(n, string2, string) == null) {
            ConflictRenameMapEntry conflictRenameMapEntry = new ConflictRenameMapEntry(n, string, string2);
            conflictRenameMapEntry.setObjectRename(string3);
            this.m_conflictRename.add(conflictRenameMapEntry);
            return true;
        }
        return false;
    }

    public boolean updateEntryWithRename(int n, String string, String string2, String string3, String string4) {
        ConflictRenameMapEntry conflictRenameMapEntry = this.find(n, string, string2);
        if (conflictRenameMapEntry != null) {
            conflictRenameMapEntry.m_objectRename = string3;
            conflictRenameMapEntry.parentRename = string4;
            return true;
        }
        return false;
    }

    public boolean updateEntryWithRename(int n, String string, String string2) {
        return this.updateEntryWithRename(n, null, string, string2, null);
    }

    public String getRenameEntry(int n, String string) {
        return this.getRenameEntry(n, null, string);
    }

    public String getRenameEntry(int n, String string, String string2) {
        ConflictRenameMapEntry conflictRenameMapEntry = this.find(n, string, string2);
        if (conflictRenameMapEntry != null) {
            return conflictRenameMapEntry.m_objectRename;
        }
        return null;
    }

    private ConflictRenameMapEntry find(int n, String string, String string2) {
        for (ConflictRenameMapEntry conflictRenameMapEntry : this.m_conflictRename) {
            if (conflictRenameMapEntry.m_objectType != n || !conflictRenameMapEntry.m_objectName.equalsIgnoreCase(string2) || conflictRenameMapEntry.parent != string && (conflictRenameMapEntry.parent == null || !conflictRenameMapEntry.parent.equalsIgnoreCase(string))) continue;
            return conflictRenameMapEntry;
        }
        return null;
    }

    public void resetIterator() {
        this.m_position = -1;
        this.m_currentMapEntry = null;
    }

    public String getNextObjectName() {
        ++this.m_position;
        if (this.m_conflictRename.size() > this.m_position) {
            this.m_currentMapEntry = this.m_conflictRename.get(this.m_position);
            return this.m_conflictRename.get((int)this.m_position).m_objectName;
        }
        return null;
    }

    public String getCurrentObjectName() {
        if (this.m_currentMapEntry != null) {
            return this.m_currentMapEntry.m_objectName;
        }
        return null;
    }

    public String getParent() {
        if (this.m_currentMapEntry != null) {
            return this.m_currentMapEntry.parent;
        }
        return null;
    }

    public int getType() {
        if (this.m_currentMapEntry != null) {
            return this.m_currentMapEntry.m_objectType;
        }
        return 0;
    }

    private class ConflictRenameMapEntry {
        protected final int m_objectType;
        protected final String m_objectName;
        protected final String parent;
        protected String m_objectRename;
        protected String parentRename;

        public ConflictRenameMapEntry(int n, String string) {
            this(n, string, null);
        }

        public ConflictRenameMapEntry(int n, String string, String string2) {
            this.m_objectType = n;
            this.m_objectName = string;
            this.parent = string2;
        }

        public void setObjectRename(String string) {
            this.m_objectRename = string;
        }
    }
}

