/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels.aggregation;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.templates.templatedialogimpl.TemplateHelperFactoryImpl;
import oracle.olap.buildspec.BuildSpecInsertionHandlerHelper;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.panels.aggregation.AggregationSyntaxChecker;
import oracle.olap.cube.panels.aggregation.OLAPAggregationSpec;
import oracle.olap.syntaxbuilder.SyntaxBuilderPanel;
import oracle.olap.syntaxbuilder.editor.SyntaxChecker;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.SyntaxBuilderLauncher;
import oracle.olap.syntaxbuilder.olapihelpers.WrappedSyntaxParser;
import oracle.olap.util.OLAPErrorDisplay;
import oracle.olap.util.OLAPFetchIcon;

public class AggregationBuilder {
    private static final Logger LOG = Logger.getLogger(AggregationBuilder.class.getName());
    private Cube cube;
    private SyntaxBuilderPanel builder;
    private Properties props;
    private boolean initialized;
    private TemplateHelperFactoryImpl thf;
    private OLAPISyntaxParser parser;
    private OLAPAggregationSpec specParser;
    private Schema schema;

    public SyntaxBuilderPanel createBuilder() throws SQLException, IOException {
        this.props = new Properties();
        this.props.setProperty("SHOW_LEAVES", Boolean.toString(false));
        this.props.setProperty("VISIBLE_SYNTAXSPEC", Boolean.toString(false));
        this.props.setProperty("VISIBLE_DOCS", Boolean.toString(false));
        this.props.setProperty("CENTER_DIVIDER_POSITION", "70");
        this.props.setProperty("ONECLICK_TEMPLATE_DISPLAY", Boolean.toString(true));
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(this.getClass().getResourceAsStream("aggregationspec.xml"), "UTF-8");
            this.parser = new WrappedSyntaxParser(null, this.props, "SOLVE (%s)");
            OLAPResources oLAPResources = new OLAPResources("/oracle/olap/cube/panels/aggregation/aggregationtemplates.xml");
            OLAPFetchIcon oLAPFetchIcon = new OLAPFetchIcon();
            this.thf = new TemplateHelperFactoryImpl(this.props, null, null, this.parser, oLAPResources, oLAPFetchIcon);
            this.specParser = new OLAPAggregationSpec(this.props, inputStreamReader, this.parser, this.thf, new OLAPErrorDisplay(), oLAPResources, oLAPFetchIcon, null);
            BuildSpecInsertionHandlerHelper buildSpecInsertionHandlerHelper = new BuildSpecInsertionHandlerHelper();
            this.builder = SyntaxBuilderLauncher.createPanelForCube(this.props, null, null, null, null, this.parser, this.thf, this.specParser, null, buildSpecInsertionHandlerHelper);
            SyntaxChecker syntaxChecker = new SyntaxChecker(){

                @Override
                public String isValid(String string) {
                    String string2 = null;
                    String string3 = null;
                    string2 = String.format("SOLVE(%s)", string);
                    AggregationSyntaxChecker aggregationSyntaxChecker = new AggregationSyntaxChecker(AggregationBuilder.this.cube);
                    string3 = aggregationSyntaxChecker.isValid(string2);
                    return string3;
                }
            };
            this.builder.addSyntaxChecker(syntaxChecker);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            OLAPErrorDisplay oLAPErrorDisplay = new OLAPErrorDisplay();
            oLAPErrorDisplay.show(unsupportedEncodingException, OLAPArb.getString("EXPRESSION_EDITOR_SPEC_ERROR_TITLE"), OLAPArb.getString("EXPRESSIONBUILDER_SPEC_ERROR_MESSAGE"), (Component)Ide.getMainWindow());
        }
        return this.builder;
    }

    public SyntaxBuilderPanel initialize(Connection connection, Cube cube, Object object) {
        Object object2;
        if (this.initialized) {
            return this.builder;
        }
        this.cube = cube;
        if (cube != null) {
            if (this.props.containsKey("CUBE") && this.schema != null && (object2 = this.schema.findCube(this.props.getProperty("CUBE"))) != null && !((NamedObject)object2).getName().equals(cube.getName())) {
                this.schema.getCubes().remove(object2);
            }
            this.props.setProperty("CUBE", cube.getName());
            this.props.setProperty("AW", cube.getAnalyticWorkspace());
            this.props.setProperty("SCHEMA", cube.getSchema().getName());
            object2 = new DatabaseImpl();
            object2.setConnection(connection);
            String string = Connections.getInstance().getConnectionName(connection);
            try {
                this.schema = OLAPMetadataCache.getSchemaCopy(string, cube.getSchema().getName());
                this.schema = SyntaxBuilderLauncher.populateCube(this.schema, this.props, cube, object);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Error loading schema for aggregation builder", exception);
            }
            this.specParser.setConn(connection);
            this.parser.setSchema(this.schema);
            this.thf.setSchema(this.schema);
            this.thf.setProperty("CUBE", cube.getName());
            this.thf.setDatabase((Database)object2);
        }
        if (this.specParser.getSpec() == null) {
            try {
                object2 = new InputStreamReader(this.getClass().getResourceAsStream("aggregationspec.xml"), "UTF-8");
                this.specParser.setSpec((Reader)object2);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Error reading the aggregation specs", exception);
            }
        }
        this.builder.initialize();
        object2 = cube.getConsistentSolveSpec();
        if (object2 == null) {
            object2 = " ";
        } else {
            int n = ((String)object2).indexOf("(") + 1;
            int n2 = ((String)object2).lastIndexOf(")");
            object2 = ((String)object2).substring(n, n2);
            object2 = ((String)object2).trim();
        }
        this.builder.setText((String)object2);
        return this.builder;
    }
}

