/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPResources;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionAWObjects;
import oracle.olap.app.olapmetadata.DimensionAWObjectsImpl;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.DimensionHierarchyLevel;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubePartition;
import oracle.olap.cube.panels.PartitionDimensionMetadataLoader;
import oracle.olap.cube.partition.MainPartitionPanel;
import oracle.olap.cube.partition.model.HierarchyLevelWrapper;
import oracle.olap.cube.partition.model.PartitionConstructModelHelper;
import oracle.olap.cube.partition.model.PartitionHierarchyLevelHelper;
import oracle.olap.cube.partition.model.PartitionHierarchyLevelMetadataHelper;
import oracle.olap.cube.partition.model.PartitionQueryCancelExecuteContext;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.db.OracleDatabaseInfo;
import oracle.olap.preferences.OLAPAdvancedPreferenceSettings;
import oracle.olap.statistics.cubedimension.HierarchyLevelDistinctCounts;
import oracle.olap.statistics.cubedimension.LevelDistinctMemberCount;
import oracle.olap.syntax.CubeAggregationDimension;
import oracle.olap.syntax.SolveSyntax;
import oracle.olap.util.OLAPErrorDisplay;
import oracle.olap.util.OLAPFetchIcon;

public class CubePartitionPanel
extends BaseEditorPanel<Cube> {
    private PartitionHierarchyLevelMetadataHelper partitionHierarchyLevelMetadataHelper;
    private PartitionHierarchyLevelHelper partitionHierarchyLevelHelper;
    private PartitionConstructModelHelper partitionConstructModelHelper;
    private DimensionAWObjects dimensionAWObject;
    private List<Dimension> dimensions;
    private MainPartitionPanel mainPartitionPanel;
    private boolean panelInitialized = false;
    private CubePartition[] saveOriginalCubePartitions;
    private boolean updatedOriginalCubePartitions = false;

    public CubePartitionPanel() {
        this.layoutPartitionPanels();
    }

    protected void initialisePanel() {
        Object object = this.getDataContext().get("dimensions");
        Cube cube = (Cube)this.getUpdatedObject();
        PartitionDimensionMetadataLoader partitionDimensionMetadataLoader = new PartitionDimensionMetadataLoader(cube, object);
        this.dimensions = partitionDimensionMetadataLoader.getDimensions();
        if (!this.panelInitialized) {
            SystemObject systemObject;
            Cube cube2;
            CubePartition[] cubePartitionArray;
            this.mainPartitionPanel.setPartitionCheckBox(true);
            Cube cube3 = cube;
            this.mainPartitionPanel.initialisePanels(cube, cube3);
            if (this.isEditing() && (cubePartitionArray = (cube2 = (Cube)(systemObject = this.getEditorConfig().getOriginalObject())).getPartitions()) != null && cubePartitionArray.length > 1) {
                int n = 0;
                this.saveOriginalCubePartitions = new CubePartition[cubePartitionArray.length];
                for (CubePartition cubePartition : cubePartitionArray) {
                    this.saveOriginalCubePartitions[n] = (CubePartition)DBUtil.makeTemporaryCopy((DBObject)cubePartition);
                    ++n;
                }
            }
        } else {
            Object object2;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Dimension object3 : this.dimensions) {
                arrayList.add(object3.getName());
            }
            this.mainPartitionPanel.setPartitionCheckBox(cube.isPartitioned());
            this.mainPartitionPanel.updatePanelsOnReEntry(arrayList);
            if (this.mainPartitionPanel.getCurrentPanelIndex() == 1) {
                this.mainPartitionPanel.attachAnalyticWorkspace();
            }
            if (this.isEditing() && this.updatedOriginalCubePartitions) {
                object2 = this.getEditorConfig().getOriginalObject();
                Cube cube2 = (Cube)object2;
                cube2.setPartitions(this.saveOriginalCubePartitions);
            }
            object2 = PartitionQueryCancelExecuteContext.getInstance();
            ((PartitionQueryCancelExecuteContext)object2).init();
        }
        this.panelInitialized = true;
    }

    protected void commitPanel() throws TraversalException {
        Object object;
        Object object2;
        boolean bl = true;
        if (this.mainPartitionPanel.isPartitioned()) {
            this.mainPartitionPanel.precomputePanelStopEditting();
        }
        if (this.isEditing() && !(bl = this.didCubePartitionsChange((Cube)(object2 = (Cube)(object = this.getEditorConfig().getOriginalObject()))))) {
            bl = this.didCubePartitionsChange((Cube)this.getUpdatedObject());
        }
        if (bl) {
            ((Cube)this.getUpdatedObject()).removeAllPartitions();
        }
        if (bl) {
            object = this.getCurrentSelectedCubePartitions();
            if (object.size() > 0) {
                object2 = new CubePartition[]{};
                ((Cube)this.getUpdatedObject()).setPartitions(object.toArray((T[])object2));
            }
        } else {
            object = ((Cube)this.getUpdatedObject()).getPartitions();
            object2 = this.getCurrentSelectedCubePartitions();
            int n = 0;
            for (Object object3 : object) {
                CubePartition cubePartition = (CubePartition)((Object)object2.get(n));
                int n2 = cubePartition.getPrecomputePercent();
                ((CubePartition)((Object)object3)).setPrecomputePercent(n2);
                ++n;
            }
        }
        if (this.isEditing()) {
            object = this.getEditorConfig().getOriginalObject();
            object2 = (Cube)object;
            this.updatedOriginalCubePartitions = false;
            bl = this.didCubePartitionsChange((Cube)object2);
            if (bl && this.isPartitionOrderingOnlyChanged((Cube)object2)) {
                ((Cube)object2).setPartitions(null);
                this.updatedOriginalCubePartitions = true;
            }
        }
        if (!((PartitionQueryCancelExecuteContext)(object = PartitionQueryCancelExecuteContext.getInstance())).arePartitionQueriesRunning()) {
            this.mainPartitionPanel.detachAnalyticWorkspace();
            ((PartitionQueryCancelExecuteContext)object).resetCancel();
        } else {
            ((PartitionQueryCancelExecuteContext)object).cancel();
        }
        ((PartitionQueryCancelExecuteContext)object).close();
    }

    private List<CubePartition> getCurrentSelectedCubePartitions() {
        List<HierarchyLevelWrapper> list;
        ArrayList<CubePartition> arrayList = new ArrayList<CubePartition>();
        if (this.mainPartitionPanel.isPartitioned() && (list = this.mainPartitionPanel.getPartitionSelections()).size() > 0) {
            for (HierarchyLevelWrapper hierarchyLevelWrapper : list) {
                String string = hierarchyLevelWrapper.getHierarchyName();
                String string2 = hierarchyLevelWrapper.getLevelName();
                int n = this.mainPartitionPanel.getPrecomputeForHierarchyLevel(hierarchyLevelWrapper);
                CubePartition cubePartition = new CubePartition(string + "_" + string2);
                cubePartition.setPartitionDimension(this.mainPartitionPanel.getPartitionDimensionName());
                cubePartition.setPartitionHierarchy(string);
                cubePartition.setPartitionLevel(string2);
                if (((Cube)this.getUpdatedObject()).isCompress()) {
                    cubePartition.setPrecomputePercent(n);
                } else {
                    cubePartition.setPrecomputePercent(0);
                }
                arrayList.add(cubePartition);
            }
        }
        return arrayList;
    }

    private boolean didCubePartitionsChange(Cube cube) {
        List<CubePartition> list;
        boolean bl = false;
        CubePartition[] cubePartitionArray = cube.getPartitions();
        if (cubePartitionArray.length != (list = this.getCurrentSelectedCubePartitions()).size()) {
            bl = true;
        } else {
            int n = 0;
            for (CubePartition cubePartition : cubePartitionArray) {
                String string = cubePartition.getPartitionDimension();
                String string2 = cubePartition.getPartitionHierarchy();
                String string3 = cubePartition.getPartitionLevel();
                String string4 = list.get(n).getPartitionDimension();
                String string5 = list.get(n).getPartitionHierarchy();
                String string6 = list.get(n).getPartitionLevel();
                if (string.equals(string4) && string2.equals(string5) && string3.equals(string6)) {
                    ++n;
                    continue;
                }
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean isPartitionOrderingOnlyChanged(Cube cube) {
        List<CubePartition> list;
        boolean bl = false;
        CubePartition[] cubePartitionArray = cube.getPartitions();
        if (cubePartitionArray.length != (list = this.getCurrentSelectedCubePartitions()).size() || cubePartitionArray.length < 2) {
            bl = true;
        } else {
            for (CubePartition cubePartition : cubePartitionArray) {
                String string = cubePartition.getPartitionDimension();
                String string2 = cubePartition.getPartitionHierarchy();
                String string3 = cubePartition.getPartitionLevel();
                int n = cubePartition.getPrecomputePercent();
                boolean bl2 = false;
                for (CubePartition cubePartition2 : list) {
                    String string4 = cubePartition2.getPartitionDimension();
                    String string5 = cubePartition2.getPartitionHierarchy();
                    String string6 = cubePartition2.getPartitionLevel();
                    int n2 = cubePartition2.getPrecomputePercent();
                    if (!string.equals(string4) || !string2.equals(string5) || !string3.equals(string6) || n != n2) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = true;
                break;
            }
        }
        return !bl;
    }

    public PartitionHierarchyLevelMetadataHelper getPartitionHierarchyLevelMetadataHelper() {
        if (this.partitionHierarchyLevelMetadataHelper == null) {
            Object object = this.getDataContext().get("dimensions");
            this.partitionHierarchyLevelMetadataHelper = new PartitionDimensionMetadataLoader((Cube)this.getUpdatedObject(), object);
        }
        return this.partitionHierarchyLevelMetadataHelper;
    }

    public PartitionHierarchyLevelHelper getPartitionHierarchyLevelHelper() {
        if (this.partitionHierarchyLevelHelper == null) {
            Object object = this.getDataContext().get("dimensions");
            this.partitionHierarchyLevelHelper = new PartitionDimensionMetadataLoader((Cube)this.getUpdatedObject(), object);
        }
        return this.partitionHierarchyLevelHelper;
    }

    public PartitionConstructModelHelper getPartitionConstructModelHelper() {
        if (this.partitionConstructModelHelper == null) {
            Object object = this.getDataContext().get("dimensions");
            this.partitionConstructModelHelper = new PartitionDimensionMetadataLoader((Cube)this.getUpdatedObject(), object);
        }
        return this.partitionConstructModelHelper;
    }

    public JFrame getFrame() {
        return Ide.getMainWindow();
    }

    public DimensionAWObjects getDimensionAWObjects() {
        if (this.dimensionAWObject == null) {
            Cube cube = (Cube)this.getUpdatedObject();
            String string = cube.getSchema().getName();
            String string2 = cube.getAnalyticWorkspace();
            Connection connection = this.getConnection();
            this.dimensionAWObject = new DimensionAWObjectsImpl(string, string2, connection, new OLAPResources());
        }
        return this.dimensionAWObject;
    }

    public String getOwner() {
        return ((Cube)this.getUpdatedObject()).getSchema().getName();
    }

    public String getAWName() {
        Cube cube = (Cube)this.getUpdatedObject();
        return cube.getAnalyticWorkspace();
    }

    public Connection getConnection() {
        DBObjectProvider dBObjectProvider = this.getProvider();
        Connection connection = null;
        if (dBObjectProvider instanceof OracleDatabaseImpl) {
            OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBObjectProvider;
            connection = oracleDatabaseImpl.getConnection();
        }
        return connection;
    }

    public boolean isCreate() {
        boolean bl = !this.isEditing();
        return bl;
    }

    public void fieldValueChanged() {
    }

    public void cleanup() {
    }

    public String getPrimaryPartitionDimensionName() {
        String string = null;
        Cube cube = (Cube)this.getUpdatedObject();
        CubePartition[] cubePartitionArray = cube.getPartitions();
        if (cubePartitionArray != null && cubePartitionArray.length >= 1) {
            CubePartition cubePartition = cube.getPartitions()[0];
            string = cubePartition.getPartitionDimension();
        }
        return string;
    }

    public String getPrimaryPartitionHierarchyName() {
        String string = null;
        Cube cube = (Cube)this.getUpdatedObject();
        CubePartition[] cubePartitionArray = cube.getPartitions();
        if (cubePartitionArray != null && cubePartitionArray.length >= 1) {
            CubePartition cubePartition = cube.getPartitions()[0];
            string = cubePartition.getPartitionHierarchy();
        }
        return string;
    }

    public String getPrimaryPartitionLevelName() {
        String string = null;
        Cube cube = (Cube)this.getUpdatedObject();
        CubePartition[] cubePartitionArray = cube.getPartitions();
        if (cubePartitionArray != null && cubePartitionArray.length >= 1) {
            CubePartition cubePartition = cube.getPartitions()[0];
            string = cubePartition.getPartitionLevel();
        }
        return string;
    }

    public int getPrimaryPrecomputePercent() {
        int n = 40;
        Cube cube = (Cube)this.getUpdatedObject();
        CubePartition[] cubePartitionArray = cube.getPartitions();
        if (cubePartitionArray != null && cubePartitionArray.length >= 1) {
            CubePartition cubePartition = cube.getPartitions()[0];
            n = cubePartition.getPrecomputePercent();
        }
        return n;
    }

    public String getHierarchyViewName(String string, String string2) {
        NamedObjectWithDesc namedObjectWithDesc2;
        Dimension dimension = null;
        for (NamedObjectWithDesc namedObjectWithDesc2 : this.dimensions) {
            if (!namedObjectWithDesc2.getName().equalsIgnoreCase(string)) continue;
            dimension = namedObjectWithDesc2;
            break;
        }
        List<DimensionHierarchy> list = dimension.getHierarchies();
        namedObjectWithDesc2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DimensionHierarchy dimensionHierarchy = (DimensionHierarchy)iterator.next();
            if (!dimensionHierarchy.getName().equalsIgnoreCase(string2)) continue;
            namedObjectWithDesc2 = dimensionHierarchy;
            break;
        }
        return ((DimensionHierarchy)namedObjectWithDesc2).getViewName();
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getHierarchyLevelNames(String string, String string2) {
        void var5_8;
        Object object;
        Dimension dimension = null;
        for (Dimension object22 : this.dimensions) {
            if (!object22.getName().equalsIgnoreCase(string)) continue;
            dimension = object22;
            break;
        }
        List<DimensionHierarchy> list = dimension.getHierarchies();
        Object var5_6 = null;
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (DimensionHierarchy)object2.next();
            if (!((NamedObject)object).getName().equalsIgnoreCase(string2)) continue;
            Object object3 = object;
            break;
        }
        object2 = var5_8.getHierarchyLevels();
        object = new ArrayList();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            DimensionHierarchyLevel dimensionHierarchyLevel = (DimensionHierarchyLevel)iterator.next();
            String string3 = dimensionHierarchyLevel.getLevelName();
            object.add(this.getLevelNameFromHierarchyLevelName(string3));
        }
        return object;
    }

    public String getLevelNameFromHierarchyLevelName(String string) {
        String string2 = null;
        int n = string.indexOf(".");
        string2 = n > 0 ? string.substring(n + 1) : string;
        return string2;
    }

    public List<HierarchyLevelWrapper> getSelectedPartitions() {
        Cube cube = (Cube)this.getUpdatedObject();
        ArrayList<HierarchyLevelWrapper> arrayList = new ArrayList<HierarchyLevelWrapper>();
        String string = this.getPrimaryPartitionDimensionName();
        Object object = this.getDataContext().get("dimensions");
        CubeDimension cubeDimension = cube.findDimension(object, string);
        if (cubeDimension != null) {
            CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel = null;
            for (CubePartition cubePartition : cube.getPartitions()) {
                CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray;
                String string2 = cubePartition.getPartitionHierarchy();
                String string3 = cubePartition.getPartitionLevel();
                CubeDimensionHierarchy cubeDimensionHierarchy = cubeDimension.findHierarchy(string2);
                for (CubeDimensionHierarchyLevel cubeDimensionHierarchyLevel2 : cubeDimensionHierarchyLevelArray = cubeDimensionHierarchy.getHierarchyLevels()) {
                    String string4 = cubeDimensionHierarchyLevel2.getLevelName();
                    if (!string4.equalsIgnoreCase(string3)) continue;
                    cubeDimensionHierarchyLevel = cubeDimensionHierarchyLevel2;
                    break;
                }
                HierarchyLevelWrapper object2 = new HierarchyLevelWrapper(cubeDimensionHierarchyLevel);
                arrayList.add(object2);
            }
        }
        return arrayList;
    }

    public List<CubeDimensionHierarchy> getAggregatedHierarchiesForDimension(String string) {
        List<Object> list = new ArrayList();
        Cube cube = (Cube)this.getUpdatedObject();
        DBObjectProvider dBObjectProvider = this.getProvider();
        String string2 = cube.getConsistentSolveSpec();
        List<CubeDimensionHierarchy> list2 = new ArrayList<CubeDimensionHierarchy>();
        if (string2 != null) {
            Object object = this.getDataContext().get("dimensions");
            list = SolveSyntax.getInstance().fromSyntax(cube, cube.getDimensionMap(object), dBObjectProvider, string2);
            for (CubeAggregationDimension cubeAggregationDimension : list) {
                if (!cubeAggregationDimension.getName().equalsIgnoreCase(string)) continue;
                list2 = cubeAggregationDimension.getAggregationHierarchies();
                break;
            }
        }
        return list2;
    }

    public boolean isDimensionHierarchyAggregated(String string, String string2) {
        boolean bl = false;
        List<CubeDimensionHierarchy> list = this.getAggregatedHierarchiesForDimension(string);
        for (CubeDimensionHierarchy cubeDimensionHierarchy : list) {
            if (!cubeDimensionHierarchy.getName().equalsIgnoreCase(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public List<String> getAggregatedHierarchies(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<CubeDimensionHierarchy> list = this.getAggregatedHierarchiesForDimension(string);
        for (CubeDimensionHierarchy cubeDimensionHierarchy : list) {
            arrayList.add(cubeDimensionHierarchy.getName());
        }
        return arrayList;
    }

    public List<String> filterDimensionList(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            List<CubeDimensionHierarchy> list2 = this.getAggregatedHierarchiesForDimension(string);
            if (list2.size() <= 0) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getDimensionNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Dimension dimension : this.dimensions) {
            arrayList.add(dimension.getName());
        }
        return arrayList;
    }

    public List<String> getHierarchyNames(String string) {
        return this.getAggregatedHierarchies(string);
    }

    public int getNumberOfHierarchyLevels(String string, String string2) {
        Dimension dimension = null;
        DimensionHierarchy namedObjectWithDesc = null;
        for (Dimension namedObjectWithDesc2 : this.dimensions) {
            if (!namedObjectWithDesc2.getName().equalsIgnoreCase(string)) continue;
            dimension = namedObjectWithDesc2;
            break;
        }
        for (DimensionHierarchy dimensionHierarchy : dimension.getHierarchies()) {
            if (!dimensionHierarchy.getName().equalsIgnoreCase(string2)) continue;
            namedObjectWithDesc = dimensionHierarchy;
            break;
        }
        List<DimensionHierarchyLevel> list = namedObjectWithDesc.getHierarchyLevels();
        return list.size();
    }

    public String getDefaultPartitionDimension() {
        return this.partitionHierarchyLevelHelper.getDefaultPartitionDimension();
    }

    public List<HierarchyLevelWrapper> getDefaultPartitions(String string) {
        return this.partitionHierarchyLevelHelper.getDefaultPartitions(string);
    }

    public HierarchyLevelDistinctCounts getHierarchyLevelDistinctCounts() {
        return new LevelDistinctMemberCount(this.getConnection());
    }

    public boolean isCompressed() {
        Cube cube = (Cube)this.getUpdatedObject();
        return cube.isCompress();
    }

    public boolean showAutoManagePartitioning() {
        Preferences preferences = Preferences.getPreferences();
        OLAPAdvancedPreferenceSettings oLAPAdvancedPreferenceSettings = OLAPAdvancedPreferenceSettings.getInstance((PropertyStorage)preferences);
        Boolean bl = oLAPAdvancedPreferenceSettings.getShowAutoPartitionOrderCheckboxSetting();
        return bl;
    }

    public boolean allowPrecomputePercentEdit() {
        Preferences preferences = Preferences.getPreferences();
        OLAPAdvancedPreferenceSettings oLAPAdvancedPreferenceSettings = OLAPAdvancedPreferenceSettings.getInstance((PropertyStorage)preferences);
        Boolean bl = oLAPAdvancedPreferenceSettings.getEnableCubePrecomputeEditsSetting();
        return bl == false;
    }

    public int determineMaxNumberOfPartitions() {
        int n = 1;
        Connection connection = this.getConnection();
        if (OracleDatabaseInfo.isDatabaseCompatible11_2_OrGreater(connection)) {
            n = 256;
        }
        return n;
    }

    public void layoutPartitionPanels() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.mainPartitionPanel = new MainPartitionPanel(this, new OLAPResources(), new OLAPFetchIcon(), new OLAPErrorDisplay());
        this.add(this.mainPartitionPanel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        this.add(new JPanel(), gridBagConstraints);
    }
}

