/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.olap.OLAPArb;
import oracle.olap.app.ui.DataTypeUI;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.db.view.ChildObjectEditorPanel2;

public class CubeMeasureTableEditorPanel<T extends CubeMeasure, P extends Cube>
extends ChildObjectEditorPanel2<T, P> {
    private DBObjectProvider prov;
    private DataTypeUI dataTypeUI;
    private TreeSet<CubeMeasure> invalidMeasures = new TreeSet(new DBObjectComparator());
    private JCheckBox allowAutoDataTypeChangeCheckbox;
    private boolean isCubeCompressed = false;

    public CubeMeasureTableEditorPanel() {
        super("CubeMeasureTableEditorPanel", "MEASURE");
        this.layoutComponents();
    }

    private void updateMeasureData(CubeMeasure cubeMeasure) {
        boolean bl = cubeMeasure.isMeasureAllowAutoDataTypeChange();
        this.allowAutoDataTypeChangeCheckbox.setSelected(bl);
        String string = cubeMeasure.getDataType();
        this.dataTypeUI.setSQLDataType(string);
        this.dataTypeUI.setEnabled(true);
        if (this.isCubeCompressed || bl) {
            this.dataTypeUI.setEnabled(false);
        }
        this.validate();
        this.repaint();
    }

    private void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
    }

    @Override
    protected void initialisePanel() {
        CubeMeasure cubeMeasure = (CubeMeasure)this.getChildObject();
        Cube cube = cubeMeasure.getCube();
        this.isCubeCompressed = cube.isCompress();
        this.initImpl(this.getProvider());
        super.initialisePanel();
        this.setMeasure(cubeMeasure);
    }

    public void commit(CubeMeasure cubeMeasure) throws TraversalException {
        String string = cubeMeasure.getName();
        try {
            this.prov.validateName("MEASURE", string);
        }
        catch (InvalidNameException invalidNameException) {
            this.invalidMeasures.add(cubeMeasure);
            throw new TraversalException(invalidNameException.getMessage());
        }
        if (this.invalidMeasures.contains(cubeMeasure)) {
            this.invalidMeasures.remove(cubeMeasure);
        }
        String string2 = this.prov.getInternalName(string);
        cubeMeasure.setName(string2);
        boolean bl = this.allowAutoDataTypeChangeCheckbox.isSelected();
        cubeMeasure.setMeasureAllowAutoDataTypeChange(bl);
        String string3 = this.dataTypeUI.getSQLDataType();
        cubeMeasure.setDataType(string3);
    }

    public void setMeasure(CubeMeasure cubeMeasure) {
        this.updateMeasureData(cubeMeasure);
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        CubeMeasure cubeMeasure = (CubeMeasure)this.getChildObject();
        String string = cubeMeasure.getName();
        this.commit(cubeMeasure);
        Cube cube = cubeMeasure.getCube();
        if (cube.findMeasure(cubeMeasure.getName()) == null) {
            cube.addMeasure(cubeMeasure);
        } else if (!cubeMeasure.getName().equals(string)) {
            cubeMeasure.getCube().propagateRenameToExpressions(string, cubeMeasure.getName(), true);
        }
    }

    private void layoutComponents() {
        this.setName(this.getClass().getName());
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.setBasePath(new String[]{"measures"});
        this.dataTypeUI = new DataTypeUI(componentFactory);
        this.dataTypeUI.removeDataTypel("DATETIME");
        this.dataTypeUI.getDataTypeComboBox().setSelectedItem("VARCHAR2");
        this.allowAutoDataTypeChangeCheckbox = new JCheckBox(OLAPArb.getString("CUBE_MEASURE_ALLOWAUTODATATYPECHANGE"));
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(OLAPArb.getString("CUBE_MEASURE_PROPERTIES")));
        int n = 0;
        this.add(this.allowAutoDataTypeChangeCheckbox, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.dataTypeUI.getDataTypeLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.dataTypeUI.getDataTypeComboBox(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.dataTypeUI.getDataTypeSizeLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.dataTypeUI.getDataTypeSizeTextField(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.dataTypeUI.getDataTypeScaleLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.dataTypeUI.getDataTypeScaleTextField(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(1, ++n, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.allowAutoDataTypeChangeCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CubeMeasureTableEditorPanel.this.dataTypeUI.setEnabled(!CubeMeasureTableEditorPanel.this.allowAutoDataTypeChangeCheckbox.isSelected() && !CubeMeasureTableEditorPanel.this.isCubeCompressed);
            }
        });
    }

    protected void validateObject() throws TraversalException {
    }
}

