/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.Ide;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.cube.panels.CubeAggregationPanel;
import oracle.olap.cube.panels.aggregation.AggregationSyntaxChecker;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.syntax.AggregationOperatorMap;
import oracle.olap.syntax.CubeAggregationDimension;
import oracle.olap.syntax.SolveSyntax;

public class CubeMeasureAggregationPanel
extends CubeAggregationPanel {
    private static final Logger LOG = Logger.getLogger(CubeMeasureAggregationPanel.class.getName());
    private JComboBox measureComboBox;
    private DefaultComboBoxModel measureComboBoxModel;
    private JCheckBox useCubeAggChkBox;
    private CubeMeasure[] measures;
    private Map<String, String> mapMeasureCSS;
    private boolean isPanelEnabled;
    private String currentMeasureName;
    private ItemListener measureComboBoxItemListener;
    private OracleDatabaseImpl oraDb;

    @Override
    protected int getBuilderSetting() {
        return 2;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        Cube cube = (Cube)this.getUpdatedObject();
        String string = cube.getConsistentSolveSpec();
        this.oraDb = (OracleDatabaseImpl)this.getProvider();
        this.cubeAggregationDimensions = new ArrayList();
        this.mapMeasureCSS = new HashMap<String, String>();
        this.measureComboBox.removeItemListener(this.measureComboBoxItemListener);
        this.useCubeAggChkBox.setSelected(true);
        this.measureComboBoxModel.removeAllElements();
        this.measures = cube.getMeasures();
        if (this.measures.length > 0) {
            for (CubeMeasure cubeMeasure : this.measures) {
                this.mapMeasureCSS.put(cubeMeasure.getName(), cubeMeasure.getConsistentSolveSpec());
                this.measureComboBoxModel.addElement(cubeMeasure.getName());
            }
            this.measureComboBox.setSelectedIndex(0);
            CubeMeasure cubeMeasure = this.measures[0];
            String string2 = cubeMeasure.getConsistentSolveSpec();
            if (string2 != null && string2.length() > 0) {
                string = string2;
                this.useCubeAggChkBox.setSelected(false);
            }
            string = this.extractConsistentSolveExpression(string);
            this.syntaxBuilder.setText(string);
            this.currentMeasureName = cubeMeasure.getName();
            this.syntaxBuilder.setEnabled(!this.useCubeAggChkBox.isSelected());
        }
        this.setEnablePanel(!cube.isCompress() && this.measures.length > 0);
        this.measureComboBox.addItemListener(this.measureComboBoxItemListener);
    }

    private void initAggPanels(String string) {
        Object object;
        Cube cube = (Cube)this.getUpdatedObject();
        DBObjectProvider dBObjectProvider = this.getProvider();
        AggregationOperatorMap aggregationOperatorMap = this.aggregationOperatorPanel.getAggregationOperatorMap();
        int n = 0;
        CubeDimensionality[] cubeDimensionalityArray = cube.getDimensions();
        if (string != null) {
            object = this.getDataContext().get("dimensions");
            this.cubeAggregationDimensions = SolveSyntax.getInstance().fromSyntax(cube, cube.getDimensionMap(object), dBObjectProvider, string);
        } else if (this.isEditing()) {
            object = this.getDataContext().get("dimensions");
            for (CubeDimension cubeDimension : cube.getDimensions(object)) {
                String string2 = cubeDimension.getName();
                CubeAggregationDimension cubeAggregationDimension = new CubeAggregationDimension(cube, string2);
                cubeAggregationDimension.setAggregationOrder(++n);
                String string3 = (String)aggregationOperatorMap.get("NOAGG");
                cubeAggregationDimension.setAggregationOperator(string3);
                this.cubeAggregationDimensions.add(cubeAggregationDimension);
            }
        }
        object = this.getDataContext().get("dimensions");
        this.aggregationOperatorPanel.initialisePanel(this.oraDb, cube, object, this.cubeAggregationDimensions);
        Object object2 = this.getDataContext().get("dimensions");
        this.aggregationHierarchyPanel.initialisePanel(cube, object2, (List<CubeAggregationDimension>)this.cubeAggregationDimensions);
    }

    @Override
    protected void commitPanel() throws TraversalException {
        if (this.isPanelEnabled) {
            this.saveMeasureCSS(this.currentMeasureName);
            for (CubeMeasure cubeMeasure : this.measures) {
                String string = cubeMeasure.getName();
                String string2 = this.mapMeasureCSS.get(string);
                cubeMeasure.setConsistentSolveSpec(string2);
            }
        }
    }

    private void validateConsistentSolveSpec(String string) throws TraversalException {
        Cube cube = (Cube)this.getUpdatedObject();
        AggregationSyntaxChecker aggregationSyntaxChecker = new AggregationSyntaxChecker(cube);
        String string2 = null;
        string2 = aggregationSyntaxChecker.isValid(string);
        if (string2 != null) {
            throw new TraversalException(string2);
        }
    }

    @Override
    protected void layoutComponents(int n) {
        JLabel jLabel = new JLabel(OLAPArb.get("AGGREGATION.RULES.DESC"));
        jLabel.setName("aggOperatorLabel");
        JLabel jLabel2 = new JLabel(OLAPArb.get("MEASURE_AGGREGATION_RULES_HIER_DESC"));
        jLabel2.setName("aggHierarchyLabel");
        JLabel jLabel3 = new JLabel(OLAPArb.get("MEASURE_AGGREGATION_RULES_MEASURE_LABEL"));
        jLabel3.setName("measureLabel");
        this.measureComboBoxModel = new DefaultComboBoxModel();
        this.measureComboBox = new JComboBox(this.measureComboBoxModel);
        this.measureComboBox.setName("measureComboBox");
        this.measureComboBoxItemListener = new ItemListener(){
            private boolean resetItem = false;

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!this.resetItem) {
                    String string;
                    Cube cube = (Cube)CubeMeasureAggregationPanel.this.getUpdatedObject();
                    String string2 = (String)CubeMeasureAggregationPanel.this.measureComboBox.getSelectedItem();
                    if (CubeMeasureAggregationPanel.this.currentMeasureName != null && string2 != null && !string2.equalsIgnoreCase(CubeMeasureAggregationPanel.this.currentMeasureName)) {
                        try {
                            CubeMeasureAggregationPanel.this.saveMeasureCSS(CubeMeasureAggregationPanel.this.currentMeasureName);
                        }
                        catch (Exception exception) {
                            String string3 = exception.getLocalizedMessage();
                            String string4 = OLAPArb.get("MEASURE_AGGREGATION_RULES_ERROR_TITLE");
                            if (string3 == null || string3.length() == 0) {
                                string3 = exception.getClass().toString();
                            }
                            LOG.log(Level.SEVERE, exception.getMessage(), exception);
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)string4, null);
                            this.resetItem = true;
                            string2 = CubeMeasureAggregationPanel.this.currentMeasureName;
                            CubeMeasureAggregationPanel.this.measureComboBox.getModel().setSelectedItem(string2);
                            return;
                        }
                    }
                    if ((string = (String)CubeMeasureAggregationPanel.this.mapMeasureCSS.get(string2)) != null && string.length() > 0) {
                        CubeMeasureAggregationPanel.this.useCubeAggChkBox.setSelected(false);
                    } else {
                        string = cube.getConsistentSolveSpec();
                        CubeMeasureAggregationPanel.this.useCubeAggChkBox.setSelected(true);
                    }
                    string = CubeMeasureAggregationPanel.this.extractConsistentSolveExpression(string);
                    CubeMeasureAggregationPanel.this.syntaxBuilder.setText(string);
                    CubeMeasureAggregationPanel.this.syntaxBuilder.setEnabled(!CubeMeasureAggregationPanel.this.useCubeAggChkBox.isSelected());
                    CubeMeasureAggregationPanel.this.currentMeasureName = string2;
                }
                this.resetItem = false;
            }
        };
        this.measureComboBox.addItemListener(this.measureComboBoxItemListener);
        this.useCubeAggChkBox = new JCheckBox(OLAPArb.get("MEASURE_AGGREGATION_RULES_USE_CUBE_AGG"), true);
        this.useCubeAggChkBox.setName("useCubeAggChkBox");
        this.useCubeAggChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = CubeMeasureAggregationPanel.this.useCubeAggChkBox.isSelected();
                if (bl) {
                    Cube cube = (Cube)CubeMeasureAggregationPanel.this.getUpdatedObject();
                    String string = cube.getConsistentSolveSpec();
                    string = CubeMeasureAggregationPanel.this.extractConsistentSolveExpression(string);
                    CubeMeasureAggregationPanel.this.syntaxBuilder.setText(string);
                    String string2 = (String)CubeMeasureAggregationPanel.this.measureComboBox.getSelectedItem();
                    try {
                        CubeMeasureAggregationPanel.this.saveMeasureCSS(string2);
                    }
                    catch (Exception exception) {
                        String string3 = exception.getLocalizedMessage();
                        String string4 = OLAPArb.get("MEASURE_AGGREGATION_RULES_ERROR_TITLE");
                        if (string3 == null || string3.length() == 0) {
                            string3 = exception.getClass().toString();
                        }
                        LOG.log(Level.SEVERE, exception.getMessage(), exception);
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)string4, null);
                    }
                }
                CubeMeasureAggregationPanel.this.syntaxBuilder.setEnabled(!bl);
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)this.measureComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)this.useCubeAggChkBox, new GridBagConstraints(0, 1, 2, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(jPanel, new GridBagConstraints(0, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        super.layoutComponents(++n);
    }

    private void saveMeasureCSS(String string) throws TraversalException {
        Cube cube = (Cube)this.getOriginalObject();
        if (string != null) {
            String string2;
            CubeMeasure cubeMeasure;
            if (!this.useCubeAggChkBox.isSelected()) {
                CubeMeasure cubeMeasure2;
                String string3 = null;
                String string4 = null;
                if (cube != null && (cubeMeasure2 = cube.findMeasure(string)) != null) {
                    string3 = cubeMeasure2.getConsistentSolveSpec();
                }
                string4 = this.getConsistentSolveSpec(string3);
                this.validateConsistentSolveSpec(string4);
                this.mapMeasureCSS.put(string, string4);
            } else if (cube != null && (cubeMeasure = cube.findMeasure(string)) != null && (string2 = cubeMeasure.getConsistentSolveSpec()) != null) {
                this.mapMeasureCSS.put(string, "");
            }
        }
    }

    private void setEnablePanel(boolean bl) {
        this.isPanelEnabled = bl;
        this.measureComboBox.setEnabled(bl);
        this.useCubeAggChkBox.setEnabled(bl);
    }

    private String extractConsistentSolveExpression(String string) {
        String string2 = null;
        int n = string.indexOf("(") + 1;
        int n2 = string.lastIndexOf(")");
        string2 = string.substring(n, n2);
        string2 = string2.trim();
        return string2;
    }
}

