/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.calcs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.OLAPArb;
import oracle.olap.actions.AbstractDropMeasureAction;
import oracle.olap.actions.OLAPActionDDLPanel;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.CalcReferences;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.calcs.ReferencesTableModel;
import oracle.olap.db.CubeCalcPersist;
import oracle.olap.db.OLAPExceptionHandler;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.SyntaxBuilderLauncher;

public class DropMeasureDialog
extends JDialog {
    private AnalyticWorkspace aw;
    private GenericTable referencesTable;
    private GenericTable dependenciesTable;
    private ReferencesTableModel dependenciesTableModel;
    private ReferencesTableModel referencesTableModel;
    private JButton okButton;
    private JButton cancelButton;
    private String measureName;
    private String cubeName;
    private Connection conn;
    private OLAPISyntaxParser parser;
    private List<Measure> dependencies;
    private String windowTitle;
    private CubeCalcPersist calcCreator;
    private AbstractDropMeasureAction dropMeasureAction;
    private int baseMeasures = 0;
    private int calcMeasures = 0;
    private boolean dropDependencies = true;
    private OLAPActionDDLPanel sqlPanel;
    private JTabbedPane tabs;
    private static final int PROMPTS_TAB = 0;
    private static final int SQL_TAB = 1;
    public static final int YES_SELECTION = 1;
    public static final int NO_SELECTION = 0;
    private int selection;
    private boolean readOnly;

    public DropMeasureDialog() {
    }

    public DropMeasureDialog(Frame frame, String string, String string2, String string3, String string4, AbstractDropMeasureAction abstractDropMeasureAction, boolean bl, List<Measure> list) {
        this(frame, string, null, string2, string3, string4, null, null, abstractDropMeasureAction, bl, list);
    }

    public DropMeasureDialog(Frame frame, String string, AnalyticWorkspace analyticWorkspace, String string2, String string3, String string4, Connection connection, CubeCalcPersist cubeCalcPersist, AbstractDropMeasureAction abstractDropMeasureAction, boolean bl, List<Measure> list) {
        super(frame, string);
        Object object;
        this.aw = analyticWorkspace;
        this.measureName = string2;
        this.cubeName = string3;
        this.conn = connection;
        this.windowTitle = string;
        this.calcCreator = cubeCalcPersist;
        this.dropMeasureAction = abstractDropMeasureAction;
        this.readOnly = bl;
        this.dependencies = list;
        if (!bl) {
            object = new DatabaseImpl();
            object.setConnection(connection);
            Properties properties = new Properties();
            properties.setProperty("SCHEMA", string4);
            Schema schema = SyntaxBuilderLauncher.populateSchema(null, properties, null, (Database)object);
            this.parser = new OLAPISyntaxParser(schema, properties);
        }
        this.initComponents();
        this.layoutComponents();
        this.setDefaultCloseOperation(2);
        object = new Dimension(890, 410);
        this.setDialogLocation((Dimension)object);
        this.setMinimumSize((Dimension)object);
    }

    private void setDialogLocation(Dimension dimension) {
        Point point = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Point point2 = new Point();
        point2.setLocation(point.getX() - dimension.getWidth() / 2.0, point.getY() - dimension.getHeight() / 2.0);
        this.setLocation(point2);
    }

    private void setDropDependencies(boolean bl) {
        this.dropDependencies = bl;
    }

    private void initComponents() {
        this.dependenciesTableModel = new ReferencesTableModel();
        this.dependenciesTable = new GenericTable((TableModel)this.dependenciesTableModel);
        this.setupTableColumns(this.dependenciesTable);
        this.okButton = new JButton(OLAPArb.getString("DROP_CASCADE_YES_CHOICE"));
        this.cancelButton = new JButton(OLAPArb.getString("DROP_CASCADE_NO_CHOICE"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!DropMeasureDialog.this.readOnly) {
                    DropMeasureDialog.this.calcCreator.clear();
                    DropMeasureDialog.this.calcCreator.addRemoveMeasure(DropMeasureDialog.this.measureName, DropMeasureDialog.this.cubeName);
                    if (DropMeasureDialog.this.dropDependencies && !DropMeasureDialog.this.dependencies.isEmpty()) {
                        int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), OLAPArb.format("DROP_MEASURE_DEPENDENCIES_WARNING", DropMeasureDialog.this.measureName), DropMeasureDialog.this.windowTitle, 0, 2);
                        if (n != 0) {
                            return;
                        }
                        for (Measure measure : DropMeasureDialog.this.dependencies) {
                            DropMeasureDialog.this.calcCreator.addRemoveMeasure(measure.getName(), measure.getCube().getName());
                        }
                    }
                    DropMeasureDialog.this.commit();
                } else {
                    int n;
                    if (!DropMeasureDialog.this.dependencies.isEmpty() && DropMeasureDialog.this.dropDependencies && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), OLAPArb.format("DROP_MEASURE_DEPENDENCIES_WARNING", DropMeasureDialog.this.measureName), DropMeasureDialog.this.windowTitle, 0, 2)) != 0) {
                        return;
                    }
                    DropMeasureDialog.this.selection = 1;
                }
                DropMeasureDialog.this.close();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DropMeasureDialog.this.selection = 0;
                DropMeasureDialog.this.close();
            }
        });
        if (!this.readOnly) {
            Measure measure;
            this.referencesTableModel = new ReferencesTableModel();
            this.referencesTable = new GenericTable((TableModel)this.referencesTableModel);
            this.setupTableColumns(this.referencesTable);
            Cube cube = this.aw.getCube(this.cubeName);
            if (cube != null && (measure = cube.findMeasure(this.measureName)) != null) {
                this.addReferences(measure);
            }
        }
        this.addDependencies();
        this.sqlPanel = new OLAPActionDDLPanel();
    }

    private void setupTableColumns(GenericTable genericTable) {
        genericTable.setAutoResizeMode(0);
        genericTable.setColumnSelectorAvailable(false);
        TableColumn tableColumn = genericTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(100);
        tableColumn = genericTable.getColumnModel().getColumn(5);
        tableColumn.setPreferredWidth(385);
    }

    private void commit() {
        this.countMeasuresToDrop();
        String string = OLAPArb.format("DROP_MEASURE_DIALOG_DROPPING_MEASURES_PROGRESS", this.baseMeasures, this.calcMeasures);
        RaptorTask raptorTask = new RaptorTask(string, true, IRaptorTaskRunMode.MODAL){

            protected Object doWork() throws TaskException {
                Boolean bl = Boolean.TRUE;
                try {
                    DropMeasureDialog.this.okButton.setEnabled(false);
                    DropMeasureDialog.this.calcCreator.commit();
                }
                catch (Exception exception) {
                    bl = Boolean.FALSE;
                    throw new TaskException((Throwable)exception);
                }
                return bl;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(string);
        ObjectAction objectAction = this.dropMeasureAction.getObjectAction();
        DBObject dBObject = this.dropMeasureAction.getDBObject();
        if (null == objectAction) {
            objectAction = new ObjectAction();
            objectAction.setReloadParent(true);
        }
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
        IRaptorTaskListener iRaptorTaskListener = ObjectActionController.getRaptorTaskListener((ObjectActionController.ObjectActionPostProcess)objectActionPostProcess);
        raptorTask.getDescriptor().addListener(iRaptorTaskListener);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Throwable throwable = raptorTaskEvent.getThrowable();
                        if (throwable.getCause() != null) {
                            OLAPExceptionHandler.handleException(DropMeasureDialog.this.getOwner(), (Exception)throwable.getCause());
                        } else {
                            OLAPExceptionHandler.handleException(DropMeasureDialog.this.getOwner(), throwable.getMessage());
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!DropMeasureDialog.this.dropDependencies) {
                            DropMeasureDialog.this.showConfirmation();
                        } else if (!DropMeasureDialog.this.dependencies.isEmpty()) {
                            DropMeasureDialog.this.showConfirmationWithDependencies();
                        } else {
                            DropMeasureDialog.this.showConfirmation();
                        }
                        DropMeasureDialog.this.close();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
        raptorTaskManager.addTask(raptorTask);
    }

    private void countMeasuresToDrop() {
        if (this.dropDependencies) {
            for (Measure measure : this.dependencies) {
                if (measure.getType().equals("BASE")) {
                    ++this.baseMeasures;
                    continue;
                }
                ++this.calcMeasures;
            }
        }
        if (this.dropMeasureAction.getType().equals("BASE")) {
            ++this.baseMeasures;
        } else {
            ++this.calcMeasures;
        }
    }

    private void layoutComponents() {
        JComponent jComponent;
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(this.dropMeasureAction.getDropMeasureLabel(this.measureName)), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        int n = 0;
        this.tabs = new JTabbedPane();
        this.tabs.add(OLAPArb.getString("DROP_DIALOG_CONFIRM_TAB_LABEL"), jPanel);
        if (!this.readOnly) {
            jComponent = new JSplitPane(0);
            JScrollPane jScrollPane = new JScrollPane((Component)this.referencesTable);
            ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
            componentWithTitlebar.setLabel(new JLabel(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.REFERENCES_TAB")));
            componentWithTitlebar.setComponent((JComponent)jScrollPane);
            jComponent.add((Component)componentWithTitlebar, "bottom");
            JScrollPane jScrollPane2 = new JScrollPane((Component)this.dependenciesTable);
            ComponentWithTitlebar componentWithTitlebar2 = new ComponentWithTitlebar();
            componentWithTitlebar2.setLabel(new JLabel(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.DEPENDENCIES_TAB")));
            componentWithTitlebar2.setComponent((JComponent)jScrollPane2);
            jComponent.add((Component)componentWithTitlebar2, "top");
            ((JSplitPane)jComponent).setResizeWeight(0.5);
            ((JSplitPane)jComponent).setDividerLocation(0.7);
            jPanel.add((Component)jComponent, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.tabs.add(OLAPArb.getString("DROP_DIALOG_DDL_TAB_LABEL"), this.sqlPanel);
            this.tabs.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (DropMeasureDialog.this.tabs.getSelectedIndex() == 1) {
                        DropMeasureDialog.this.calcCreator.clear();
                        DropMeasureDialog.this.calcCreator.addRemoveMeasure(DropMeasureDialog.this.measureName, DropMeasureDialog.this.cubeName);
                        if (DropMeasureDialog.this.dropDependencies && !DropMeasureDialog.this.dependencies.isEmpty()) {
                            for (Measure measure : DropMeasureDialog.this.dependencies) {
                                DropMeasureDialog.this.calcCreator.addRemoveMeasure(measure.getName(), measure.getCube().getName());
                            }
                        }
                        try {
                            DropMeasureDialog.this.sqlPanel.setDDLText(DropMeasureDialog.this.calcCreator.generateSQLXML());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        } else {
            jComponent = new JScrollPane((Component)this.dependenciesTable);
            ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
            componentWithTitlebar.setLabel(new JLabel(OLAPArb.getString("CREATE_DERIVED_MEASURE_DIALOG.DEPENDENCIES_TAB")));
            componentWithTitlebar.setComponent(jComponent);
            jPanel.add((Component)componentWithTitlebar, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.add((Component)this.tabs, new GridBagConstraints(0, n, 1, 1, 0.5, 0.5, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        jComponent = new DialogButtonBar();
        jComponent.add(this.okButton, DialogButtonBar.CONSTRAINT_APPLY);
        jComponent.add(this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
        this.add((Component)jComponent, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
    }

    private void addReferences(Measure measure) {
        List<Measure> list = CalcReferences.getReferences(measure, this.parser, this.aw);
        if (!list.isEmpty()) {
            for (Measure measure2 : list) {
                Object[] objectArray;
                if (measure2.getType().equals("DERIVED")) {
                    objectArray = new Object[]{measure2.getCube().getName(), measure2.getName(), measure2.getDescription(), measure2.getShortDescription(), measure2.getDescription(), measure2.getExpression()};
                    this.referencesTableModel.addRow(objectArray);
                    continue;
                }
                if (!measure2.getType().equals("BASE")) continue;
                objectArray = new Object[]{measure2.getCube().getName(), measure2.getName(), measure2.getDescription(), measure2.getShortDescription(), measure2.getDescription(), ""};
                this.referencesTableModel.addRow(objectArray);
            }
        }
    }

    private void addDependencies() {
        if (this.dependencies == null) {
            this.dependencies = CalcReferences.getDependencies(this.aw, this.cubeName, this.measureName, this.parser);
        }
        if (!this.dependencies.isEmpty()) {
            for (Measure measure : this.dependencies) {
                Object[] objectArray = new Object[]{measure.getCube().getName(), measure.getName(), measure.getDescription(), measure.getShortDescription(), measure.getDescription(), measure.getExpression()};
                this.dependenciesTableModel.addRow(objectArray);
            }
        }
    }

    private void showConfirmation() {
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), this.dropMeasureAction.getDropMeasureConfirmation(this.measureName), this.windowTitle, 1);
    }

    private void showConfirmationWithDependencies() {
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), OLAPArb.format("DROP_CALCULATED_MEASURE_DEPENDENCIES_CONFIRMATION", this.measureName + ", " + this.getMeasureDependenciesText()), this.windowTitle, 1);
    }

    private String getMeasureDependenciesText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Measure measure : this.dependencies) {
            stringBuffer.append(measure.getName() + ",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public void close() {
        this.dispose();
        this.setVisible(false);
    }

    public boolean isDropDependenciesSelected() {
        return this.dropDependencies;
    }

    public int getUserSelection() {
        return this.selection;
    }
}

