/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build.wizard;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.build.BuildObject;

public class BuildObjectsTreeModel
extends DefaultTreeModel {
    public static final String CUBES = OLAPArb.getString("BUILD_WIZARD_SEL_OBJ_CUBES");
    public static final String DIMENSIONS = OLAPArb.getString("BUILD_WIZARD_SEL_OBJ_DIMENSIONS");
    public static final String MEASURES = OLAPArb.getString("BUILD_WIZARD_SEL_OBJ_MEASURES");

    public BuildObjectsTreeModel(TreeNode treeNode) {
        super(treeNode);
    }

    public void populate(List<BuildObject> list, Schema schema) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(DIMENSIONS);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(CUBES);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        for (BuildObject buildObject : list) {
            if (buildObject.getType().equalsIgnoreCase("CUBE DIMENSION")) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(buildObject));
                continue;
            }
            if (!buildObject.getType().equalsIgnoreCase("CUBE")) continue;
            String string = buildObject.getName();
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(buildObject);
            Cube cube = schema.findCube(string);
            if (cube != null) {
                DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(MEASURES);
                defaultMutableTreeNode4.add(defaultMutableTreeNode5);
                for (Measure measure : cube.getMeasures()) {
                    if (measure.isDerived()) continue;
                    defaultMutableTreeNode5.add(new DefaultMutableTreeNode(measure));
                }
            }
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        }
    }
}

