/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build;

import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.db.DBUtil;
import oracle.jdbc.OracleCallableStatement;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.table.Queries;
import oracle.sql.CLOB;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BuildObject {
    public static final String BUILD_OBJECT_TYPE_CUBE = "CUBE";
    public static final String BUILD_OBJECT_TYPE_DIMENSION = "CUBE DIMENSION";
    public static final String BUILD_OBJECT_REFRESH_CODE_COMPLETE = "C";
    public static final String BUILD_OBJECT_REFRESH_CODE_FAST = "F";
    public static final String BUILD_OBJECT_REFRESH_CODE_FORCE = "?";
    public static final String BUILD_OBJECT_REFRESH_CODE_PCT = "P";
    public static final String BUILD_OBJECT_REFRESH_CODE_FAST_SOLVE = "S";
    public static final String BUILD_OBJECT_LOAD_SYNCH = "SYNCH";
    public static final String BUILD_OBJECT_LOAD_NOSYNCH = "NOSYNCH";
    public static final String BUILD_OBJECT_LOAD_RETAIN = "RETAIN";
    private static Queries queries;
    private static final String XMLFILE = "buildobjectqueries.xml";
    private static final String MVOPTIONS_QUERY = "MV_OPTIONS";
    private static final String MVOPTIONS_QUERY_FOR_DIM = "MV_OPTIONS_FOR_DIM";
    private static final String MVOPTIONS_QUERY_FOR_CUBE = "MV_OPTIONS_FOR_CUBE";
    private static final String CUBE_AW_QUERY = "CUBE_AW";
    private static final String DIM_AW_QUERY = "DIMENSION_AW";
    private static final String REWRITE_ENABLED_COLUMN_NAME = "REWRITE_ENABLED";
    private static final String REFRESH_METHOD_COLUMN_NAME = "REFRESH_METHOD";
    private static final String FAST_REFRESHABLE_COLUMN_NAME = "FAST_REFRESHABLE";
    private static final String LAST_REFRESH_TYPE_COLUMN_NAME = "LAST_REFRESH_TYPE";
    private static final String AW_COLUMN_NAME = "AW_NAME";
    private String m_name = null;
    private String m_type = null;
    private boolean m_isSynchOn = false;
    private boolean m_isSortOn = true;
    private String m_refreshMethod = "C";
    private String m_cubeScriptName = "";
    private String m_defaultBuildSpecName = "";
    private Map<String, String> m_cubeScripts = new HashMap<String, String>();
    private String m_inlineBuildSpec = "";
    private String m_owner = null;
    private Connection m_conn = null;
    private Boolean m_isMVOn = Boolean.FALSE;
    private String m_awName = null;
    private String m_loadOption = "";
    private Map<String, String> mvOptions = new HashMap<String, String>();
    private int buildItemIndex;
    private static final Logger LOGGER;

    public BuildObject() {
    }

    public BuildObject(Connection connection, String string, String string2, String string3) {
        this.m_conn = connection;
        this.m_owner = string;
        this.m_name = string2;
        this.setType(string3);
        this.loadMVOptions();
    }

    private void loadMVOptions() {
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.getConnection());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", this.getOwner());
        hashMap.put("objname", this.getName());
        String string = this.getQuery(MVOPTIONS_QUERY);
        if (this.m_type.equalsIgnoreCase(BUILD_OBJECT_TYPE_DIMENSION)) {
            string = this.getQuery(MVOPTIONS_QUERY_FOR_DIM);
        }
        if (this.m_type.equalsIgnoreCase(BUILD_OBJECT_TYPE_CUBE)) {
            string = this.getQuery(MVOPTIONS_QUERY_FOR_CUBE);
        }
        List list = dBUtil.executeReturnList(string, hashMap);
        String string2 = null;
        for (Map map : list) {
            String string3 = (String)map.get(REWRITE_ENABLED_COLUMN_NAME);
            this.mvOptions.put(REWRITE_ENABLED_COLUMN_NAME, string3);
            string2 = (String)map.get(REFRESH_METHOD_COLUMN_NAME);
            this.mvOptions.put(REFRESH_METHOD_COLUMN_NAME, string2);
            String string4 = (String)map.get(FAST_REFRESHABLE_COLUMN_NAME);
            this.mvOptions.put(FAST_REFRESHABLE_COLUMN_NAME, string4);
            String string5 = (String)map.get(LAST_REFRESH_TYPE_COLUMN_NAME);
            this.mvOptions.put(LAST_REFRESH_TYPE_COLUMN_NAME, string5);
            this.m_isMVOn = Boolean.TRUE;
        }
        if ((this.isFastRefreshable() || this.isMVRewriteEnabled()) && string2 != null) {
            if (string2.equalsIgnoreCase("FORCE")) {
                this.m_refreshMethod = BUILD_OBJECT_REFRESH_CODE_FORCE;
            } else if (string2.equalsIgnoreCase("FAST")) {
                this.m_refreshMethod = BUILD_OBJECT_REFRESH_CODE_FAST;
            }
        }
        if (this.getType().equalsIgnoreCase(BUILD_OBJECT_TYPE_DIMENSION)) {
            if (this.isMVOn()) {
                this.setLoadOption(BUILD_OBJECT_LOAD_SYNCH);
            } else {
                this.setLoadOption(BUILD_OBJECT_LOAD_NOSYNCH);
            }
        }
    }

    public boolean isFastRefreshable() {
        boolean bl = true;
        if (this.isMVOn()) {
            if (this.mvOptions.get(FAST_REFRESHABLE_COLUMN_NAME).equalsIgnoreCase("NO") || this.mvOptions.get(LAST_REFRESH_TYPE_COLUMN_NAME).equalsIgnoreCase("NA")) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isMVRewriteEnabled() {
        boolean bl = true;
        if (this.isMVOn()) {
            if (!this.mvOptions.get(REWRITE_ENABLED_COLUMN_NAME).equalsIgnoreCase("Y")) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public String getOwner() {
        return this.m_owner;
    }

    public void setOwner(String string) {
        this.m_owner = string;
    }

    public String getFullyQualifiedName() {
        String string = "";
        if (this.m_name != null) {
            string = this.m_name;
            if (this.m_owner != null) {
                string = this.m_owner + "." + string;
            }
        }
        return string;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String string) {
        if (string.equalsIgnoreCase(BUILD_OBJECT_TYPE_CUBE)) {
            this.m_isSynchOn = false;
            this.m_isSortOn = false;
        }
        this.m_type = string;
    }

    public boolean isSynchOn() {
        return this.m_isSynchOn;
    }

    public String getLoadOption() {
        String string = this.m_loadOption;
        return string;
    }

    public void setLoadOption(String string) {
        if (this.getType().equalsIgnoreCase(BUILD_OBJECT_TYPE_DIMENSION)) {
            if (string.equalsIgnoreCase(BUILD_OBJECT_LOAD_SYNCH)) {
                this.m_isSynchOn = true;
            } else if (string.equalsIgnoreCase(BUILD_OBJECT_LOAD_NOSYNCH) || string.equalsIgnoreCase(BUILD_OBJECT_LOAD_RETAIN)) {
                this.m_isSynchOn = false;
            }
        }
        this.m_loadOption = string;
    }

    public boolean isSortOn() {
        return this.m_isSortOn;
    }

    public void setSort(boolean bl) {
        this.m_isSortOn = bl;
    }

    public String getRefreshMethod() {
        return this.m_refreshMethod;
    }

    public void setRefreshMethod(String string) {
        this.m_refreshMethod = string;
    }

    public String getCubeScriptName() {
        if (this.m_cubeScriptName == null || this.m_cubeScriptName.length() == 0) {
            try {
                List<String> list = this.getCubeScriptNames();
                if (!list.isEmpty()) {
                    this.m_cubeScriptName = this.m_defaultBuildSpecName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_cubeScriptName;
    }

    public void setCubeScriptName(String string) {
        this.m_cubeScriptName = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getCubeScriptNames() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        OracleCallableStatement oracleCallableStatement = null;
        Reader reader = null;
        CLOB cLOB = null;
        if (!this.m_cubeScripts.isEmpty()) {
            Set<String> set = this.m_cubeScripts.keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList;
        }
        if (!this.m_type.equalsIgnoreCase(BUILD_OBJECT_TYPE_CUBE)) return arrayList;
        String string = this.getOwner() + "." + this.getName();
        try {
            String string2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            cLOB = CLOB.createTemporary((Connection)this.m_conn, (boolean)true, (int)10);
            CLOB cLOB2 = CLOB.createTemporary((Connection)this.m_conn, (boolean)true, (int)10);
            Writer writer = cLOB2.setCharacterStream(1L);
            StringBuffer stringBuffer = new StringBuffer("");
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("<Export>\n");
            stringBuffer2.append("          <ExportOptions>\n");
            stringBuffer2.append("           <Option Name=\"SuppressNamespace\" Value=\"True\"/>\n");
            stringBuffer2.append("           <Option Name=\"SuppressOwner\" Value=\"True\"/>\n");
            stringBuffer2.append("           <Option Name=\"PreserveTableOwners\" Value=\"True\"/>\n");
            stringBuffer2.append("          </ExportOptions>\n");
            stringBuffer2.append("         </Export>");
            writer.write(stringBuffer2.toString());
            writer.close();
            oracleCallableStatement = (OracleCallableStatement)this.m_conn.prepareCall("begin dbms_cube.export_xml(?, ?, ?); end;");
            oracleCallableStatement.setString(1, string);
            oracleCallableStatement.setCLOB(2, cLOB2);
            oracleCallableStatement.setCLOB(3, cLOB);
            oracleCallableStatement.registerOutParameter(3, 2005);
            oracleCallableStatement.execute();
            cLOB2.freeTemporary();
            cLOB = oracleCallableStatement.getCLOB(3);
            if (cLOB != null) {
                reader = cLOB.getCharacterStream();
            }
            if (reader == null) return arrayList;
            char[] cArray = new char[2000];
            int n = 0;
            while ((n = reader.read(cArray)) != -1) {
                object4 = new String(cArray, 0, n);
                stringBuffer.append((String)object4);
            }
            object4 = new StringReader(stringBuffer.toString());
            InputSource inputSource = new InputSource((Reader)object4);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setCoalescing(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            NodeList nodeList = document.getElementsByTagName("DefaultBuild");
            if (nodeList.getLength() > 0) {
                Element element = (Element)nodeList.item(0);
                object3 = element.getChildNodes();
                object2 = object3.item(0);
                object = object2.getNodeValue().trim();
                string2 = ((String)object).substring(11);
                string2 = string2.substring(0, string2.indexOf(10));
                this.m_cubeScripts.put(string2, (String)object);
                this.m_defaultBuildSpecName = string2;
                arrayList.add(string2);
            }
            nodeList = document.getElementsByTagName("BuildSpecifications");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object3 = (Element)nodeList.item(i);
                object2 = object3.getChildNodes();
                object = object2.item(0);
                string2 = object.getNodeValue().trim();
                String string3 = string2.substring(11);
                string3 = string3.substring(0, string3.indexOf(10));
                this.m_cubeScripts.put(string3, string2);
                arrayList.add(string3);
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
            }
            if (cLOB != null) {
                cLOB.freeTemporary();
            }
        }
    }

    public String getBuildSpecification() {
        String string = this.getCubeScriptName();
        return this.getBuildSpecification(string);
    }

    public String getBuildSpecification(String string) {
        String string2 = this.m_cubeScripts.get(string);
        return string2;
    }

    public String getDefaultBuildSpecificationName() {
        if (this.m_defaultBuildSpecName == null || this.m_defaultBuildSpecName.length() == 0) {
            try {
                List<String> list = this.getCubeScriptNames();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_defaultBuildSpecName;
    }

    public String getInlineBuildSpecification() {
        return this.m_inlineBuildSpec;
    }

    public void setInlineBuildSpecification(String string) {
        this.m_inlineBuildSpec = string;
    }

    public int getBuildItemIndex() {
        return this.buildItemIndex;
    }

    public void setBuildItemIndex(int n) {
        this.buildItemIndex = n;
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    public void setConnection(Connection connection) {
        this.m_conn = connection;
    }

    public boolean isMVOn() {
        return this.m_isMVOn;
    }

    public String getAWName() {
        if (this.m_awName == null && this.m_type != null) {
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.getConnection());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("owner", this.getOwner());
            hashMap.put("objname", this.getName());
            String string = null;
            if (this.m_type.equalsIgnoreCase(BUILD_OBJECT_TYPE_CUBE)) {
                string = this.getQuery(CUBE_AW_QUERY);
            }
            if (this.m_type.equalsIgnoreCase(BUILD_OBJECT_TYPE_DIMENSION)) {
                string = this.getQuery(DIM_AW_QUERY);
            }
            if (string != null) {
                List list = dBUtil.executeReturnList(string, hashMap);
                for (Map map : list) {
                    this.m_awName = (String)map.get(AW_COLUMN_NAME);
                }
            }
        }
        return this.m_awName;
    }

    public void setAWName(String string) {
        this.m_awName = string;
    }

    public String toString() {
        return this.getName();
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        BuildObject.queries = queries;
    }

    static {
        LOGGER = Logger.getLogger(BuildObject.class.getName());
    }
}

