/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.tree.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.olap.app.tree.model.CheckTreeSelectionModel;
import oracle.olap.app.tree.view.NodeIcon;
import oracle.olap.app.tree.view.TristateCheckBox;

public class CheckTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private CheckTreeSelectionModel selectionModel;
    private TreeCellRenderer delegate;
    private TristateCheckBox checkBox = new TristateCheckBox();
    private NodeIcon nodeIcon;

    public CheckTreeCellRenderer(TreeCellRenderer treeCellRenderer, CheckTreeSelectionModel checkTreeSelectionModel, NodeIcon nodeIcon) {
        this.delegate = treeCellRenderer;
        this.selectionModel = checkTreeSelectionModel;
        this.nodeIcon = nodeIcon;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.checkBox.setOpaque(false);
    }

    public void setCheckBoxEnabled(boolean bl) {
        this.checkBox.setEnabled(bl);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Serializable serializable;
        Component component = this.delegate.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (component instanceof DefaultTreeCellRenderer) {
            serializable = (DefaultTreeCellRenderer)component;
            if (this.nodeIcon != null) {
                Icon icon = this.nodeIcon.getIcon(object);
                Icon icon2 = this.nodeIcon.getDisabledIcon(object);
                if (icon != null) {
                    ((JLabel)serializable).setIcon(icon);
                    if (icon2 == null) {
                        icon2 = icon;
                    }
                    ((JLabel)serializable).setDisabledIcon(icon2);
                }
            }
        }
        if ((serializable = jTree.getPathForRow(n)) != null) {
            if (this.selectionModel.isPathSelected((TreePath)serializable, true)) {
                this.checkBox.setState(Boolean.TRUE);
            } else {
                this.checkBox.setState(this.selectionModel.isPartiallySelected((TreePath)serializable) ? null : Boolean.FALSE);
            }
        }
        this.removeAll();
        this.add((Component)this.checkBox, "West");
        this.add(component, "Center");
        return this;
    }
}

