/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import oracle.olap.app.hyper.HyperLabel;
import oracle.olap.app.hyper.HyperLabelActionListener;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templateview.MultiSelectEditor;
import oracle.olap.app.templates.templateview.TemplateHyperParam;

public abstract class TemplateHyperParamMultiSelect
extends TemplateHyperParam {
    private static final Logger LOG = Logger.getLogger(TemplateHyperParamMultiSelect.class.getName());
    private static int dotWidth;
    protected List<String> selections = new ArrayList<String>();
    protected HyperLabel multiSelectHyperLabel = new HyperLabel("");
    protected MultiSelectEditor multiSelectEditor;
    protected String helpID;
    protected String editorTitle;
    protected int maxWidth;
    protected JDialog selectionDialog;
    protected JOptionPane pane;
    protected PropertyChangeListener selectionJOptionPanePropertyChangeListener;

    public TemplateHyperParamMultiSelect() {
        this.multiSelectHyperLabel.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
                TemplateHyperParamMultiSelect.this.showPicker();
            }
        });
        dotWidth = this.multiSelectHyperLabel.getFontMetrics(this.multiSelectHyperLabel.getFont()).stringWidth("...");
        this.selectionJOptionPanePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (TemplateHyperParamMultiSelect.this.selectionDialog.isVisible() && propertyChangeEvent.getSource() == TemplateHyperParamMultiSelect.this.pane && propertyChangeEvent.getPropertyName().equals("value") && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    TemplateHyperParamMultiSelect.this.selectionDialog.setVisible(false);
                }
            }
        };
    }

    protected void showPicker() {
        this.multiSelectEditor.setSelectedItems(this.selections);
        this.pane = new JOptionPane(this.multiSelectEditor, -1, 2, null);
        this.pane.addPropertyChangeListener(this.selectionJOptionPanePropertyChangeListener);
        Window window = this.getWindowForComponent(this.multiSelectHyperLabel);
        this.selectionDialog = window instanceof Frame ? new JDialog((Frame)window, this.editorTitle, true) : new JDialog((Dialog)window, this.editorTitle, true);
        this.selectionDialog.setContentPane(this.pane);
        this.selectionDialog.setLocationRelativeTo(this.multiSelectHyperLabel);
        this.selectionDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.selectionDialog.pack();
        this.selectionDialog.setResizable(true);
        this.selectionDialog.setSize(new Dimension(400, 300));
        this.selectionDialog.setVisible(true);
        Object object = this.pane.getValue();
        if (object instanceof Integer && (Integer)this.pane.getValue() == 0) {
            List<String> list = this.multiSelectEditor.getSelectedItems();
            this.setValue(list);
        }
    }

    protected Window getWindowForComponent(Component component) throws HeadlessException {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return this.getWindowForComponent(component.getParent());
    }

    @Override
    public Component getComponent() {
        return this.multiSelectHyperLabel;
    }

    @Override
    public Object getValue() {
        return this.selections;
    }

    @Override
    public boolean setValue(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", this.selections, object);
            this.selections = new ArrayList<String>(list.size());
            for (Object e : list) {
                if (e instanceof ParseNode) {
                    this.selections.add(((ParseNode)e).getValue());
                    continue;
                }
                this.selections.add(e.toString());
            }
            Object object2 = this.getExpression();
            if (this.maxWidth > 0) {
                object2 = this.trimToPixels(this.maxWidth, (String)object2);
                this.multiSelectHyperLabel.setText((String)object2);
            } else {
                this.multiSelectHyperLabel.setText((String)object2);
            }
            this.firePropertyChangeEvent(propertyChangeEvent);
            return true;
        }
        return false;
    }

    private String trimToPixels(int n, String string) {
        try {
            if (n == 0 || string == null || string.length() == 0) {
                return string;
            }
            int n2 = this.multiSelectHyperLabel.getFontMetrics(this.multiSelectHyperLabel.getFont()).stringWidth(string);
            if (n2 > n && n > dotWidth) {
                int n3;
                int n4;
                n -= dotWidth;
                while (n2 > n && string.length() > 0 && (n4 = (int)((double)(n3 = string.length()) / (double)n2 * (double)n)) < string.length()) {
                    string = string.substring(0, n4);
                    n2 = this.multiSelectHyperLabel.getFontMetrics(this.multiSelectHyperLabel.getFont()).stringWidth(string);
                }
                string = string + "...";
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, String.format("Could not trim the expression %s", string), throwable);
        }
        return string;
    }

    @Override
    public String getExpression() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = this.selections.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(',');
                stringBuilder.append(iterator.next());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int getPixelSize(int n) {
        this.maxWidth = n;
        String string = this.trimToPixels(n, this.getExpression());
        this.multiSelectHyperLabel.setText(string);
        return this.multiSelectHyperLabel.getFontMetrics(this.multiSelectHyperLabel.getFont()).stringWidth(string);
    }
}

