/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.olap.app.syntaxparser.ParseNode;
import oracle.olap.app.templates.templatelist.Item;
import oracle.olap.app.templates.templateview.ItemElement;
import oracle.olap.app.templates.templateview.TemplateHyperParam;
import oracle.olap.app.templates.templateview.TemplateHyperParamCombo;
import oracle.olap.stringexpr.StringExprParser;

public class TemplateHyperParamList
extends TemplateHyperParamCombo
implements PropertyChangeListener {
    private static Logger LOG = Logger.getLogger(TemplateHyperParamList.class.getName());
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    private ParseNode pattern;
    private LinkedList<ItemElement> fullItemList = new LinkedList();
    private boolean selectionChanged;

    @Override
    public ParseNode getPattern() {
        this.pattern = new ParseNode(this.getName(), null, ParseNode.PatternType.CHOICE);
        this.pattern.setOffset(this.hyperCombo.getSelectedIndex());
        this.pattern.setEnd(this.fullItemList.size());
        return this.pattern;
    }

    @Override
    public String getExpression() {
        ItemElement itemElement = (ItemElement)this.getSelectedElement();
        return itemElement.getExpression();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        for (TemplateHyperParam object2 : this.getOptionalHyperParams()) {
            object2.getComponent().setVisible(false);
        }
        Object object = this.getSelectedElement();
        if (object instanceof ItemElement) {
            ItemElement itemElement = (ItemElement)object;
            itemElement.setDefault();
            TemplateHyperParam templateHyperParam = itemElement.getOptional();
            if (templateHyperParam != null) {
                templateHyperParam.setVisible(true);
            }
        }
        super.itemStateChanged(itemEvent);
    }

    @Override
    public boolean isSaveSelectionToParam() {
        return false;
    }

    private void populateComboBoxModel() {
        this.removeAllElements();
        for (ItemElement itemElement : this.fullItemList) {
            TemplateHyperParam templateHyperParam = itemElement.getOptional();
            if (templateHyperParam != null && !templateHyperParam.isValid()) continue;
            this.addElement(itemElement);
        }
    }

    @Override
    public void listenerSafeInit() {
        for (Item object : this.getParam().getItems()) {
            Object exception;
            String string = object.getCondition();
            boolean bl = true;
            if (string != null) {
                try {
                    exception = StringExprParser.getParseTree(string, this.getBaseTemplateHyperView());
                    bl = Boolean.parseBoolean((String)exception);
                }
                catch (Exception exception2) {
                    LOG.log(Level.FINE, exception2.getMessage(), exception2);
                }
            }
            if (!bl) continue;
            exception = new ItemElement(this, this.getParam(), object);
            this.fullItemList.add((ItemElement)exception);
            TemplateHyperParam templateHyperParam = ((ItemElement)exception).getOptional();
            if (templateHyperParam == null) continue;
            this.addOptionalHyperParams(templateHyperParam);
            templateHyperParam.setVisible(false);
        }
        this.populateComboBoxModel();
        Item item = this.findDefault();
        this.selectionChanged = item != null ? this.setValue(item) : true;
        if (this.getOptionalHyperParams().size() > 0) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("visible")) {
                        ItemElement itemElement = (ItemElement)TemplateHyperParamList.this.getSelectedElement();
                        if (itemElement != null) {
                            for (TemplateHyperParam templateHyperParam : TemplateHyperParamList.this.getOptionalHyperParams()) {
                                templateHyperParam.getComponent().setVisible(templateHyperParam.equals(itemElement.getOptional()));
                            }
                        } else {
                            for (TemplateHyperParam templateHyperParam : TemplateHyperParamList.this.getOptionalHyperParams()) {
                                templateHyperParam.getComponent().setVisible(false);
                            }
                        }
                    } else if ("VALID_PROPERTY".equals(propertyChangeEvent.getPropertyName())) {
                        Object object = TemplateHyperParamList.this.getSelectedElement();
                        TemplateHyperParamList.this.populateComboBoxModel();
                        if (object == null || !TemplateHyperParamList.this.selectionChanged) {
                            if (!TemplateHyperParamList.this.selectionChanged) {
                                TemplateHyperParamList.this.selectionChanged = Boolean.parseBoolean(String.valueOf(propertyChangeEvent.getNewValue()));
                            }
                            TemplateHyperParamList.this.setValue(TemplateHyperParamList.this.findDefault());
                        } else {
                            TemplateHyperParamList.this.setValue(object);
                        }
                    }
                }
            };
            for (TemplateHyperParam templateHyperParam : this.getOptionalHyperParams()) {
                templateHyperParam.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    @Override
    public void setValueMap(Map<String, String> map) throws SQLException, IOException {
        for (int i = 0; i < this.getComboBoxModel().getSize(); ++i) {
            ((ItemElement)this.getComboBoxModel().getElementAt(i)).setValueMap(map);
        }
    }

    @Override
    public boolean setValue(Object object) {
        ParseNode parseNode;
        if (object instanceof ParseNode && (parseNode = (ParseNode)object).getPatternType() == ParseNode.PatternType.OPTION) {
            int n = parseNode.getOffset();
            if (n >= 0 && n < this.fullItemList.size() && n < this.hyperCombo.getItemCount() && this.fullItemList.get(n) == this.hyperCombo.getItemAt(n)) {
                this.hyperCombo.setSelectedIndex(n);
                this.selectionChanged = true;
                return true;
            }
            return false;
        }
        return super.setValue(object);
    }

    private Item findDefault() {
        for (Item item : this.getParam().getItems()) {
            if (!item.getInitDefault()) continue;
            return item;
        }
        return null;
    }

    @Override
    public int getPixelSize(int n) {
        ItemElement itemElement = (ItemElement)this.getSelectedElement();
        int n2 = this.getComponent().getFontMetrics(this.getComponent().getFont()).stringWidth(itemElement.toString());
        return n2;
    }
}

