/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.share.nls.StringUtils;
import oracle.olap.app.templates.templateview.MultiSelectEditor;
import oracle.olap.syntaxbuilder.olapihelpers.SyntaxVisitor;

public class MultiSelectShuttlePanel
extends JPanel
implements MultiSelectEditor {
    private DefaultListModel allObjectListModel;
    private DefaultListModel selectedObjectListModel;
    protected List<String> availableItems;
    protected String availableListLabel;
    protected String selectedListLabel;

    public MultiSelectShuttlePanel() {
        this(new ArrayList<String>(), null, null);
    }

    public MultiSelectShuttlePanel(List<String> list, String string, String string2) {
        this.availableListLabel = string;
        this.selectedListLabel = string2;
        this.availableItems = list;
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createShuttle(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private Shuttle createShuttle() {
        this.allObjectListModel = new DefaultListModel();
        JList jList = new JList(this.allObjectListModel);
        this.selectedObjectListModel = new DefaultListModel();
        JList jList2 = new JList(this.selectedObjectListModel);
        Shuttle shuttle = new Shuttle();
        shuttle.setButtonsShown(15);
        ListPicker listPicker = new ListPicker(jList2);
        shuttle.setToPicker((ItemPicker)listPicker);
        ListPicker listPicker2 = new ListPicker(jList);
        shuttle.setFromPicker((ItemPicker)listPicker2);
        JLabel jLabel = new JLabel();
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        shuttle.add((Component)jLabel, (Object)"FromHeader");
        JLabel jLabel2 = new JLabel();
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        jLabel.setText(StringUtils.stripMnemonic((String)this.availableListLabel));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.availableListLabel));
        int n = StringUtils.getMnemonicIndex((String)this.availableListLabel);
        if (n != -1) {
            jLabel.setDisplayedMnemonicIndex(n);
        }
        jLabel.setLabelFor(jList);
        jLabel2.setText(StringUtils.stripMnemonic((String)this.selectedListLabel));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.selectedListLabel));
        n = StringUtils.getMnemonicIndex((String)this.selectedListLabel);
        if (n != -1) {
            jLabel2.setDisplayedMnemonicIndex(n);
        }
        jLabel2.setLabelFor(jList2);
        shuttle.add((Component)jLabel2, (Object)"ToHeader");
        shuttle.setMinimumSize(new Dimension(350, 125));
        shuttle.setEnabled(true);
        jList2.setEnabled(true);
        jList.setEnabled(true);
        return shuttle;
    }

    private void populateShuttle(List<String> list) {
        this.allObjectListModel.removeAllElements();
        this.selectedObjectListModel.removeAllElements();
        for (String string : this.availableItems) {
            if (this.isSelected(string, list)) {
                this.selectedObjectListModel.addElement(string);
                continue;
            }
            this.allObjectListModel.addElement(string);
        }
    }

    private boolean isSelected(String string, List<String> list) {
        for (String string2 : list) {
            if (!this.equivalent(string2, string)) continue;
            return true;
        }
        return false;
    }

    private boolean equivalent(String string, String string2) {
        return SyntaxVisitor.tokensMatch(string, string2);
    }

    @Override
    public List<String> getSelectedItems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.selectedObjectListModel.getSize();
        for (int i = 0; i < n; ++i) {
            arrayList.add((String)this.selectedObjectListModel.get(i));
        }
        return arrayList;
    }

    @Override
    public void setSelectedItems(List<String> list) {
        this.populateShuttle(list);
    }
}

