/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templateview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import oracle.olap.app.Resources;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.util.FetchIcon;

public class MeasureTreeNode
implements TreeNode {
    private static final String CUBE_ICON = "OLAPCUBE_ICON";
    private static final String CUBE_FOLDER_ICON = "OLAPCUBE_FOLDER_ICON";
    private static final String MEASURE_ICON = "OLAPMEASURE_ICON";
    private static final String MEASURE_FOLDER_ICON = "OLAPMEASURE_FOLDER_ICON";
    private static final String CALC_ICON = "OLAPCALCMEASURE_ICON";
    private static final String CALC_FOLDER_ICON = "OLAPCALCMEASURE_FOLDER_ICON";
    private static final String TITLE = "MEASURE_PICKER_TITLE";
    private static final String CALC_MEASURES = "MEASURE_PICKER_CALC_MEASURES";
    private static final String MEASURES = "MEASURE_PICKER_MEASURES";
    private static final String OTHER_CUBES = "MEASURE_PICKER_OTHER_CUBES";
    private final Vector<MeasureTreeNode> children = new Vector();
    private MeasureTreeNode parent;
    private final String text;
    private final String id;
    private final Icon icon;
    private final Measure measure;
    private String AWname;
    private Cube cube;
    private List<Cube> cubes;
    private Resources r;
    private FetchIcon fi;

    MeasureTreeNode(String string, Cube cube, List<Cube> list, Resources resources, FetchIcon fetchIcon) {
        this(string, null);
        this.AWname = string;
        this.cube = cube;
        this.r = resources;
        this.fi = fetchIcon;
        this.add(new MeasureTreeNode(cube, resources, fetchIcon));
        Collections.sort(list, new Comparator<Cube>(){

            @Override
            public int compare(Cube cube, Cube cube2) {
                return cube.getName().compareTo(cube2.getName());
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        this.cubes = list;
        MeasureTreeNode measureTreeNode = new MeasureTreeNode(resources.getString(OTHER_CUBES), fetchIcon.getIcon(CUBE_FOLDER_ICON));
        this.add(measureTreeNode);
        for (Cube cube2 : list) {
            if (!cube2.getAWName().equals(string) || cube2.getName().equals(cube.getName())) continue;
            measureTreeNode.add(new MeasureTreeNode(cube2, resources, fetchIcon));
        }
    }

    private MeasureTreeNode(String string, Icon icon) {
        this(string, null, icon);
    }

    MeasureTreeNode(String string, String string2, Icon icon) {
        this(string, string2, null, icon);
    }

    private MeasureTreeNode(String string, String string2, Measure measure, Icon icon) {
        this.text = string;
        this.icon = icon;
        if (measure != null) {
            this.id = measure.getID();
            this.measure = measure;
        } else {
            this.id = string2;
            this.measure = null;
        }
    }

    private MeasureTreeNode(Cube cube, Resources resources, FetchIcon fetchIcon) {
        this(cube.getName(), fetchIcon.getIcon(CUBE_ICON));
        MeasureTreeNode measureTreeNode = new MeasureTreeNode(resources.getString(MEASURES), fetchIcon.getIcon(MEASURE_FOLDER_ICON));
        MeasureTreeNode measureTreeNode2 = new MeasureTreeNode(resources.getString(CALC_MEASURES), fetchIcon.getIcon(CALC_FOLDER_ICON));
        List<Measure> list = cube.getMeasures();
        Collections.sort(list, new Comparator<Measure>(){

            @Override
            public int compare(Measure measure, Measure measure2) {
                return measure.getName().compareTo(measure2.getName());
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        for (Measure measure : list) {
            if (measure.isDerived()) {
                measureTreeNode2.add(new MeasureTreeNode(measure, fetchIcon));
                continue;
            }
            measureTreeNode.add(new MeasureTreeNode(measure, fetchIcon));
        }
        this.add(measureTreeNode);
        this.add(measureTreeNode2);
    }

    private MeasureTreeNode(Measure measure, FetchIcon fetchIcon) {
        this(measure.getName(), null, measure, measure.isDerived() ? fetchIcon.getIcon(CALC_ICON) : fetchIcon.getIcon(MEASURE_ICON));
    }

    @Override
    public TreeNode getChildAt(int n) {
        return this.children.get(n);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.children.indexOf(treeNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public Enumeration children() {
        return this.children.elements();
    }

    public String toString() {
        return this.text;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getID() {
        return this.id;
    }

    public MeasureTreeNode find(String string) {
        MeasureTreeNode measureTreeNode = null;
        if (this.id != null && this.id.equals(string)) {
            return this;
        }
        for (MeasureTreeNode measureTreeNode2 : this.children) {
            measureTreeNode = measureTreeNode2.find(string);
            if (measureTreeNode == null) continue;
            return measureTreeNode;
        }
        return null;
    }

    void add(MeasureTreeNode measureTreeNode) {
        this.children.add(measureTreeNode);
        measureTreeNode.parent = this;
    }

    void clear() {
        this.children.removeAllElements();
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public List<MeasureTreeNode> getChildren() {
        ArrayList<MeasureTreeNode> arrayList = new ArrayList<MeasureTreeNode>();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add((MeasureTreeNode)this.getChildAt(i));
        }
        return arrayList;
    }

    public boolean matches(String string) {
        if (this.measure == null) {
            return false;
        }
        String string2 = this.measure.getName().toUpperCase();
        return (string = string.trim().toUpperCase()).endsWith("%") ? string2.startsWith(string.substring(0, string.length() - 1)) : (string.startsWith("%") ? string2.endsWith(string.substring(1)) : string2.startsWith(string));
    }
}

