/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.templates.templatelist;

import java.io.IOException;
import java.sql.SQLException;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.stringexpr.ParamValue;

public class QDRData
implements ParamValue,
Cloneable {
    private String dimension;
    private Dimension dimensionObj;
    private DimensionHierarchy hierarchy;
    private String memberKey;
    private String memberDescription;
    private boolean quoteMemberExpression;

    public QDRData(String string, String string2, String string3) {
        this.dimension = string;
        this.memberKey = string2;
        this.memberDescription = string3;
        this.quoteMemberExpression = true;
    }

    public QDRData(DimensionHierarchy dimensionHierarchy, String string, String string2) {
        this.hierarchy = dimensionHierarchy;
        this.memberKey = string;
        this.memberDescription = string2;
        this.quoteMemberExpression = true;
    }

    public QDRData(Dimension dimension, String string, String string2) {
        this.dimensionObj = dimension;
        this.memberKey = string;
        this.memberDescription = string2;
        this.quoteMemberExpression = true;
    }

    public QDRData(QDRData qDRData) {
        this.setData(qDRData);
    }

    public String toString() {
        String string;
        String string2 = string = this.memberDescription == null ? this.memberKey : this.memberDescription;
        if (this.isQuoteMemberExpression()) {
            return String.format("%s='%s'", this.dimension, string);
        }
        return String.format("%s=%s", this.dimension, string);
    }

    public String getExpression() {
        if (this.isQuoteMemberExpression()) {
            return String.format("\"%s\"='%s'", this.dimension, this.memberKey);
        }
        return String.format("\"%s\"=%s", this.dimension, this.memberKey);
    }

    public void setMemberKey(String string) {
        this.memberKey = string;
    }

    public String getMemberKey() {
        return this.memberKey;
    }

    public void setDimension(String string) {
        this.dimension = string;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setMemberDescription(String string) {
        this.memberDescription = string;
    }

    public String getMemberDescription() {
        return this.memberDescription;
    }

    public void setData(QDRData qDRData) {
        this.setDimension(qDRData.getDimension());
        this.setMemberKey(qDRData.getMemberKey());
        this.setMemberDescription(qDRData.getMemberDescription());
        this.setQuoteMemberExpression(qDRData.isQuoteMemberExpression());
    }

    public void setQuoteMemberExpression(boolean bl) {
        this.quoteMemberExpression = bl;
    }

    public boolean isQuoteMemberExpression() {
        return this.quoteMemberExpression;
    }

    public Object clone() {
        return new QDRData(this);
    }

    public boolean equals(Object object) {
        if (object instanceof QDRData) {
            QDRData qDRData = (QDRData)object;
            if (qDRData.dimension != null && qDRData.dimension.equals(this.dimension) && (qDRData.memberKey == this.memberKey || qDRData.memberKey != null && qDRData.memberKey.equals(this.memberKey))) {
                return true;
            }
        }
        return super.equals(object);
    }

    @Override
    public Object getValue(String string) throws SQLException, IOException {
        if (string.equalsIgnoreCase("key")) {
            return this.memberKey;
        }
        if (string.equalsIgnoreCase("qkey")) {
            return "'" + this.memberKey + "'";
        }
        return null;
    }
}

