/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.searchbar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;

public final class SearchFieldBorder
extends AbstractBorder {
    private Color _foreground = UIManager.getColor("TextArea.foreground");
    private Color _background = UIManager.getColor("TextArea.background");
    private static final Insets BORDER_INSETS = new Insets(2, 8, 2, 8);

    public void setForeground(Color color) {
        if (color == null) {
            throw new NullPointerException("foreground is null");
        }
        this._foreground = color;
    }

    public Color getForeground() {
        return this._foreground;
    }

    public void setBackground(Color color) {
        if (color == null) {
            throw new NullPointerException("background is null");
        }
        this._background = color;
    }

    public Color getBackground() {
        return this._background;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Color color = graphics2D.getColor();
        Shape shape = graphics2D.getClip();
        try {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(new Arc2D.Double(n, n2, SearchFieldBorder.BORDER_INSETS.left * 2 - 1, n4 - 1, 90.0, 180.0, 0), true);
            generalPath.lineTo(n + n3 - SearchFieldBorder.BORDER_INSETS.right - 2, n2 + n4 - 1);
            generalPath.append(new Arc2D.Double(n + n3 - SearchFieldBorder.BORDER_INSETS.right * 2 - 1, n2, SearchFieldBorder.BORDER_INSETS.right * 2 - 1, n4 - 1, 270.0, 180.0, 0), true);
            generalPath.lineTo(n + SearchFieldBorder.BORDER_INSETS.left, n2);
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            Area area = new Area(rectangle);
            area.subtract(new Area(new Rectangle(n + SearchFieldBorder.BORDER_INSETS.left, n2 + SearchFieldBorder.BORDER_INSETS.top, n + n3 - SearchFieldBorder.BORDER_INSETS.left - SearchFieldBorder.BORDER_INSETS.right, n2 + n4 - SearchFieldBorder.BORDER_INSETS.top - SearchFieldBorder.BORDER_INSETS.bottom)));
            graphics2D.setClip(area);
            graphics2D.setColor(this._background);
            graphics2D.fill(generalPath);
            graphics2D.setColor(this._foreground);
            graphics2D.draw(generalPath);
        }
        finally {
            graphics2D.setColor(color);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            graphics2D.setClip(shape);
        }
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return BORDER_INSETS;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = SearchFieldBorder.BORDER_INSETS.top;
        insets.left = SearchFieldBorder.BORDER_INSETS.left;
        insets.right = SearchFieldBorder.BORDER_INSETS.right;
        insets.bottom = SearchFieldBorder.BORDER_INSETS.bottom;
        return BORDER_INSETS;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new SearchFieldBorder());
        jPanel.setLayout(new BorderLayout());
        JTextField jTextField = new JTextField();
        jTextField.setBorder(null);
        jPanel.add((Component)jTextField, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jFrame.setDefaultCloseOperation(2);
        jFrame.setContentPane(jPanel2);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

