/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.searchbar;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import oracle.olap.app.Resources;
import oracle.olap.app.searchbar.SearchFieldBorder;
import oracle.olap.app.searchbar.SearchOptions;
import oracle.olap.app.searchbar.SearchOptionsSelectionNotifier;
import oracle.olap.app.util.FetchIcon;

public class SearchBar
extends JPanel {
    private JTextField searchTextField;
    private JPopupMenu optionsMenu;
    private SearchOptions searchOptions;
    private JLabel searchFwdLabel;
    private JLabel searchBckLabel;
    private JLabel downLabel;
    private SearchOptionsSelectionNotifier optionsNotifier;
    private FetchIcon fetchIcon;
    private Resources resources;

    public SearchBar(SearchOptions searchOptions, FetchIcon fetchIcon, Resources resources) {
        this.searchOptions = searchOptions;
        this.searchTextField = new JTextField();
        this.fetchIcon = fetchIcon;
        this.resources = resources;
        this.init();
    }

    public SearchBar(SearchOptions searchOptions) {
        this.searchOptions = searchOptions;
        this.searchTextField = new JTextField();
        this.init();
    }

    public void setSearchOptionsSelectionNotifier(SearchOptionsSelectionNotifier searchOptionsSelectionNotifier) {
        this.optionsNotifier = searchOptionsSelectionNotifier;
    }

    private void init() {
        Serializable serializable;
        Object object2;
        Object object3;
        this.optionsMenu = new JPopupMenu();
        if (this.searchOptions != null) {
            object3 = this.searchOptions.getMap();
            object2 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() instanceof JCheckBox) {
                        JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                        String string = jCheckBox.getText();
                        SearchBar.this.searchOptions.set(string, jCheckBox.isSelected());
                        if (SearchBar.this.optionsNotifier != null) {
                            SearchBar.this.optionsNotifier.optionSelected(string);
                        }
                    }
                }
            };
            for (String object4 : object3.keySet()) {
                serializable = new JCheckBox(object4);
                boolean jLabel = (Boolean)object3.get(object4);
                serializable.setSelected(jLabel);
                serializable.setEnabled(true);
                this.optionsMenu.add((Component)serializable);
                serializable.addActionListener((ActionListener)object2);
            }
        }
        this.searchTextField.setEnabled(false);
        this.searchTextField.setText(this.resources.getString("SEARCHBAR.FIND"));
        object3 = this.fetchIcon.getIcon("SEARCH_FWD");
        this.searchFwdLabel = new JLabel();
        this.searchFwdLabel.setIcon((Icon)object3);
        this.searchFwdLabel.setSize(new Dimension(object3.getIconWidth(), object3.getIconHeight()));
        this.searchFwdLabel.setToolTipText(this.resources.getString("SEARCHBAR.SEARCH.FWD"));
        object3 = this.fetchIcon.getIcon("SEARCH_BACK");
        this.searchBckLabel = new JLabel();
        this.searchBckLabel.setIcon((Icon)object3);
        this.searchBckLabel.setSize(new Dimension(object3.getIconWidth(), object3.getIconHeight()));
        this.searchBckLabel.setToolTipText(this.resources.getString("SEARCHBAR.SEARCH.BCK"));
        object2 = new JPanel();
        ((Container)object2).add(this.searchFwdLabel);
        ((Container)object2).add(this.searchBckLabel);
        this.searchFwdLabel.setBackground(this.searchTextField.getBackground());
        this.searchBckLabel.setBackground(this.searchTextField.getBackground());
        ((JComponent)object2).setBackground(this.searchTextField.getBackground());
        this.setLayout(new GridBagLayout());
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("search.png"));
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("down.png"));
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 1;
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setBackground(this.searchTextField.getBackground());
        jLabel.setOpaque(false);
        ((GridBagConstraints)serializable).weightx = 0.0;
        this.add((Component)jLabel, serializable);
        this.downLabel = new JLabel(imageIcon2);
        if (this.searchOptions != null) {
            ((GridBagConstraints)serializable).weightx = 0.0;
            this.add((Component)this.downLabel, serializable);
        }
        this.setBorder(new SearchFieldBorder());
        this.searchTextField.setBorder(null);
        ((GridBagConstraints)serializable).weightx = 1.0;
        this.add((Component)this.searchTextField, serializable);
        this.setBackground(this.searchTextField.getBackground());
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).gridwidth = 1;
        this.add((Component)this.searchFwdLabel, serializable);
        ((GridBagConstraints)serializable).gridwidth = 0;
        this.add((Component)this.searchBckLabel, serializable);
        this.downLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SearchBar.this.optionsMenu.show(SearchBar.this.downLabel, mouseEvent.getX(), SearchBar.this.getY() + 5);
            }
        });
        this.searchTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!SearchBar.this.searchTextField.isEnabled()) {
                    SearchBar.this.searchTextField.setText("");
                    SearchBar.this.searchTextField.setEnabled(true);
                    SearchBar.this.searchTextField.requestFocusInWindow();
                }
            }
        });
        this.searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (!SearchBar.this.searchTextField.isEnabled()) {
                    SearchBar.this.searchTextField.setText("");
                    SearchBar.this.searchTextField.setEnabled(true);
                    SearchBar.this.searchTextField.requestFocusInWindow();
                }
            }
        });
    }

    public JTextField getSearchTextField() {
        return this.searchTextField;
    }

    public JLabel getSearchFwdLabel() {
        return this.searchFwdLabel;
    }

    public JLabel getSearchBckLabel() {
        return this.searchBckLabel;
    }

    public String getText() {
        return this.searchTextField.getText();
    }

    public boolean isOptionSelected(String string) {
        Map<String, Boolean> map = this.searchOptions.getMap();
        return map.get(string);
    }

    public void showSearchOptionsMenu() {
        this.optionsMenu.show(this.downLabel, 0, this.getY() + 15);
    }
}

