/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.dimension;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.jdbc.driver.OracleDriver;
import oracle.olap.app.dimension.SelectMemberTableModel;
import oracle.olap.app.ui.MultiLineTextArea;

public class SelectMemberDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private boolean clickedOK = false;
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private String selectedMember = null;
    private JTable membersTable;
    private Connection connection;
    private SelectMemberTableModel selectMemberTableModel;
    private JTextField txtFilter;
    private static final String DIALOG_DESC = "Select a dimension member.  Use the filter tool to help you find members.";

    public SelectMemberDialog(Connection connection, String string, String string2, String string3) {
        this.connection = connection;
        try {
            this.selectMemberTableModel = new SelectMemberTableModel(this.connection, string, string2, string3);
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(null, sQLException.getMessage(), "Initialization Error", 0);
            sQLException.printStackTrace();
            return;
        }
        this.render();
    }

    public SelectMemberDialog(Connection connection, String string, String string2) {
        this(connection, string, string2, null);
    }

    public String getSelectedMember() {
        return this.selectedMember;
    }

    private void render() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.add(jPanel);
        this.setTitle("Select a Dimension Member");
        Font font = new JLabel().getFont();
        MultiLineTextArea multiLineTextArea = new MultiLineTextArea(DIALOG_DESC);
        JLabel jLabel = new JLabel("Filter: ");
        jLabel.setToolTipText("Filter table by specifying SQL where clause conditions");
        this.txtFilter = new JTextField();
        this.txtFilter.addActionListener(this);
        this.txtFilter.setActionCommand("FILTER");
        jLabel.setLabelFor(this.txtFilter);
        jLabel.setDisplayedMnemonic('I');
        this.membersTable = new JTable(this.selectMemberTableModel);
        this.membersTable.setAutoResizeMode(3);
        ListSelectionModel listSelectionModel = this.membersTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        listSelectionModel.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.membersTable);
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        this.cancelButton.setActionCommand("CANCEL");
        this.cancelButton.addActionListener(this);
        JPanel jPanel2 = this.getButtonPanel();
        this.getRootPane().setDefaultButton(this.okButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 15, 10);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)multiLineTextArea, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 4, 0);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 10, 4, 10);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.txtFilter, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 10, 4, 10);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel2, gridBagConstraints);
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.okButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        return jPanel;
    }

    private void clearSelection() {
        this.selectedMember = null;
        this.membersTable.getSelectionModel().clearSelection();
    }

    public boolean clickedOK() {
        return this.clickedOK;
    }

    private void setWhereClause() {
        try {
            String string = this.txtFilter.getText();
            this.selectMemberTableModel.setWhereClause(string);
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(this, sQLException.getMessage(), "Invalid Query", 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand().toUpperCase();
        if (string.equals("FILTER")) {
            this.setWhereClause();
        } else if (string.equals("OK")) {
            this.clickedOK = true;
            this.setVisible(false);
        } else if (string.equals("CANCEL")) {
            this.clickedOK = false;
            this.setVisible(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = listSelectionEvent.getFirstIndex();
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (n == -1) {
            this.okButton.setEnabled(false);
        } else {
            this.selectedMember = this.selectMemberTableModel.getValueAt(n, 0).toString();
            this.okButton.setEnabled(true);
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "stacx25:1521:rmain3";
            DriverManager.registerDriver((Driver)new OracleDriver());
            String string2 = "jdbc:oracle:thin:@" + string;
            Connection connection = DriverManager.getConnection(string2, "global", "global");
            SelectMemberDialog selectMemberDialog = new SelectMemberDialog(connection, "GLOBAL", "PRODUCT94", "PRIMARY");
            selectMemberDialog.setSize(300, 450);
            selectMemberDialog.setLocationRelativeTo(null);
            selectMemberDialog.setModal(true);
            selectMemberDialog.setVisible(true);
            if (selectMemberDialog.clickedOK()) {
                System.out.println("Selected Member: " + selectMemberDialog.getSelectedMember());
            } else {
                System.out.println("Clicked Cancel");
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        System.exit(0);
    }
}

