/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.net.URL;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.model.Node;
import oracle.olap.OLAPArb;
import oracle.olap.actions.AbstractRenameChildObjectAction;
import oracle.olap.actions.OLAPObjectHelper;
import oracle.olap.cube.model.Cube;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.Descriptions;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasureNode;

public class RenameMeasureAction
extends AbstractRenameChildObjectAction {
    private String schemaName;
    private String cubeName;

    @Override
    protected void init() {
        Node node = this.getDBObject().getNode();
        URL uRL = node.getURL();
        this.schemaName = DBURLFormatHelper.getSchema((URL)uRL);
        Cube cube = OLAPObjectHelper.loadCube(this.getDBObject());
        this.setSchemaObjectWithDescription(cube);
    }

    @Override
    protected String getObjectCurrentName() {
        String string = "";
        if (this.isBaseMeasureNode()) {
            string = String.valueOf(this.getDBObject().getNode().getData());
        } else if (this.isCalculatedMeasureNode()) {
            CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)this.getDBObject().getNode();
            string = calculatedMeasureNode.getMeasureName();
        }
        return string;
    }

    @Override
    protected String getConfirmMessage(String string) {
        return null;
    }

    @Override
    protected String getConfirmTitle(String string) {
        String string2 = OLAPArb.format("MEASURE_RENAME_DLG_TITLE", string);
        return string2;
    }

    @Override
    protected String getProgressMessage(String string) {
        String string2 = OLAPArb.format("MEASURE_RENAME_PROGRESS_TITLE", string, this.getNewObjectName());
        return string2;
    }

    @Override
    protected String getSuccessMessage(String string) {
        String string2 = OLAPArb.format("MEASURE_RENAME_SUCCESS_MSG", string, this.getNewObjectName());
        return string2;
    }

    @Override
    protected String getErrorTitle(String string) {
        String string2 = OLAPArb.format("MEASURE_RENAME_ERROR_TITLE", string);
        return string2;
    }

    @Override
    protected Descriptions getRenameObject() {
        Cube cube = (Cube)this.getSchemaObjectWithDescription();
        AbstractChildObjectWithDesc abstractChildObjectWithDesc = null;
        abstractChildObjectWithDesc = this.isBaseMeasureNode() ? cube.findMeasure(this.getObjectName()) : cube.findCalculatedMeasure(this.getObjectName());
        return abstractChildObjectWithDesc;
    }

    @Override
    protected String getObjectName() {
        Node node = this.getDBObject().getNode();
        URL uRL = node.getURL();
        String string = null;
        this.schemaName = DBURLFormatHelper.getSchema((URL)uRL);
        if (this.isCalculatedMeasureNode()) {
            CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)node;
            string = (String)calculatedMeasureNode.getProperty("MEASURE_NAME");
            this.cubeName = (String)calculatedMeasureNode.getProperty("CUBE_NAME");
        } else if (this.getDBObject().getNode() instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)this.getDBObject().getNode();
            this.cubeName = (String)objectNode.getProperty("CUBE_NAME");
            string = String.valueOf(node.getData());
        }
        return string;
    }

    protected boolean isBaseMeasureNode() {
        boolean bl = true;
        Node node = this.getContext().getNode();
        if (node instanceof CalculatedMeasureNode) {
            bl = false;
        }
        return bl;
    }

    protected boolean isCalculatedMeasureNode() {
        boolean bl = false;
        Node node = this.getContext().getNode();
        if (node instanceof CalculatedMeasureNode) {
            bl = true;
        }
        return bl;
    }

    @Override
    protected AbstractChildObjectWithDesc getChildObject() {
        AbstractChildObjectWithDesc abstractChildObjectWithDesc = null;
        Cube cube = (Cube)this.getSchemaUpdatedObjectWithDescription();
        abstractChildObjectWithDesc = this.isBaseMeasureNode() ? cube.findMeasure(this.getObjectName()) : cube.findCalculatedMeasure(this.getObjectName());
        return abstractChildObjectWithDesc;
    }

    @Override
    protected String getObjectType() {
        return "MEASURE";
    }

    @Override
    protected boolean isObjectNameUnique(String string) {
        Cube cube = (Cube)this.getSchemaObjectWithDescription();
        if (this.isCalculatedMeasureNode()) {
            return cube.findCalculatedMeasure(string) == null;
        }
        if (this.isBaseMeasureNode()) {
            return cube.findMeasure(string) == null;
        }
        return false;
    }
}

