/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.ide.help.HelpSystem;
import oracle.javatools.db.Database;
import oracle.olap.OLAPArb;
import oracle.olap.util.OLAPNameValidator;
import oracle.olap.util.UIStringUtils;

public class RenameAWDialog
extends JDialog
implements ActionListener {
    private String oldAWName;
    private String owner;
    private JTextField oldAWNametf;
    private JTextField newAWNametf;
    private JPanel mainPanel;
    private final String OK_COMMAND = "OK_ID";
    private final String CANCEL_COMMAND = "CANCEL_ID";
    private final String HELP_COMMAND = "HELP_ID";
    private static final String TYPE = "AW";
    private JButton m_btnOK;
    private JButton m_btnCancel;
    private JButton m_btnHelp;
    private boolean okClicked = false;
    private Database database;

    public RenameAWDialog(Frame frame, String string, String string2, String string3, String string4, Database database) {
        super(frame, string, true);
        this.setName("RenameAWDialog");
        this.owner = string4;
        this.oldAWName = string3;
        this.database = database;
        this.initComponents();
        this.layoutComponents();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.mainPanel, string2);
        this.newAWNametf.requestFocus();
    }

    private void initComponents() {
        this.oldAWNametf = new JTextField(this.oldAWName);
        this.oldAWNametf.setEditable(false);
        this.newAWNametf = new JTextField();
        this.newAWNametf.setName("newAWNametf");
        UIStringUtils.setKeyAdapterToNameField(this.newAWNametf);
        this.initButtons();
    }

    private void initButtons() {
        this.m_btnOK = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_OK_BUTTON_TEXT")));
        this.m_btnOK.setName("m_btnOK");
        this.m_btnOK.setActionCommand("OK_ID");
        this.m_btnOK.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_OK_BUTTON_TEXT")));
        this.m_btnOK.addActionListener(this);
        this.m_btnCancel = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        this.m_btnCancel.setName("m_btnCancel");
        this.m_btnCancel.setActionCommand("CANCEL_ID");
        this.m_btnCancel.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        this.m_btnCancel.addActionListener(this);
        this.m_btnHelp = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.m_btnHelp.setName("m_btnHelp");
        this.m_btnHelp.setActionCommand("HELP_ID");
        this.m_btnHelp.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.m_btnHelp.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_btnOK);
    }

    private void layoutComponents() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setName("mainPanel");
        this.setMinimumSize(new Dimension(400, 120));
        JLabel jLabel = new JLabel(OLAPArb.getString("DESCRIPTION_PANEL_NAME_LABEL"));
        JLabel jLabel2 = new JLabel(OLAPArb.format("RENAME_DIALOG_NEW_NAME_LABEL", TYPE));
        this.mainPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        this.oldAWNametf.setMinimumSize(new Dimension(250, 20));
        this.mainPanel.add((Component)this.oldAWNametf, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 4);
        this.mainPanel.add((Component)this.newAWNametf, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(10, 4, 0, 4);
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.m_btnHelp, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)this.m_btnOK, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.m_btnCancel, DialogButtonBar.CONSTRAINT_CANCEL);
        this.mainPanel.add((Component)dialogButtonBar, gridBagConstraints);
        this.add(this.mainPanel);
        this.registerKeyboardActions();
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this, "CANCEL_ID", KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(156, 0), 1);
    }

    public boolean isOkClicked() {
        return this.okClicked;
    }

    public String getNewAWName() {
        return this.newAWNametf.getText();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("OK_ID")) {
            if (this.validateAWName()) {
                this.okClicked = true;
                this.setVisible(false);
            }
        } else if (actionEvent.getActionCommand().equals("HELP_ID")) {
            HelpSystem.getHelpSystem().showHelp((JComponent)this.mainPanel);
        } else {
            this.setVisible(false);
        }
    }

    private boolean validateAWName() {
        String string = this.newAWNametf.getText();
        if (!OLAPNameValidator.isNameValid(string, 26)) {
            return false;
        }
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.database.getConnection());
        return OLAPNameValidator.isAWNameUnique(string, dBUtil, this.owner);
    }
}

